<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/astpickle/M3AST_SC.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/astpickle/M3AST_SC.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA FIELDS *&gt;

INTERFACE <interface>M3AST_SC</interface>;
</PRE> This interface defines some additional attributes that make
   an AST <CODE>self contained</CODE>. Such an AST is capable of being pickled
   as a single entity, that is, with all references to entities
   on other ASTs represented (in the pickle) via surrogate nodes
   that provide for safe recombination when the AST is unpickled.


<P><PRE>IMPORT <A HREF="../ast/M3AST.i3">M3AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

TYPE
</PRE> Surrogate nodes that replace inter-AST references <CODE>multiply inherit</CODE>
   the <CODE>IMPORTED_NODE</CODE> class, which carries the information on how
   to locate the actual nodes. A <CODE>Unit_stub</CODE>, shared between all
   reference to the same unit, locates the unit by name, type
   and unique identifier (allowing version checks). The <CODE>sc_eoi</CODE>
   field of an <CODE>IMPORTED_NODE</CODE> is the index in the <CODE>sc_exported_node_s</CODE>
   of the <CODE>Compilation_Unit</CODE> node of the AST that the <CODE>sc_unit_stub</CODE> field 
   locates. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#IMPORTED_NODE">IMPORTED_NODE</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF IMPORTED_NODE
       sc_unit_stub: Unit_stub;
       sc_eoi: INTEGER *&gt;

  <A HREF="../astall/M3AST_all.i3#Unit_stub">Unit_stub</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF Unit_stub
       sc_unit_symrep: M3AST_LX.Symbol_rep;
       sc_unit_type: M3AST_FE.Unit_type;
       sc_unit_uid: M3AST_FE.Unit_uid;
  *&gt;
</PRE> The only inter-AST references thus far are to <CODE>DEF_ID</CODE> and
   <CODE>TYPE_SPEC</CODE> nodes. 

<P>  <PRE><A HREF="../astall/M3AST_all.i3#Imported_id">Imported_id</A> &lt;: M3AST_AS.DEF_ID;
  &lt;* FIELDS OF Imported_id
       sc_actual_id: M3AST_AS.DEF_ID;
       vIMPORTED_NODE: IMPORTED_NODE;  *&gt;

  <A HREF="../astall/M3AST_all.i3#Imported_type">Imported_type</A> &lt;: M3AST_AS.TYPE_SPEC;
  &lt;* FIELDS OF Imported_type
       sc_actual_type: M3AST_AS.TYPE_SPEC;
       vIMPORTED_NODE: IMPORTED_NODE; *&gt;

  <A HREF="../astall/M3AST_all.i3#Exported_node">Exported_node</A> &lt;: M3AST.NODE;
  &lt;* FIELDS OF Exported_node
       sc_actual_node: M3AST_AS.SRC_NODE; (* TYPE_SPEC or DEF_ID *) *&gt;

  &lt;* FIELDS OF M3AST_AS.Compilation_Unit
       sc_unit_stub_s: SEQUENCE OF Unit_stub;
       sc_exported_node_s: SEQUENCE OF Exported_node; *&gt;
</PRE> The <CODE>sc_exported_node_s</CODE> tabulates the nodes defined in the AST
   rooted at this node. The <CODE>sc_unit_stub_s</CODE> denotes the units
   to which this AST has inter-AST references. 

<P><PRE>END M3AST_SC.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
