<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/asttrans/M3GTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/asttrans/M3GTool.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3GTool.i3">M3GTool</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P>
<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, StdIO, <A HREF="../../../rw/src/Common/IO.i3">IO</A>, IOErr, <A HREF="#x1">Err</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, PathNameStream, PathName;
IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../ast/M3AST.i3">M3AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>;
IMPORT <A HREF="M3CImportASTrans.i3">M3CImportASTrans</A>;
IMPORT <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;

IMPORT <A HREF="../astdisplay/M3ASTDisplay.i3">M3ASTDisplay</A>, <A HREF="../ast/M3ASTWalk.i3">M3ASTWalk</A>;

CONST
  Version = &quot;5-Feb-92&quot;;

VAR
  tool_g: M3Args.T;

TYPE
  ContextClosure = M3Context.Closure OBJECT
    s: IO.Stream;
  OVERRIDES
    callback := DisplayGeneric;
  END;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(): M3Args.T RAISES {}=
  BEGIN
    RETURN tool_g;
  END Get;

PROCEDURE <A NAME="Run"><procedure>Run</procedure></A>(c: M3Context.T): INTEGER RAISES {}=
  BEGIN
    IF M3Args.Find(tool_g) THEN
      M3Context.ApplyToSet(c, NEW(ContextClosure, s := StdIO.Out()),
          M3CUnit.TypeSet{M3CUnit.Type.Interface_gen_ins,
                          M3CUnit.Type.Module_gen_ins});
      RETURN 0
    ELSE
      RETURN -1
    END;
  END Run;

PROCEDURE <A NAME="RunWithAST"><procedure>RunWithAST</procedure></A>(
    c: M3Context.T;
    cu: M3AST_AS.Compilation_Unit;
    s: IO.Stream)
    RAISES {IO.Error}=
  BEGIN
    DisplayGeneric(NEW(ContextClosure, s := s),
        M3CUnit.Type.Interface, (* value unimportant *)
        NIL,
        cu);
  END RunWithAST;

PROCEDURE <A NAME="DisplayGeneric"><procedure>DisplayGeneric</procedure></A>(
    cl: ContextClosure;
    ut: M3CUnit.Type;
    name: TEXT;
    cu: M3AST_AS.Compilation_Unit)
    RAISES {IO.Error}=
  BEGIN
    IF M3Conventions.PrimarySource IN cu.fe_status THEN
      IF M3Args.GetFlag(tool_g, SubstituteAP_Arg) THEN
        M3CImportASTrans.Set(cu, TRUE);
      END;
      M3ASTDisplay.Nodes(M3CUnit.ToGenIns(cu, ut), cl.s);
    END; (* if *)
  END DisplayGeneric;

BEGIN
  tool_g := M3Args.New(&quot;m3generic&quot;, &quot;Generic Unit Instantiation&quot;, Version);
  M3Args.RegisterFlag(tool_g, SubstituteAP_Arg,
    &quot;substitute actual parameters in unit body&quot;);
END M3GTool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
