<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chartool/M3CharExprsToConsider.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chartool/M3CharExprsToConsider.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CharExprsToConsider.i3">M3CharExprsToConsider</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_PG.i3">M3AST_PG</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_PG_F.i3">M3AST_PG_F</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>;
IMPORT <A HREF="../sem/M3CStdProcs.i3">M3CStdProcs</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>;
IMPORT <A HREF="M3CharPreds.i3">M3CharPreds</A>;

TYPE
  BitStack = REF RECORD
                   head: AST.NODE;
                   tail: BitStack   END;
    (* head=NIL is where Es warnings should be skipped *)

PROCEDURE <A NAME="Cons"><procedure>Cons</procedure></A> (head: AST.NODE; tail: BitStack): BitStack
  RAISES {} =
  BEGIN
    RETURN NEW(BitStack, head := head, tail := tail)
  END Cons;

REVEAL
  <A NAME="Handle">Handle</A> = Public BRANDED OBJECT
             consider, distant: BOOLEAN;
             inType           : BitStack  := NIL
           OVERRIDES
             callback := Node; END;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A> (consider, distant: BOOLEAN): Handle
  RAISES {} =
  BEGIN
    RETURN
      NEW(Handle, consider := consider, distant := distant).init();
  END NewHandle;

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A> (h: Handle; n: AST.NODE; vm: ASTWalk.VisitMode)
  RAISES {} =
  PROCEDURE NoteUsedId (u: M3AST_AS.USED_ID) =
    VAR
      e: M3AST_PG.EXTERNAL_ID;
      d                       := u.sm_def;
    BEGIN
      IF d # NIL AND M3AST_PG.IsA_EXTERNAL_ID(d, e) THEN
        IF e # NIL AND e.pg_external # NIL THEN
          TYPECASE d OF
          | M3AST_AS.TYPED_ID (tid) =&gt;
              IF tid.sm_type_spec # NIL
                   AND M3CharPreds.Tm(tid.sm_type_spec) THEN
                M3Error.WarnWithId(
                  n, &quot;Use of EXTERNAL Tm item %s&quot;, u.lx_symrep) END
          ELSE END END END;
    END NoteUsedId;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Subrange_type, M3AST_AS.Packed_type =&gt;
        CASE vm OF
        | ASTWalk.VisitMode.Entry =&gt;
            h.inType := Cons(NIL, h.inType);
        | ASTWalk.VisitMode.Exit =&gt;
            IF h.inType # NIL AND h.inType.head = NIL THEN
              h.inType := h.inType.tail
            ELSE
              M3Error.Report(n, &quot;inType broken&quot;) END (*if*); END (*case*);
    | M3AST_AS.TYPE_SPEC =&gt;
        CASE vm OF
        | ASTWalk.VisitMode.Entry =&gt;
            IF h.inType # NIL AND h.inType.head = NIL THEN
              h.inType := Cons(n, h.inType) END;
        | ASTWalk.VisitMode.Exit =&gt;
            IF h.inType # NIL AND h.inType.head = n THEN
              h.inType := h.inType.tail END; END (*case*);
    ELSE END (*typecase*);
    IF vm = ASTWalk.VisitMode.Entry THEN
      TYPECASE n OF
      | M3AST_AS.Exp_used_id (u) =&gt; NoteUsedId(u.vUSED_ID);
      | M3AST_AS.USED_ID (u) =&gt; NoteUsedId(u);
      | M3AST_AS.Call (call) =&gt;
          VAR
            st_call: M3CStdProcs.T;
            ta, tb : M3AST_AS.EXP;
            tat    : M3AST_AS.TYPE_SPEC;
          PROCEDURE Grade (ts: M3AST_AS.TYPE_SPEC):
            M3CharPreds.Char_Grade =
            VAR g: M3CharPreds.Char_Grade;
            BEGIN
              IF h.consider AND NOT h.distant THEN
                IF M3CharPreds.TC(ts, M3CharPreds.Ts) THEN
                  RETURN M3CharPreds.Char_Grade.TcTs
                ELSE
                  RETURN M3CharPreds.Char_Grade.No END END;
              g := M3CharPreds.Grade(ts);
              IF g = M3CharPreds.Char_Grade.TcTs AND NOT h.consider THEN
                g := M3CharPreds.Char_Grade.No END;
              RETURN g;
            END Grade;
          BEGIN
            IF NOT (h.inType # NIL AND h.inType.head = NIL) THEN
              IF M3CharPreds.Es(call) THEN
                M3Error.Warn(call, &quot;Expr depends on NUM(CHAR)&quot;) END; END;
            IF M3CStdProcs.IsStandardCall(call, st_call) THEN
              ta := SeqM3AST_AS_EXP.First(call.sm_actual_s);
              tat := ta.sm_exp_type_spec;
              CASE st_call OF
              | M3CStdProcs.T.Subarray =&gt;
                  IF M3CharPreds.Tr(tat) THEN
                    M3Error.Warn(
                      call, &quot;SUBARRAY of a changing array&quot;); END;

              | M3CStdProcs.T.Ord =&gt;
                  IF ta.sm_exp_value = NIL AND M3CharPreds.Tn(tat) THEN
                    M3Error.Warn(
                      call,
                      &quot;ORD(var in NUM(CHAR)-dependent type)&quot;); END;

              | M3CStdProcs.T.Val =&gt;
                  tb := SeqM3AST_AS_EXP.Ith(call.sm_actual_s, 1);
                  IF M3CharPreds.Tn(tb.sm_exp_type_spec) THEN
                    M3Error.Warn(
                      call, &quot;VAL(..., NUM(CHAR)-dependent type)&quot;); END;

              | M3CStdProcs.T.Loophole =&gt;
                  CASE Grade(tat) OF
                  | M3CharPreds.Char_Grade.No =&gt;
                  | M3CharPreds.Char_Grade.Td =&gt;
                      M3Error.Warn(
                        call,
                        &quot;LOOPHOLE from a type related to CHAR&quot;);
                  | M3CharPreds.Char_Grade.TcTs =&gt;
                      M3Error.Warn(
                        call,
                        &quot;LOOPHOLE from a CHAR-size-dependent type&quot;); END (*case*);
                  tb := SeqM3AST_AS_EXP.Ith(call.sm_actual_s, 1);
                  CASE Grade(tb.sm_exp_type_spec) OF
                  | M3CharPreds.Char_Grade.No =&gt;
                  | M3CharPreds.Char_Grade.Td =&gt;
                      M3Error.Warn(
                        call, &quot;LOOPHOLE to a type related to CHAR&quot;);
                  | M3CharPreds.Char_Grade.TcTs =&gt;
                      M3Error.Warn(
                        call,
                        &quot;LOOPHOLE to a CHAR-size-dependent type&quot;); END (*case*);

              | M3CStdProcs.T.Adr =&gt;
                  CASE Grade(tat) OF
                  | M3CharPreds.Char_Grade.No =&gt;
                  | M3CharPreds.Char_Grade.Td =&gt;
                      M3Error.Warn(
                        call, &quot;ADR of a type related to CHAR&quot;);
                  | M3CharPreds.Char_Grade.TcTs =&gt;
                      M3Error.Warn(
                        call, &quot;ADR of a CHAR-size-dependent type&quot;); END (*case*);

              ELSE END; END;
          END;

      ELSE END (* typecase *);

      END (* if *);

  END Node;
BEGIN

END M3CharExprsToConsider.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
