<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chartool/M3CharExprsToReplace.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chartool/M3CharExprsToReplace.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CharExprsToReplace.i3">M3CharExprsToReplace</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>;
IMPORT <A HREF="M3CharPreds.i3">M3CharPreds</A>;

REVEAL
  <A NAME="Handle">Handle</A> = Public BRANDED OBJECT OVERRIDES callback := Node; END;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A> (): Handle RAISES {} =
  BEGIN
    RETURN NEW(Handle).init();
  END NewHandle;

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A> (&lt;*UNUSED*&gt; h : Handle;
                           n : AST.NODE;
                           vm: ASTWalk.VisitMode) RAISES {} =
  BEGIN
    IF vm = ASTWalk.VisitMode.Entry THEN
      TYPECASE n OF
      | M3AST_AS.Index (x) =&gt;
          IF M3CharPreds.Tr(x.as_array.sm_exp_type_spec) THEN
            M3Error.Warn(n, &quot;indexing into changing array&quot;); END; (* if *)

      | M3AST_AS.Constructor (x) =&gt;
          IF M3CharPreds.Tr(M3CharPreds.M3TYPE_To_TYPE_SPEC(x.as_type)) THEN
            M3Error.Warn(n, &quot;cons of val in changing type&quot;); END; (* if *)

      | M3AST_AS.NEWCall (call) =&gt;
          WITH tae = SeqM3AST_AS_EXP.First(
                       call.sm_actual_s).sm_exp_type_spec DO
            IF (ISTYPE(tae, M3AST_AS.Ref_type)
                  AND M3CharPreds.TC(
                        M3CharPreds.M3TYPE_To_TYPE_SPEC(
                          NARROW(tae, M3AST_AS.Ref_type).as_type),
                        M3CharPreds.Tr)) OR M3CharPreds.TCO(tae, M3CharPreds.Tr) THEN
              M3Error.Warn(call, &quot;NEW of container of changing type&quot;); END; END;

      | M3AST_AS.Select =&gt;

      | M3AST_AS.BINARY (x) =&gt;
          IF M3CharPreds.Tr(x.as_exp1.sm_exp_type_spec)
               OR M3CharPreds.Tr(x.as_exp2.sm_exp_type_spec) THEN
            M3Error.Warn(
                x, &quot;binary operation on val in changing type&quot;); END; (* if *)

      ELSE END;                  (* typecase *)
      END;                       (* if *)
  END Node;

BEGIN

END M3CharExprsToReplace.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
