<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chartool/M3CharPreds.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chartool/M3CharPreds.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CharPreds.m3">M3CharPreds</A></interface>;

IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../toolmisc/M3Error.i3">M3Error</A>;

PROCEDURE <A HREF="M3CharPreds.m3#Es">Es</A> (e: M3AST_AS.EXP): BOOLEAN;
  (* constant expression that introduces dependency CHAR:
     *SIZE(TC(Ts))
     FIRST|LAST|NUMBER([a] Tn) *)

PROCEDURE <A HREF="M3CharPreds.m3#Ecs">Ecs</A> (e: M3AST_AS.EXP): BOOLEAN;
  (* constant expression that depends on CHAR:
     Es
     VAL(Ecs, ...)
     binary or unary value combination (Ecs, ...)
     Word operation on Ecs, ...
     value cons ...{...Ecs, ...}
     Ecs.f
     Ecs[...]
     ...[Ecs] *)

PROCEDURE <A HREF="M3CharPreds.m3#Tn">Tn</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* type whose FIRST, LAST, or NUMBER depends on CHAR:
     CHAR
     ARRAY Tn OF ...
     [...Ecs...] *)

PROCEDURE <A HREF="M3CharPreds.m3#Th">Th</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* type that will become impractically large (&quot;Huge&quot;):
     ARRAY Tn OF ...
     SET OF Tn *)

PROCEDURE <A HREF="M3CharPreds.m3#Tr">Tr</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* type that will be replaced:
     Th
     BITS Ecs FOR ...
     BITS ...  FOR TC(Ts) *)

PROCEDURE <A HREF="M3CharPreds.m3#Ts">Ts</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* type whose size introduces dependency on CHAR:
     Tn
     Tr *)

TYPE
  PredTypeProc = PROCEDURE (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
    (* procedure type for passing as argument to &quot;TC&quot; *)

PROCEDURE <A HREF="M3CharPreds.m3#TC">TC</A> (ts: M3AST_AS.TYPE_SPEC; tp: PredTypeProc): BOOLEAN;
  (* maps kind Tx to kind of types that contain a Tx:
     Tx
     RECORD ... f: TC(Tx) ... END
     ARRAY ... OF TC(Tx)
     BITS ...  FOR TC(Tx) *)

PROCEDURE <A HREF="M3CharPreds.m3#TCO">TCO</A> (ts: M3AST_AS.TYPE_SPEC; tp: PredTypeProc): BOOLEAN;
  (* maps kind Tx to kind of object types that contain a Tx:
     ...  OBJECT ...  f: TC(Tx) ... END
     (* a TC(Tx) anywhere in type hierarchy *) *)

PROCEDURE <A HREF="M3CharPreds.m3#Tm">Tm</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* type that mentions CHAR in any way *)

TYPE
  Char_Grade =
    {No (* not in Tm *),
     Td (* Tm - TC(Ts) *),
     TcTs (* TC(Ts) *)};

PROCEDURE <A HREF="M3CharPreds.m3#Grade">Grade</A> (ts: M3AST_AS.TYPE_SPEC): Char_Grade;
  (* Determine whether this type is in TC(Ts), Td, or neither *)

PROCEDURE <A HREF="M3CharPreds.m3#ArrayTnOf">ArrayTnOf</A> (ts: M3AST_AS.TYPE_SPEC): BOOLEAN;
  (* TRUE iff &quot;ts&quot; denotes an &quot;ARRAY Tn OF ...&quot; *)
</PRE> A few random conveniences... 

<P><PRE>PROCEDURE <A HREF="M3CharPreds.m3#M3TYPE_To_TYPE_SPEC">M3TYPE_To_TYPE_SPEC</A> (m: M3AST_AS.M3TYPE):
  M3AST_AS.TYPE_SPEC;
  (* M3CTypesMisc.GetTYPE_SPECFromM3TYPE recast as a function *)

PROCEDURE <A HREF="M3CharPreds.m3#ReportInUnit">ReportInUnit</A>(unit   : M3AST_AS.UNIT_ID;
                       n      : M3Error.ERROR_NODE;
                       message: TEXT) RAISES {};
  (* Like M3Error.Report, but for a (potentially) different
     compilation unit. *)

END M3CharPreds.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
