<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chartool/M3CharStatsToConsider.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chartool/M3CharStatsToConsider.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CharStatsToConsider.i3">M3CharStatsToConsider</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;
IMPORT <A HREF="../ast/M3AST_PG.i3">M3AST_PG</A>, <A HREF="../ast/M3AST_PG_F.i3">M3AST_PG_F</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_Var_id.i3">SeqM3AST_AS_Var_id</A>, <A HREF="../../derived/SeqM3AST_AS_Field_id.i3">SeqM3AST_AS_Field_id</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>, <A HREF="../../derived/SeqM3AST_AS_M3TYPE.i3">SeqM3AST_AS_M3TYPE</A>,
       <A HREF="../../derived/SeqM3AST_AS_FORMAL_ID.i3">SeqM3AST_AS_FORMAL_ID</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../sem/M3CStdProcs.i3">M3CStdProcs</A>, <A HREF="../sem/M3ASTNext.i3">M3ASTNext</A>, <A HREF="../misc/M3Assert.i3">M3Assert</A>, <A HREF="../sem/M3CTypesMisc.i3">M3CTypesMisc</A>;
IMPORT <A HREF="../syn/M3CSrcPos.i3">M3CSrcPos</A>;
IMPORT <A HREF="M3CharPreds.i3">M3CharPreds</A>;

TYPE
  RefStack = REF RECORD
                   len : INTEGER               := 0;
                   elts: REF ARRAY OF REFANY;
                   next: RefStack              := NIL END;

PROCEDURE <A NAME="RefStack_Push"><procedure>RefStack_Push</procedure></A> (rs: RefStack; elt: REFANY) RAISES {} =
  BEGIN
    IF rs.len = NUMBER(rs.elts^) THEN
      WITH na = NEW(REF ARRAY OF REFANY, rs.len * 2) DO
        FOR i := 0 TO rs.len - 1 DO na[i] := rs.elts[i] END;
        rs.elts := na; END END;
    rs.elts[rs.len] := elt;
    INC(rs.len);
  END RefStack_Push;

PROCEDURE <A NAME="RefStack_Pop"><procedure>RefStack_Pop</procedure></A> (rs: RefStack; elt: REFANY) RAISES {} =
  BEGIN
    IF rs.elts[rs.len - 1] # elt THEN
      M3Error.ReportAtPos(M3CSrcPos.Null, &quot;RefStack_Pop fails&quot;)
    ELSE
      DEC(rs.len) END
  END RefStack_Pop;

VAR
  stackPool           := NEW(MUTEX);
  stacks   : RefStack := NIL;

REVEAL
  <A NAME="Handle">Handle</A> = Public BRANDED OBJECT
             results: RefStack
           OVERRIDES
             callback := Node; END;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A> (): Handle RAISES {} =
  VAR rs: RefStack;
  BEGIN
    LOCK stackPool DO
      IF stacks = NIL THEN
        rs := NEW(RefStack, elts := NEW(REF ARRAY OF REFANY, 100));
      ELSE
        rs := stacks;
        stacks := stacks.next END; END;
    TRY
      RETURN NEW(Handle, results := rs).init()
    FINALLY
      LOCK stackPool DO rs.next := stacks; stacks := rs; END END
  END NewHandle;

CONST noteDullDecls = FALSE;

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A> (h: Handle; n: AST.NODE; vm: ASTWalk.VisitMode)
  RAISES {} =
  VAR e: M3AST_PG.EXTERNAL_ID;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Proc_decl (pd) =&gt;
        CASE vm OF
        | ASTWalk.VisitMode.Entry =&gt;
            RefStack_Push(h.results, pd.as_type.as_result_type);
        | ASTWalk.VisitMode.Exit =&gt;
            RefStack_Pop(h.results, pd.as_type.as_result_type); END;
    ELSE END;
    IF vm = ASTWalk.VisitMode.Entry THEN
      IF n # NIL AND M3AST_PG.IsA_EXTERNAL_ID(n, e) THEN
        IF e # NIL AND e.pg_external # NIL THEN
          TYPECASE n OF
          | M3AST_AS.TYPED_ID (tid) =&gt;
              IF tid.sm_type_spec # NIL
                   AND M3CharPreds.Tm(tid.sm_type_spec) THEN
                M3Error.WarnWithId(
                  n, &quot;Decl of EXTERNAL Tm item %s&quot;, tid.lx_symrep)
              ELSIF noteDullDecls THEN
                M3Error.WarnWithId(
                  n, &quot;Decl of EXTERNAL non-Tm item %s&quot;,
                  tid.lx_symrep) END
          ELSE END END END;

      TYPECASE n OF
      | M3AST_AS.NEWCall (call) =&gt;
          IF call.as_param_s = NIL THEN
            M3Error.Report(call, &quot;NIL call.as_param_s&quot;);
          ELSE
            VAR
              a0      := SeqM3AST_AS_Actual.First(call.as_param_s);
              rfcType := EXP_TYPE_To_TS(call, a0.as_exp_type);
              rfcTS := M3CTypesMisc.CheckedUnpack(
                         M3CharPreds.M3TYPE_To_TYPE_SPEC(rfcType));
              nOpen := CountOpen(rfcTS);
              iter_a := SeqM3AST_AS_Actual.NewIter(call.as_param_s);
              a_len := SeqM3AST_AS_Actual.Length(call.as_param_s);
              actual: M3AST_AS.Actual;
            BEGIN
              IF nOpen + 1 &gt; a_len THEN
                M3Error.Warn(
                  call, &quot;Fewer actuals than levels of open array&quot;);
                RETURN END;
              IF nOpen + 1 = a_len THEN RETURN END;
              FOR i := 0 TO nOpen DO
                IF NOT SeqM3AST_AS_Actual.Next(iter_a, actual) THEN
                  M3Error.Report(
                    call, &quot;Alleged open actual fails to enumerate&quot;); END; END;
              FOR i := nOpen + 1 TO a_len - 1 DO
                IF NOT SeqM3AST_AS_Actual.Next(iter_a, actual) THEN
                  M3Error.Report(
                    call,
                    &quot;SeqM3AST_AS_Actual.Next exhausted before alleged length&quot;);
                  RETURN END;
                TYPECASE actual.as_exp_type OF
                | M3AST_AS.M3TYPE =&gt;
                    M3Error.Report(actual, &quot;Actual is a TYPE&quot;);
                | M3AST_AS.EXP (ae) =&gt;
                    TYPECASE actual.as_id OF
                    | NULL =&gt;
                        M3Error.Warn(actual, &quot;Actual.as_id=NIL&quot;);
                    | M3AST_AS.Exp_used_id (e) =&gt;
                        TYPECASE e.vUSED_ID.sm_def OF
                        | NULL =&gt;
                            M3Error.Warn(
                              actual,
                              &quot;actual.as_id.vUSED_ID.sm_def=NIL&quot;);
                        | M3AST_AS.Field_id (fid) =&gt;
                            IF ae.sm_exp_type_spec # NIL THEN
                              CheckAssign(
                                actual, ae.sm_exp_type_spec,
                                fid.sm_type_spec); END
                        ELSE
                          M3Error.Warn(
                            actual,
                            &quot;Weird actual.as_id.vUSED_ID.sm_def&quot;); END
                    ELSE
                      M3Error.Warn(actual, &quot;Weird actual.as_id&quot;); END;
                ELSE END (*typecase*); END (*do*);
            END END;
      | M3AST_AS.Call (call) =&gt;
          VAR st_call: M3CStdProcs.T;
          BEGIN
            IF M3CStdProcs.IsStandardCall(call, st_call) THEN
              CASE st_call OF
              | M3CStdProcs.T.Inc, M3CStdProcs.T.Dec =&gt;
                  WITH ta = SeqM3AST_AS_EXP.First(call.sm_actual_s) DO
                    IF M3CharPreds.Tn(ta.sm_exp_type_spec) THEN
                      M3Error.Warn(
                        call,
                        &quot;INC/DEC of a NUM(CHAR)-dependent type&quot;); END; END;
              ELSE END;
            ELSE
              (* not a builtin call *)
              VAR
                iter_a := SeqM3AST_AS_EXP.NewIter(call.sm_actual_s);
                exp: M3AST_AS.EXP;
                proc_type := NARROW(
                               call.as_callexp.sm_exp_type_spec,
                               M3AST_AS.Procedure_type);
                iter_f       : M3ASTNext.IterFormal;
                hidden_formal: BOOLEAN;
                formal_param : M3AST_AS.Formal_param;
                formal_id    : M3AST_AS.FORMAL_ID;
                formal_type  : M3AST_AS.TYPE_SPEC;
                hidden_tid   : M3AST_AS.Type_id;
                formal_sym   : M3AST_LX.Symbol_rep;
                check_copy   : BOOLEAN;
              BEGIN
                IF proc_type = NIL THEN RETURN END;
                hidden_formal :=
                  proc_type.sm_def_id # NIL
                    AND ISTYPE(
                          proc_type.sm_def_id, M3AST_AS.Type_id);
                iter_f :=
                  M3ASTNext.NewIterFormal(
                    proc_type.as_formal_param_s);

                WHILE SeqM3AST_AS_EXP.Next(iter_a, exp) DO
                  IF hidden_formal THEN (* T.m *)
                    hidden_formal := FALSE;
                    hidden_tid :=
                      NARROW(proc_type.sm_def_id, M3AST_AS.Type_id);
                    formal_type := hidden_tid.sm_type_spec;
                    formal_sym := hidden_tid.lx_symrep;
                    check_copy := TRUE;
                  ELSE
                    M3Assert.Check(
                      M3ASTNext.Formal(
                        iter_f, formal_param, formal_id));
                    formal_sym := formal_id.lx_symrep;
                    formal_type := formal_id.sm_type_spec;
                    TYPECASE formal_id OF &lt;*NOWARN*&gt;
                    | M3AST_AS.F_Value_id =&gt; check_copy := TRUE;
                    | M3AST_AS.F_Var_id, M3AST_AS.F_Readonly_id =&gt;
                        check_copy := FALSE; END; END; (* if *)
                  CheckAssign(
                    call, exp.sm_exp_type_spec, formal_type,
                    formal_sym, check_copy := check_copy); END; (* while *)
              END; END;
          END;

      | M3AST_AS.Raise_st (r) =&gt;
          IF r.as_exp_void # NIL THEN
            TYPECASE r.as_qual_id.as_id.sm_def OF
            | NULL =&gt;
                M3Error.Report(r, &quot;r.as_qual_id.as_id.sm_def=NIL&quot;);
            | M3AST_AS.TYPED_ID (tid) =&gt;
                CheckAssign(
                  r, r.as_exp_void.sm_exp_type_spec,
                  tid.sm_type_spec, check_copy := FALSE);
            ELSE
              M3Error.Report(r, &quot;Weird r.as_qual_id.as_id.sm_def&quot;); END END;

      | M3AST_AS.Handler_id (hid) =&gt;
          IF hid.sm_type_spec # NIL THEN
            CheckAssign(hid, hid.sm_type_spec, hid.sm_type_spec);
          ELSE
            M3Error.Report(hid, &quot;Unset Handler_id.sm_type_spec&quot;); END;

      | M3AST_AS.Return_st (r) =&gt;
          IF h.results.len = 0 THEN
            M3Error.Report(n, &quot;RETURN outside PROC decl&quot;)
          ELSIF r.as_exp = NIL THEN
            EVAL 0
          ELSE
            TYPECASE h.results.elts[h.results.len - 1] OF
            | M3AST_AS.M3TYPE (t) =&gt;
                CheckAssign(
                  r, r.as_exp.sm_exp_type_spec,
                  M3CharPreds.M3TYPE_To_TYPE_SPEC(t), check_copy := FALSE);
            ELSE
              M3Error.Report(r, &quot;RETURN to non-M3TYPE&quot;) END END;

      | M3AST_AS.Var_decl (vd) =&gt;
          IF vd.as_default # NIL THEN
            CheckAssign(
              vd, vd.as_default.sm_exp_type_spec,
              SeqM3AST_AS_Var_id.First(vd.as_id_s).sm_type_spec); END;

      | M3AST_AS.Formal_param (fp) =&gt;
          VAR
            ff  := SeqM3AST_AS_FORMAL_ID.First(fp.as_id_s);
            fts := ff.sm_type_spec;
          BEGIN
            IF fp.as_default # NIL THEN
              CheckAssign(
                fp, fp.as_default.sm_exp_type_spec, fts,
                check_copy := FALSE); END;
            TYPECASE ff OF &lt;*NOWARN*&gt;
            | M3AST_AS.F_Value_id =&gt;
                CheckAssign(fp, fts, fts, check_assy := FALSE);
            | M3AST_AS.F_Var_id, M3AST_AS.F_Readonly_id =&gt; EVAL 0; END;

          END;

      | M3AST_AS.Fields (fs) =&gt;
          WITH fid = SeqM3AST_AS_Field_id.First(fs.as_id_s) DO
            TYPECASE fid.vRECOBJ_ID.sm_enc_type_spec OF
            | NULL =&gt;
                M3Error.Report(
                  fs, &quot;fid.vRECOBJ_ID.sm_enc_type_spec=NIL&quot;);
            | M3AST_AS.Record_type =&gt; EVAL 0;
            | M3AST_AS.Object_type =&gt;
                IF M3CharPreds.TC(fid.sm_type_spec, M3CharPreds.Tr) THEN
                  M3Error.Warn(
                    fs, &quot;Object field containing changing type&quot;) END;
            ELSE
              M3Error.Report(
                fs, &quot;Weird fid.vRECOBJ_ID.sm_enc_type_spec&quot;) END;
            IF fs.as_default # NIL THEN
              CheckAssign(
                fs, fs.as_default.sm_exp_type_spec,
                fid.sm_type_spec); END; END;

      | M3AST_AS.Assign_st (as_st) =&gt;
          CheckAssign(
            as_st, as_st.as_rhs_exp.sm_exp_type_spec,
            as_st.as_lhs_exp.sm_exp_type_spec);
      ELSE END;                  (* typecase *)
      END;                       (* if *)
  END Node;

PROCEDURE <A NAME="CheckAssign"><procedure>CheckAssign</procedure></A> (n             : AST.NODE;
                       ts_from, ts_to: M3AST_AS.TYPE_SPEC;
                       formal: M3AST_LX.Symbol_rep := NIL;
                       check_assy, check_copy := TRUE) =
  BEGIN
    IF ts_from = NIL OR ts_to = NIL THEN
      M3Error.Report(n, &quot;ts_from or ts_to is NIL&quot;)
    ELSE
      IF check_assy AND ts_from # ts_to
           AND (M3CharPreds.TC(ts_from, M3CharPreds.ArrayTnOf)
                  OR M3CharPreds.TC(ts_to, M3CharPreds.ArrayTnOf)) THEN
        IF formal # NIL THEN
          M3Error.WarnWithId(
            n,
            &quot;assignment to/from NUM(CHAR)-dependent array at formal %s&quot;,
            formal);
        ELSE
          M3Error.Warn(
            n, &quot;assignment to/from NUM(CHAR)-dependent array&quot;); END; END; END;
    IF check_copy AND ts_to # NIL AND M3CharPreds.TC(ts_to, M3CharPreds.Th) THEN
      IF formal # NIL THEN
        M3Error.WarnWithId(
          n, &quot;Copy of becoming-huge value at formal %s&quot;, formal);
      ELSE
        M3Error.Warn(n, &quot;Copy of becoming-huge value&quot;); END; END;
  END CheckAssign;

PROCEDURE <A NAME="CountOpen"><procedure>CountOpen</procedure></A> (ts: M3AST_AS.TYPE_SPEC): INTEGER =
  VAR rts := M3CTypesMisc.Reveal(ts);
  PROCEDURE PerArray (t: M3AST_AS.M3TYPE): INTEGER =
    VAR ts := M3CharPreds.M3TYPE_To_TYPE_SPEC(t);
    BEGIN
      TYPECASE ts OF
      | NULL =&gt; RETURN 0;
      | M3AST_AS.Array_type (at) =&gt;
          WITH nat = at.sm_norm_type DO
            IF SeqM3AST_AS_M3TYPE.Empty(nat.as_indextype_s)
                 OR SeqM3AST_AS_M3TYPE.First(nat.as_indextype_s)
                      = NIL THEN
              RETURN 1 + PerArray(nat.as_elementtype) END; END
      ELSE END;
      RETURN 0;
    END PerArray;
  BEGIN
    TYPECASE rts OF
    | NULL =&gt; RETURN 0;
    | M3AST_AS.Ref_type (rt) =&gt; RETURN PerArray(rt.as_type);
    ELSE
      RETURN 0 END;
  END CountOpen;

PROCEDURE <A NAME="EXP_TYPE_To_TS"><procedure>EXP_TYPE_To_TS</procedure></A> (call: M3AST_AS.NEWCall;
                          et  : M3AST_AS.EXP_TYPE ):
  M3AST_AS.TYPE_SPEC =
  PROCEDURE UI (ui: M3AST_AS.USED_ID): M3AST_AS.TYPE_SPEC =
    BEGIN
      TYPECASE ui.sm_def OF
      | NULL =&gt; M3Error.Report(call, &quot;ui.sm_def=NIL&quot;);
      | M3AST_AS.Type_id (tid) =&gt;
          IF tid.sm_type_spec # NIL THEN
            RETURN tid.sm_type_spec
          ELSE
            M3Error.Report(call, &quot;ui.sm_def._type_spec=NIL&quot;); END;
      ELSE
        M3Error.Report(call, &quot;Weird ui.sm_def&quot;) END;
      RETURN NIL;
    END UI;
  BEGIN
    TYPECASE et OF
    | M3AST_AS.M3TYPE (t) =&gt; RETURN M3CharPreds.M3TYPE_To_TYPE_SPEC(t);
    | M3AST_AS.Exp_used_id (eui) =&gt; RETURN UI(eui.vUSED_ID);
    | M3AST_AS.Select (b) =&gt;
        TYPECASE b.as_id OF
        | NULL =&gt;
            M3Error.Report(
              call, &quot;1st arg to NEW() is Select(.., NIL)&quot;);
        | M3AST_AS.Exp_used_id (eui) =&gt; RETURN UI(eui.vUSED_ID);
        (*********************
        ELSE
          M3Error.Report(
            call, &quot;1st arg to NEW() is Select(.., weird)&quot;)
        **********************)
        END;
        RETURN NIL;
    | M3AST_AS.Bad_EXP =&gt;
        M3Error.Report(call, &quot;1st arg to NEW() is Bad_EXP&quot;);
    | M3AST_AS.EXP =&gt;
        M3Error.Report(call, &quot;1st arg to NEW() is an expr&quot;);
    ELSE
      M3Error.Report(call, &quot;Weird 1st arg to NEW()&quot;); END;
    RETURN NIL;
  END EXP_TYPE_To_TS;

BEGIN

END M3CharStatsToConsider.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
