<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chartool/M3CharTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chartool/M3CharTool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CharTool.i3">M3CharTool</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;
IMPORT <A HREF="../fe/M3CGo.i3">M3CGo</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>;
IMPORT <A HREF="M3CharTypesToChange.i3">M3CharTypesToChange</A>, <A HREF="M3CharStatsToConsider.i3">M3CharStatsToConsider</A>,
       <A HREF="M3CharExprsToReplace.i3">M3CharExprsToReplace</A>, <A HREF="M3CharExprsToConsider.i3">M3CharExprsToConsider</A>;

CONST Version = &quot;Sep-28-92&quot;;

VAR tool_g: M3Args.T;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (): M3Args.T RAISES {} =
  BEGIN
    RETURN tool_g;
  END Get;

TYPE
  Extension =
    M3CGo.Extension OBJECT OVERRIDES extend := Extend END;

TYPE
  ASTWalkClosure =
    ASTWalk.Closure OBJECT
      typesToChangeHandle  : M3CharTypesToChange.Handle   := NIL;
      statsToConsiderHandle: M3CharStatsToConsider.Handle := NIL;
      exprsToReplaceHandle : M3CharExprsToReplace.Handle  := NIL;
    OVERRIDES
      callback := Node; END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () RAISES {} =
  BEGIN
    M3CGo.AddExtension(NEW(Extension));
  END Init;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A> (&lt;*UNUSED*&gt; e      : M3CGo.Extension;
                  &lt;*UNUSED*&gt; context: M3Context.T;
                             cu     : M3AST_AS.Compilation_Unit;
                  &lt;*UNUSED*&gt; VAR (*inout*) phases: M3CUnit.Status; )
  RAISES {} =
  VAR
    exprsToConsider_Arg := M3Args.GetFlag(tool_g, ExprsToConsider_Arg);
    typesToChange_Arg := M3Args.GetFlag(tool_g, TypesToChange_Arg);
    statsToConsider_Arg := M3Args.GetFlag(tool_g, StatsToConsider_Arg);
    exprsToReplace_Arg := M3Args.GetFlag(tool_g, ExprsToReplace_Arg);
    exprsDistantlyRelated_Arg := M3Args.GetFlag(
                       tool_g, ExprsDistantlyRelated_Arg);
    all    := M3Args.GetFlag(tool_g, ConsiderAll_Arg);
    do_etc := all OR exprsToConsider_Arg;
    do_edr := all OR exprsDistantlyRelated_Arg;
    any := all OR exprsToConsider_Arg OR typesToChange_Arg OR
               statsToConsider_Arg OR exprsToReplace_Arg OR
               exprsDistantlyRelated_Arg;
  BEGIN
    IF M3Conventions.PrimarySource IN cu.fe_status
         AND M3CUnit.State.SemChecked IN cu.fe_status THEN
      IF any THEN
        IF cu.fe_status * M3CUnit.Errors = M3CUnit.Status{} THEN
          TYPECASE cu.as_root OF
           | NULL =&gt;
             (* no tree to analyse *)

           | M3AST_AS.UNIT_GEN_DEF =&gt;
             (* ignore generic definitions *)

          ELSE
            WITH cl = NEW(ASTWalkClosure) DO
              IF all OR typesToChange_Arg THEN
                cl.typesToChangeHandle :=
                  M3CharTypesToChange.NewHandle(); END;
              IF all OR statsToConsider_Arg THEN
                cl.statsToConsiderHandle :=
                  M3CharStatsToConsider.NewHandle(); END;
              IF all OR exprsToReplace_Arg THEN
                cl.exprsToReplaceHandle :=
                  M3CharExprsToReplace.NewHandle(); END;

              IF any THEN
                &lt;*FATAL ANY*&gt; BEGIN
                  ASTWalk.ModeVisitNodes(
                      cu, cl, ASTWalk.OnEntryAndExit);
                END;
              END;
            END (* with *);
            IF do_etc OR do_edr THEN
              &lt;*FATAL ANY*&gt; BEGIN
                ASTWalk.ModeVisitNodes(
                    cu, M3CharExprsToConsider.NewHandle(do_etc, do_edr),
                    ASTWalk.OnEntryAndExit);
              END;
            END (*if*);
          END; (* typecase *)
        ELSE
          M3Error.Warn(cu.as_root,
                       &quot;'m3chartool' analysis suppressed due to errors&quot;);
        END;
      END;
    END;
  END Extend;

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A> (cl: ASTWalkClosure;
                n : AST.NODE;
                vm: ASTWalk.VisitMode) =
  BEGIN
    IF cl.typesToChangeHandle # NIL THEN
      M3CharTypesToChange.Node(cl.typesToChangeHandle, n, vm) END;
    IF cl.statsToConsiderHandle # NIL THEN
      M3CharStatsToConsider.Node(cl.statsToConsiderHandle, n, vm) END;
    IF cl.exprsToReplaceHandle # NIL THEN
      M3CharExprsToReplace.Node(cl.exprsToReplaceHandle, n, vm) END;
  END Node;

BEGIN
  tool_g :=
    M3Args.New(
      &quot;m3char&quot;, &quot;analyse code for CHAR size dependencies&quot;, Version);
  M3Args.RegisterFlag(
    tool_g, TypesToChange_Arg, &quot;find types to change&quot;);
  M3Args.RegisterFlag(
    tool_g, StatsToConsider_Arg, &quot;statements to think about&quot;);
  M3Args.RegisterFlag(
    tool_g, ExprsToReplace_Arg,
    &quot;expressions requiring systematic replacement&quot;);
  M3Args.RegisterFlag(
    tool_g, ExprsToConsider_Arg, &quot;expressions needing thought&quot;);
  M3Args.RegisterFlag(
    tool_g, ExprsDistantlyRelated_Arg,
    &quot;expressions distantly related to CHAR&quot;);
  M3Args.RegisterFlag(
    tool_g, ConsiderAll_Arg, &quot;consider all the above situations&quot;);
END M3CharTool.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
