<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/chkusatool/M3UnsetAttTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/chkusatool/M3UnsetAttTool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3UnsetAttTool.i3">M3UnsetAttTool</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>, <A HREF="../toolmisc/M3Error.i3">M3Error</A>;
IMPORT <A HREF="../ast/M3AST.i3">M3AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3ASTOp_SM.i3">M3ASTOp_SM</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;
IMPORT <A HREF="../fe/M3CGo.i3">M3CGo</A>;

CONST
  Version = &quot;Oct-1-92&quot;;

VAR
  tool_g: M3Args.T;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(): M3Args.T RAISES {}=
  BEGIN
    RETURN tool_g;
  END Get;

TYPE
  Extension = M3CGo.Extension OBJECT OVERRIDES extend := Extend END;
  CheckSetClosure = M3ASTOp_SM.CheckSetClosure OBJECT
  OVERRIDES callback := Report;
  END;
  ASTWalkClosure = ASTWalk.Closure OBJECT
    csl: CheckSetClosure;
  OVERRIDES callback := CheckSet;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>() RAISES {}=
  BEGIN
    M3CGo.AddExtension(NEW(Extension));
  END Init;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A>(
    &lt;*UNUSED*&gt; e: M3CGo.Extension;
    &lt;*UNUSED*&gt; context: M3Context.T;
    cu: M3AST_AS.Compilation_Unit;
    &lt;*UNUSED*&gt; VAR (*inout*) phases: M3CUnit.Status;
    ) RAISES {}=
  BEGIN
    IF NOT M3Args.GetFlag(tool_g, CheckUnsetAtts_Arg) THEN RETURN END;

    IF M3Conventions.PrimarySource IN cu.fe_status AND
       M3CUnit.State.SemChecked IN cu.fe_status THEN
      TYPECASE cu.as_root OF
      | NULL =&gt;
          (* no tree to analyse *)

      | M3AST_AS.UNIT_GEN_DEF =&gt;
          (* ignore generic definitions *)

      ELSE
        WITH csl = NEW(CheckSetClosure),
             cl = NEW(ASTWalkClosure, csl := csl) DO
          &lt;*FATAL ANY*&gt; BEGIN
            ASTWalk.VisitNodes(cu, cl);
          END;
       END;
      END; (* typecase *)
    END;
  END Extend;

PROCEDURE <A NAME="CheckSet"><procedure>CheckSet</procedure></A>(cl: ASTWalkClosure; n: AST.NODE;
                   &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode)=
  VAR m3n: M3AST.NODE := NARROW(n, M3AST.NODE);
  BEGIN
    m3n.checkSet(cl.csl);
  END CheckSet;

PROCEDURE <A NAME="Report"><procedure>Report</procedure></A>(&lt;*UNUSED*&gt; cl: M3ASTOp_SM.CheckSetClosure; n: M3AST.NODE)=
  BEGIN
    M3Error.Report(n, &quot;unset semantic attribute&quot;);
  END Report;

BEGIN
  tool_g := M3Args.New(&quot;m3unsetatt&quot;,
      &quot;check for unset attributes in AST&quot;,
      Version);
  M3Args.RegisterFlag(tool_g, CheckUnsetAtts_Arg,
                      &quot;check for unset semantic atributes&quot;);

END M3UnsetAttTool.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
