<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/dep/M3DepCompile.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/dep/M3DepCompile.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3DepCompile.i3">M3DepCompile</A></implements></module>;

IMPORT
  <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">Err</A>, <A HREF="../misc/TextExtras.i3">TextExtras</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>,
  <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>, <A HREF="../misc/M3Args.i3">M3Args</A>,
  <A HREF="../fe/M3CFETool.i3">M3CFETool</A>, <A HREF="../sem/M3CImportS.i3">M3CImportS</A>, <A HREF="../sem/M3CSpec.i3">M3CSpec</A>, <A HREF="../sem/M3CTmpAtt.i3">M3CTmpAtt</A>,
  <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3CUnitRep.i3">M3CUnitRep</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3ContextRemove.i3">M3ContextRemove</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>,
  <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>, <A HREF="../files/Common/M3DirFindFile.i3">M3DirFindFile</A>,
  <A HREF="M3DepDATool.i3">M3DepDATool</A>, <A HREF="../files/Common/M3DepFindFile.i3">M3DepFindFile</A>, <A HREF="../files/Common/M3PathElem.i3">M3PathElem</A>, <A HREF="../files/Common/M3PathElemList.i3">M3PathElemList</A>, <A HREF="../files/Common/M3Extension.i3">M3Extension</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;

VAR
  verbose_g, filter_g, filterExact_g: BOOLEAN := FALSE;
  datool_g: M3Args.T;
  remove_notification_g: RemoveNotification := NIL;

CONST
  Changed = M3DepFindFile.Update.Changed;
  Deleted = M3DepFindFile.Update.Deleted;
  Added = M3DepFindFile.Update.Added;

TYPE
  RemoveNotification = M3Context.Closure OBJECT
    changes: ARRAY SUT OF TextList.T;
  OVERRIDES callback := Delete;
  END;

  SUT = {Int, Mod};
  Updates = ARRAY SUT OF M3DepFindFile.UpdateRec;
CONST
  Int = SUT.Int;
  Mod = SUT.Mod;

PROCEDURE <A NAME="CheckVerbose"><procedure>CheckVerbose</procedure></A>() RAISES {}=
  BEGIN
    verbose_g := M3Args.GetFlag(M3DepDATool.Get(), M3DepDATool.Verbose_Arg);
  END CheckVerbose;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Run"><procedure>Run</procedure></A>(
    c: M3Context.T;
    prev, cur: M3DepFindFile.T;
    compile_dirs: M3PathElemList.T): INTEGER
    RAISES {}=
  VAR
    updates: Updates;
  BEGIN
    Clear(updates);
    datool_g := M3DepDATool.Get();
    IF NOT M3Args.Find(datool_g) THEN
      RETURN -1
    END;

    CheckVerbose();
    GatherUpdates(prev, cur, updates, compile_dirs);

    IF verbose_g THEN
      Err.Print(&quot;changes&quot;, Err.Severity.Comment);
      ListUnits(updates[Int], &quot;interface&quot;);
      ListUnits(updates[Mod], &quot;module&quot;);
    END;

    IF verbose_g THEN
      Err.Print(&quot;compiling&quot;, Err.Severity.Comment);
    END;

    RETURN FilteredCompile(c, cur, updates, CheckUpdateContext, compile_dirs);
  END Run;

PROCEDURE <A NAME="CheckFilterArg"><procedure>CheckFilterArg</procedure></A>() RAISES {}=
  BEGIN
    filter_g := NOT M3Args.GetFlag(datool_g, M3DepDATool.NOFilterUnits_Arg);
    IF filter_g THEN
      filterExact_g := M3Args.GetFlag(datool_g,
          M3DepDATool.FilterUnitsExact_Arg);
    END;
  END CheckFilterArg;

TYPE
  UpdateContextProc = PROCEDURE(
    context: M3Context.T; p: M3DepFindFile.T;
    updates: Updates;
    VAR (*out*) units: ARRAY SUT OF REF ARRAY OF TEXT
    ) RAISES {};

PROCEDURE <A NAME="FilteredCompile"><procedure>FilteredCompile</procedure></A>(
    c: M3Context.T;
    p: M3DepFindFile.T;
    VAR (*inout*) updates: Updates;
    up: UpdateContextProc;
    compile_dirs: M3PathElemList.T)
    : INTEGER
    RAISES {}=
  VAR f_updates: Updates;
    rc, trc := 0;
    units: ARRAY SUT OF REF ARRAY OF TEXT;
  BEGIN
    CheckFilterArg();
    WHILE Filter(c, p, updates, f_updates, compile_dirs) DO
      up(c, p, f_updates, units);

      trc := Compile(c, units);
      IF trc &lt; 0 THEN rc := trc END;
    END;
    RETURN rc;
  END FilteredCompile;

PROCEDURE <A NAME="Filter"><procedure>Filter</procedure></A>(
    c: M3Context.T;
    p: M3DepFindFile.T;
    VAR (*inout*) updates: Updates;
    VAR (*out*) f_updates: Updates;
    compile_dirs: M3PathElemList.T
    ): BOOLEAN RAISES {}=
  VAR
    p_elems, elems: TextList.T;
    cu: M3AST_AS.Compilation_Unit;
    dir: M3PathElem.T;
    ext: M3Extension.T; exts: M3Extension.TSet;
  BEGIN
   IF filter_g OR filterExact_g THEN
    (* filter the set of units to those which are in the current directory
    or modules which &quot;implement&quot; interfaces in the context. We use a heuristic
    based on name for &quot;implement&quot; to avoid having to open the unit.
    Units scheduled for compilation are taken off the 'updates' list and
    placed on the 'f_updates' list
    *)
    FOR sut := FIRST(SUT) TO LAST(SUT) DO
      (* Deleted units are transferred en mass to f_updates *)
      f_updates[sut, Deleted] := updates[sut, Deleted];
      updates[sut, Deleted] := NIL;

      f_updates[sut, Changed] := NIL;
      elems := updates[sut, Changed];
      (* Only keep these if we did when they were originally Added *)
      p_elems := NIL;
      WHILE elems # NIL DO
        IF M3Context.Find(c, elems.head, UTFromSUT(sut), cu) THEN
	  f_updates[sut, Changed] := TextList.AppendD(f_updates[sut, Changed],
                                                    TextList.List1(elems.head));
          IF p_elems = NIL THEN
            updates[sut, Changed] := elems.tail
          ELSE p_elems.tail := elems.tail;
          END;
        ELSE
          IF verbose_g THEN Err.Print(Fmt.F(&quot;  filtering %s %s&quot;,
                                      M3CUnit.TypeName(UTFromSUT(sut)),
                                      elems.head),
                                      Err.Severity.Continue);
          END;
        END; (* if *)
        IF updates[sut, Changed] # elems.tail THEN p_elems := elems; END;
        elems := elems.tail;
      END;
      f_updates[sut, Added] := NIL;
      elems := updates[sut, Added];
      p_elems := NIL;
      exts := ExtsFromUt(sut);
      (* Keep these if they are local, or if they are modules and
      implement an interface *)
      WHILE elems # NIL DO
        dir := FindFromExts(p, elems.head, exts, ext);
	IF (compile_dirs = NIL OR M3PathElemList.Member(compile_dirs, dir)) OR
           sut = Mod AND
	   ImplementsAnInterface(c, elems.head) THEN
	   f_updates[sut, Added] := TextList.AppendD(f_updates[sut, Added],
                                                   TextList.List1(elems.head));
          IF p_elems = NIL THEN
            updates[sut, Added] := elems.tail
          ELSE p_elems.tail := elems.tail;
          END;
        ELSE
          IF verbose_g THEN Err.Print(Fmt.F(&quot;  filtering %s %s&quot;,
	                                    M3CUnit.TypeName(UTFromSUT(sut)),
                                            elems.head),
                                      Err.Severity.Continue);
          END;
        END;
        IF updates[sut, Added] # elems.tail THEN p_elems := elems; END;
      	elems := elems.tail;
      END; (* while *)
    END; (* for *)
   ELSE
     FOR sut := FIRST(SUT) TO LAST(SUT) DO
       FOR a := FIRST(M3DepFindFile.Update) TO LAST(M3DepFindFile.Update) DO
         f_updates[sut, a] := updates[sut, a];
         updates[sut, a] := NIL;     	
       END; (* for *)
     END;
   END;
   RETURN NOT Empty(f_updates);
  END Filter;

PROCEDURE <A NAME="Empty"><procedure>Empty</procedure></A>(updates: Updates): BOOLEAN RAISES {}=
  BEGIN
    FOR ut := FIRST(SUT) TO LAST(SUT) DO
      FOR a := FIRST(M3DepFindFile.Update) TO LAST(M3DepFindFile.Update) DO
        IF updates[ut, a] # NIL THEN RETURN FALSE END      	
      END; (* for *)
    END; (* for *)
    RETURN TRUE;
  END Empty;

PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A>(VAR (*inout*) updates: Updates) RAISES {}=
  BEGIN
    FOR ut := FIRST(SUT) TO LAST(SUT) DO
      FOR a := FIRST(M3DepFindFile.Update) TO LAST(M3DepFindFile.Update) DO
        updates[ut, a] := NIL;     	
      END; (* for *)
    END; (* for *)
  END Clear;

PROCEDURE <A NAME="ImplementsAnInterface"><procedure>ImplementsAnInterface</procedure></A> (c: M3Context.T; name: TEXT): BOOLEAN
  RAISES {} =
  BEGIN
    FOR sut := FIRST(SUT) TO LAST(SUT) DO
      IF sut = Int THEN
        VAR
          iter := M3Context.NewIter(c, UTFromSUT(sut), FALSE);
          iname: TEXT;
          cu: M3AST_AS.Compilation_Unit;
        BEGIN
          WHILE M3Context.Next(iter, iname, cu) DO
            IF Implements(name, iname) THEN RETURN TRUE END;
          END;                  (* while *)
        END
      END;
    END;
    RETURN FALSE;
  END ImplementsAnInterface;

PROCEDURE <A NAME="Implements"><procedure>Implements</procedure></A>(module, interface: TEXT): BOOLEAN RAISES {}=
  VAR
    li := Text.Length(interface);
    lm := Text.Length(module);
    index: CARDINAL := 0;
  BEGIN
    (* if filterExact_g then module = interface, else
         *module = interface OR module* = interface *)
    IF filterExact_g THEN RETURN Text.Equal(module, interface)
    ELSE
      IF TextExtras.FindSub(module, interface, index) THEN
        RETURN index = 0 OR (index = lm-li);
      ELSE
      RETURN FALSE;
      END; (* if *)
    END;
  END Implements;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A>(
    c: M3Context.T;
    READONLY units: ARRAY SUT OF REF ARRAY OF TEXT;
    ): INTEGER RAISES {}=
  VAR
    phases: M3CUnit.Status;
    headerOnly: BOOLEAN;
    rc := 0;
 BEGIN
    CheckVerbose();
    &lt;*FATAL ANY*&gt; BEGIN
      M3Context.Apply(c, NEW(M3Context.Closure, callback := ClearPrimarySource));
    END;
    M3Args.SetStringList(M3CFETool.GetTool(), &quot;Interfaces&quot;, units[Int]);
    M3Args.SetStringList(M3CFETool.GetTool(), &quot;Modules&quot;, units[Mod]);
    IF M3Args.GetFlag(datool_g, M3DepDATool.CompileHeadersOnly_Arg) THEN
      phases := M3CUnit.Status{M3CUnit.State.Parsed,
	                       M3CUnit.State.ImportsResolved};
      headerOnly := TRUE;
    ELSE
      phases := M3CUnit.AllPhases;
      headerOnly := FALSE;
    END; (* if *)
    IF M3CFETool.CompileInContext(
      c,
      phases,
      headerOnly) &lt; 0 THEN
      rc := -1;
    END;
    (* attribute seting, only needed if CompileHeadersOnly or
       semantic analysis didnt occur (which it might not if IMPORT errors) *)
    &lt;*FATAL ANY*&gt; BEGIN
      M3Context.Apply(c, NEW(M3Context.Closure, callback := SetTmpAttrs));
    END;
    RETURN rc;
  END Compile;
</PRE> PUBLIC 
<PRE>PROCEDURE <A NAME="CompileUnits"><procedure>CompileUnits</procedure></A>(c: M3Context.T; ut: M3CUnit.Type;
    units: REF ARRAY OF TEXT): INTEGER RAISES {}=
  VAR
    updates: ARRAY SUT OF M3DepFindFile.UpdateRec;
    a_units: ARRAY SUT OF REF ARRAY OF TEXT;
    void: M3AST_AS.Compilation_Unit;
    sut := SUTFromUT(ut);
  BEGIN
    Clear(updates);
    FOR i := 0 TO NUMBER(units^)-1 DO
      IF M3Context.Find(c, units[i], ut, void) THEN
        updates[sut, Changed] := TextList.AppendD(updates[sut, Changed],
                                                TextList.List1(units[i]));
        ELSE
        updates[sut, Added] := TextList.AppendD(updates[sut, Added],
                                                TextList.List1(units[i]));
      END; (* if *)
    END; (* for *)
    UpdateContext(c, NIL, updates, a_units);
    RETURN Compile(c, a_units);
  END CompileUnits;
</PRE> PUBLIC 
<PRE>PROCEDURE <A NAME="CompileAll"><procedure>CompileAll</procedure></A>(c: M3Context.T; p: M3DepFindFile.T;
                     compile_dirs: M3PathElemList.T): INTEGER RAISES {}=
  VAR
    updates: Updates;
  BEGIN
    CheckVerbose();
    (* for each unit in the set associated with 'p',
       compile it unless it is already compiled with no errors. *)
    GatherUpdates(NIL, p, updates, compile_dirs);
    CheckRemovedFromContextOrInError(c, Int,
        updates[Int, Added]);
    CheckRemovedFromContextOrInError(c, Mod,
        updates[Mod, Added]);

    RETURN FilteredCompile(c, p, updates, UpdateContext, compile_dirs);
  END CompileAll;

PROCEDURE <A NAME="CheckRemovedFromContextOrInError"><procedure>CheckRemovedFromContextOrInError</procedure></A>(
    c: M3Context.T; sut: SUT;
    VAR (*inout*) added: TextList.T)=
  VAR
    result: TextList.T := NIL;
    ut := UTFromSUT(sut);
  BEGIN
    WHILE added # NIL DO
      VAR cu: M3AST_AS.Compilation_Unit;
      BEGIN
        IF M3Context.Find(c, added.head, ut, cu) AND
	   cu.fe_status * M3CUnit.Errors = M3CUnit.Status{} THEN
	  (* ok *)
        ELSE
          result := TextList.AppendD(result, TextList.List1(added.head));
        END; (* if *)
      END;
      added := added.tail
    END; (* while *)
    added := result;
  END CheckRemovedFromContextOrInError;

PROCEDURE <A NAME="ListUnits"><procedure>ListUnits</procedure></A>(u: M3DepFindFile.UpdateRec; tn: TEXT) RAISES {}=
  VAR
    mu: TEXT;
    elems: TextList.T;
  BEGIN
    FOR a := FIRST(M3DepFindFile.Update) TO LAST(M3DepFindFile.Update) DO
      elems := u[a];
      WHILE elems # NIL DO
	IF a = Added THEN mu := &quot; - added&quot;;
 	ELSIF a = Deleted THEN mu := &quot; - deleted&quot;;
	ELSE mu := &quot; - changed&quot;;
        END;
        Err.Print(&quot;  &quot; &amp; tn &amp; &quot; &quot; &amp; elems.head &amp; mu, Err.Severity.Continue);
        elems := elems.tail;
      END; (* while *)
    END; (* for *)
  END ListUnits;

PROCEDURE <A NAME="CheckUpdateContext"><procedure>CheckUpdateContext</procedure></A>(
    context: M3Context.T; p: M3DepFindFile.T;
    updates: Updates;
    VAR (*out*) units: ARRAY SUT OF REF ARRAY OF TEXT
    ) RAISES {}=
  BEGIN
    CheckContext(context, Int, p, updates[Int, Added]);
    CheckContext(context, Int, p, updates[Int, Changed]);
    CheckContext(context, Mod, p, updates[Mod, Added]);
    CheckContext(context, Mod, p, updates[Mod, Changed]);
    UpdateContext(context, NIL, updates, units);
  END CheckUpdateContext;

PROCEDURE <A NAME="UpdateContext"><procedure>UpdateContext</procedure></A>(
    context: M3Context.T;
    &lt;*UNUSED*&gt; void: M3DepFindFile.T;
    updates: Updates;
    VAR (*out*) units: ARRAY SUT OF REF ARRAY OF TEXT
    ) RAISES {}=
  VAR
    cl := remove_notification_g;
    int_updates := updates[Int];
    mod_updates := updates[Mod];
  BEGIN
    cl.changes[Int] := NIL;
    cl.changes[Mod] := NIL;
    (* we want to end up with a new list to compile *)
    (* trash the deleted modules *)
    IF int_updates[Deleted] # NIL OR
       mod_updates[Deleted] # NIL THEN
      IF verbose_g THEN
        Err.Print(&quot;removing deleted units&quot;, Err.Severity.Comment);
      END;
      M3ContextRemove.Units(context,
          ArrayFromTextList(int_updates[Deleted])^,
	  M3CUnit.Type.Interface);
      M3ContextRemove.Units(context,
          ArrayFromTextList(mod_updates[Deleted])^,
	  M3CUnit.Type.Module);
    END;
    IF int_updates[Changed] # NIL OR
       mod_updates[Changed] # NIL THEN
      IF verbose_g THEN
        Err.Print(&quot;removing changed units&quot;, Err.Severity.Comment);
      END;
      M3ContextRemove.Units(context,
          ArrayFromTextList(int_updates[Changed])^,
	  M3CUnit.Type.Interface);
      M3ContextRemove.Units(context,
          ArrayFromTextList(mod_updates[Changed])^,
	  M3CUnit.Type.Module);
    END;
    MergeLists(int_updates[Added],
      cl.changes[Int]);
    MergeLists(mod_updates[Added],
      cl.changes[Mod]);
    units[Int] := ArrayFromTextList(cl.changes[Int]);
    units[Mod] := ArrayFromTextList(cl.changes[Mod]);
  END UpdateContext;

PROCEDURE <A NAME="CheckContext"><procedure>CheckContext</procedure></A>(
    c: M3Context.T; sut: SUT; p: M3DepFindFile.T;
    VAR (*inout*) updates: TextList.T)=
  VAR p_updates: TextList.T := NIL;
      t := updates;
      ut := UTFromSUT(sut);
  BEGIN
    (* We may have explicitly compiled this already, check timestamps *)
    WHILE t # NIL DO
      VAR cu: M3AST_AS.Compilation_Unit;
      BEGIN
        IF M3Context.Find(c, t.head, ut, cu) AND
	   UidEqual(p, t.head, M3CUnit.ToType(cu.as_root), cu.fe_uid) THEN
          IF p_updates = NIL THEN updates := t.tail
          ELSE p_updates.tail := t.tail;
          END;
        END; (* if *)
      END;
      IF updates # t.tail THEN p_updates := t; END;
      t := t.tail;
    END; (* while *)
  END CheckContext;

PROCEDURE <A NAME="MergeLists"><procedure>MergeLists</procedure></A>(m: TextList.T; VAR (*inout*) l: TextList.T) RAISES {}=
  BEGIN
    WHILE m # NIL DO
      AddND(l, m.head);
      m := m.tail;
    END; (* for *)
  END MergeLists;

PROCEDURE <A NAME="GatherUpdates"><procedure>GatherUpdates</procedure></A>(p_old, p: M3DepFindFile.T;
                        VAR (*out*) updates: Updates;
                        compile_dirs: M3PathElemList.T)=
  VAR
    t_updates: Updates;
    dirs := p.dirs();
  BEGIN
    (* look for changed interfaces everywhere *)
    p.interfaces(p_old, updates[Int]);
    WHILE dirs # NIL DO
      Clear(t_updates);
      IF (compile_dirs = NIL) OR
         M3PathElemList.Member(compile_dirs, dirs.head) THEN
        p.modules(p_old, t_updates[Mod], dirs.head);
        FOR k := FIRST(M3DepFindFile.Update) TO LAST(M3DepFindFile.Update) DO
          JoinLists(t_updates[Mod, k], updates[Mod, k]);
        END; (* for *)
      END;
      dirs := dirs.tail;
    END;
  END GatherUpdates;

PROCEDURE <A NAME="JoinLists"><procedure>JoinLists</procedure></A>(l1: TextList.T; VAR (*inout*) l2: TextList.T) RAISES {}=
  BEGIN
    IF l1 = NIL THEN RETURN END;
    IF l2 = NIL THEN l2 := l1;
    ELSE
      l2 := TextList.AppendD(l2, l1);
    END; (* if *)
  END JoinLists;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(
    cl: RemoveNotification;
    ut: M3CUnit.Type;
    name: TEXT;
    &lt;*UNUSED*&gt; cu: M3AST_AS.Compilation_Unit)
    RAISES {}=
  BEGIN
    IF verbose_g THEN
      Err.Print(Fmt.F(&quot;  %s %s removed from context&quot;,
          M3CUnit.TypeName(ut), name), Err.Severity.Continue);
    END;
    AddND(cl.changes[SUTFromUT(ut)], name);
  END Delete;

PROCEDURE <A NAME="AddND"><procedure>AddND</procedure></A>(VAR l: TextList.T; name: TEXT) RAISES {}=
  VAR t := l;
  BEGIN
    WHILE t # NIL DO
      IF Text.Equal(t.head, name) THEN
      	RETURN
      END; (* if *)
      t := t.tail;
    END; (* while *)
    l := TextList.AppendD(l, TextList.List1(name));
  END AddND;

TYPE
  TmpAttClosure = ASTWalk.Closure OBJECT
    cu: M3AST_AS.Compilation_Unit;
  OVERRIDES
    callback := SetTmpAtt; (* new default method *)
  END;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="ClearPrimarySource"><procedure>ClearPrimarySource</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3Context.Closure;
    &lt;*UNUSED*&gt; ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: Text.T;
               cu: M3AST_AS.Compilation_Unit) RAISES {}=
  BEGIN
    M3CUnit.ExclState(cu.fe_status, M3Conventions.PrimarySource);
  END ClearPrimarySource;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="SetTmpAttrs"><procedure>SetTmpAttrs</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3Context.Closure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: Text.T;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
</PRE><BLOCKQUOTE><EM> Do a tree walk, and call SetTmpAtt for every node. Also
   call M3CImportS.Set.
 </EM></BLOCKQUOTE><PRE>
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    IF cu # NIL AND NOT M3CUnit.State.SemChecked IN cu.fe_status THEN
      &lt;*FATAL ANY*&gt; BEGIN
        ASTWalk.VisitNodes(cu, NEW(TmpAttClosure, cu := cu));
      END;
      M3CImportS.Set(cu.as_root);
    END;
  END SetTmpAttrs;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="SetTmpAtt"><procedure>SetTmpAtt</procedure></A>(
    cl: TmpAttClosure;
    an: AST.NODE;
    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode) RAISES {}=
  BEGIN
    IF an = NIL THEN RETURN; END;
    M3CTmpAtt.SetTmpUnitId(an, cl.cu.as_root.as_id);
    M3CSpec.Set(an); (* sm_spec, sm_comp_unit *)
  END SetTmpAtt;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="ArrayFromTextList"><procedure>ArrayFromTextList</procedure></A>(sl: TextList.T): REF ARRAY OF TEXT RAISES {} =
  VAR
    a := NEW(REF ARRAY OF TEXT, TextList.Length(sl));
  BEGIN
    FOR i := FIRST(a^) TO LAST(a^) DO
      a[i] := sl.head;
      sl := sl.tail;
    END;
    RETURN a;
  END ArrayFromTextList;

PROCEDURE <A NAME="UidEqual"><procedure>UidEqual</procedure></A>(t: M3DepFindFile.T; name: TEXT; ut: M3CUnit.Type;
    uid: M3CUnit.Uid): BOOLEAN RAISES {}=
  &lt;*FATAL M3FindFile.Failed*&gt;
  VAR
    ext: M3Extension.T;
    dirElem := FindFromExts(t, name, ExtsFromUt(SUTFromUT(ut)), ext);
    fullName: TEXT := Pathname.Join(dirElem.text(),
                                    name, M3Extension.ToText(ext));
    fs: REF Time.T;
  BEGIN
    fs := t.getProperty(name, ext);
    RETURN Text.Equal(fullName, uid.filename) AND
      fs^ = uid.stamp;
  END UidEqual;

PROCEDURE <A NAME="ExtsFromUt"><procedure>ExtsFromUt</procedure></A>(sut: SUT): M3Extension.TSet RAISES {}=
  BEGIN
    CASE sut OF
    | Int =&gt; RETURN M3Extension.TSet{M3Extension.T.Int, M3Extension.T.IntG};
    | Mod =&gt; RETURN M3Extension.TSet{M3Extension.T.Mod, M3Extension.T.ModG};
    END;
  END ExtsFromUt;

PROCEDURE <A NAME="FindFromExts"><procedure>FindFromExts</procedure></A>(p: M3DirFindFile.Finder; name: TEXT;
                      exts: M3Extension.TSet;
                      VAR (*out*) ext: M3Extension.T): M3PathElem.T=
  BEGIN
    FOR e := FIRST(M3Extension.T) TO LAST(M3Extension.T) DO
      IF e IN exts THEN
        TRY
          ext := e;
          RETURN p.dirOf(name, ext)
        EXCEPT M3FindFile.Failed =&gt;
        END
      END;
    END;
    RETURN NIL;
  END FindFromExts;

PROCEDURE <A NAME="UTFromSUT"><procedure>UTFromSUT</procedure></A>(sut: SUT): M3CUnit.Type=
  BEGIN
    IF sut = Int THEN RETURN M3CUnit.Type.Interface
    ELSE RETURN M3CUnit.Type.Module
    END
  END UTFromSUT;

PROCEDURE <A NAME="SUTFromUT"><procedure>SUTFromUT</procedure></A>(ut: M3CUnit.Type): SUT=
  BEGIN
    IF ut IN M3CUnit.Interfaces THEN RETURN Int
    ELSE RETURN Mod
    END
  END SUTFromUT;

BEGIN
  remove_notification_g := NEW(RemoveNotification);
  M3ContextRemove.AddNotification(remove_notification_g);
END M3DepCompile.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
