<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/dep/M3DepGenFinder.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/dep/M3DepGenFinder.m3</H2></A><HR>
<inModule>
<PRE></PRE>***********************************************************************
!		                                                        *
!*                                                                      *
!*         Copyright 1994 Sun Microsystems, Inc. All Rights Reserved.   *
!*                                                                      *
!*      Permission to use, copy, modify, and distribute this software   *
!*      and its documentation for any purpose and without fee is hereby *
!*      granted, provided that the above copyright notice appear in all *
!*      copies and that both that copyright notice and this permission  *
!*      notice appear in supporting documentation, and that the name of *
!*      Sun Microsystems, Inc. (SMI) not be used in advertising or      *
!*      publicity pertaining to distribution of the software without    *
!*      specific, written prior permission.                             *
!*                                                                      *
!*                                                                      *
!*      SMI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,      *
!*      INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,	        *
!*      FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.           *
!*      IN NO EVENT SHALL SMI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,    *
!*	INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER     *
!*      RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
!*      ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,        *
!*      ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE     *
!*      OF THIS SOFTWARE.                                               *
!*                                                                      *
!**********************************************************************

<P><PRE>MODULE <module><implements><A HREF="M3DepGenFinder.i3">M3DepGenFinder</A></implements></module>;
IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../os/src/Common/Process.i3">Process</A>, <A HREF="../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../misc/RdExtras.i3">RdExtras</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>;

IMPORT <A HREF="../files/Common/M3Extension.i3">M3Extension</A>;
IMPORT <A HREF="../files/Common/M3DepFindFile.i3">M3DepFindFile</A>;
</PRE> For FATAL 
<PRE>IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
&lt;*FATAL Rd.EndOfFile, Thread.Alerted*&gt;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(overrides := FALSE): M3DepFindFile.T=
  &lt;*FATAL OSError.E*&gt;
  VAR rd: Rd.T; stdout: File.T;
      ix := 1;
      result: M3DepFindFile.T := NIL;
  CONST
    Arg2 = ARRAY OF TEXT{&quot;srcmap&quot;, &quot;-O&quot;};
  BEGIN
    IF overrides THEN
      ix := 2;
    END;
    stdout := FS.OpenFile(&quot;.M3SRCMAP&quot;);
    TRY
      IF NOT RunProcess(&quot;m3build&quot;, SUBARRAY(Arg2, 0, ix),
                        xstdout := stdout) THEN RETURN NIL END;
    FINALLY
      stdout.close()
    END;

    TRY
      TRY
        rd := FileRd.Open(&quot;.M3SRCMAP&quot;);
        (* skip noise output by m3build *)
        EVAL RdExtras.GetText(rd, terminate := ASCII.Set{'@'});
        result :=
          NEW(M3DepFindFile.T).init(M3Extension.All, rd, NIL);
      FINALLY
        Rd.Close(rd);
      END;
    EXCEPT
    | Rd.Failure =&gt;
    END;
    RETURN result;
  END New;

PROCEDURE <A NAME="RunProcess"><procedure>RunProcess</procedure></A>(cmd: TEXT; READONLY args: ARRAY OF TEXT;
                     xstdin, xstdout, xstderr: File.T := NIL): BOOLEAN=
  VAR stdin, stdout, stderr: File.T;
      p: Process.T;
  BEGIN
    Process.GetStandardFileHandles(stdin, stdout, stderr);
    IF xstdin # NIL THEN stdin := xstdin END;
    IF xstdout # NIL THEN stdout := xstdout END;
    IF xstderr # NIL THEN stderr := xstderr END;
    TRY
      p := Process.Create(cmd, args, NIL, NIL,
                     stdin, stdout, stderr);
      IF Process.Wait(p) # 0 THEN END;
    EXCEPT
    | OSError.E =&gt;
        RETURN FALSE
    END;
    RETURN TRUE;
  END RunProcess;

BEGIN
END M3DepGenFinder.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
