<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/fe/M3CFETool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/fe/M3CFETool.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CFETool.i3">M3CFETool</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="#x1">Err</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;
IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>;
IMPORT <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>;
IMPORT <A HREF="M3CGoList.i3">M3CGoList</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../misc/M3Time.i3">M3Time</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;

CONST
  Version = &quot;28-Sep-92&quot;;

VAR
  tool_g: M3Args.T;

TYPE
  NotificationClosure = M3CGoList.Notification OBJECT
    setCompTime := FALSE;
    printUnits := FALSE;
    totalCompTime: M3Conventions.CompTime := NIL;
    indent := 0;
  OVERRIDES notify := TimeAndPrintUnits;
  END;

PROCEDURE <A NAME="GetTool"><procedure>GetTool</procedure></A>(): M3Args.T RAISES {} =
  BEGIN
    RETURN tool_g;
  END GetTool;

PROCEDURE <A NAME="CompileInContext"><procedure>CompileInContext</procedure></A>(
    VAR (*inout*) context: M3Context.T;
    phases: M3CUnit.Status;
    headerOnly := FALSE;
    setPrimarySource := TRUE;
    ): INTEGER RAISES {} =
  VAR
    ml, il, pl: REF ARRAY OF TEXT;
    result: INTEGER := 0;
    notification := NEW(NotificationClosure);
    setCompTime: BOOLEAN;
  BEGIN
    IF NOT M3Args.Find(tool_g) THEN
      RETURN -1
    END;

    il := M3Args.GetStringList(tool_g, Interfaces_Arg);
    ml := M3Args.GetStringList(tool_g, Modules_Arg);
    pl := M3Args.GetStringList(tool_g, PathNames_Arg);

    setCompTime := M3Args.GetFlag(tool_g, Timings_Arg);
    notification.setCompTime := setCompTime;
    notification.printUnits := M3Args.GetFlag(tool_g, PrintUnits_Arg);
    IF setCompTime THEN
      notification.totalCompTime := NEW(M3Conventions.CompTime).init();
    END;
    IF setCompTime OR notification.printUnits THEN
      M3CGoList.AddNotification(notification);
    ELSE notification := NIL;
    END;
    IF il = NIL THEN il := NEW(REF ARRAY OF TEXT, 0); END;
    IF ml = NIL THEN ml := NEW(REF ARRAY OF TEXT, 0); END;
    IF pl = NIL THEN pl := NEW(REF ARRAY OF TEXT, 0); END;
    M3CGoList.CompileUnitsInContext(context, il^, ml^, pl^, phases,
        headerOnly, setPrimarySource, setCompTime);
    IF (phases * M3CUnit.Errors) # M3CUnit.Status{} THEN
      result := -1;
    END;

    IF notification # NIL THEN
      IF setCompTime THEN
        Err.Print(&quot;total &quot;, Err.Severity.Comment, newline := FALSE);
        PrintTime(notification.totalCompTime);
      END; (* if *)
      M3CGoList.RemoveNotification(notification);
    END;

    RETURN result;
  END CompileInContext;

PROCEDURE <A NAME="TimeAndPrintUnits"><procedure>TimeAndPrintUnits</procedure></A>(
    cl: NotificationClosure;
    context: M3Context.T;
    nm: M3CGoList.NotifyMode;
    name: TEXT;
    unitType: M3CUnit.Type;
    unitForm: M3CUnit.Form;
    cu: M3AST_AS.Compilation_Unit;
    compTime: M3Conventions.CompTime) RAISES {} =
  BEGIN
    IF cl.printUnits THEN
       PrintUnits(cl, context, nm, name, unitType, unitForm, cu, compTime);
    END;
    IF cl.totalCompTime # NIL AND nm = M3CGoList.NotifyMode.After THEN
      Err.Print(Fmt.F(&quot;%s \'%s\': &quot;, M3CUnit.TypeName(unitType), name),
                Err.Severity.Comment, newline := FALSE);
      PrintTime(compTime);
      cl.totalCompTime.open := M3Time.Add(cl.totalCompTime.open,
                                           compTime.open);
      cl.totalCompTime.parse := M3Time.Add(cl.totalCompTime.parse,
                                            compTime.parse);
      cl.totalCompTime.semantic := M3Time.Add(cl.totalCompTime.semantic,
                                               compTime.semantic);
    END; (* if *)
  END TimeAndPrintUnits;

PROCEDURE <A NAME="PrintTime"><procedure>PrintTime</procedure></A>(compTime: M3Conventions.CompTime) RAISES {} =
  BEGIN
    Err.Print(Fmt.F(&quot;time to open %s, parse %s, check semantics %s&quot;,
        M3Time.AsString(compTime.open),
        M3Time.AsString(compTime.parse),
        M3Time.AsString(compTime.semantic)), Err.Severity.Continue);
  END PrintTime;

PROCEDURE <A NAME="PrintUnits"><procedure>PrintUnits</procedure></A>(
    cl: NotificationClosure;
    &lt;*UNUSED*&gt; context: M3Context.T;
    nm: M3CGoList.NotifyMode;
    name: TEXT;
    unitType: M3CUnit.Type;
    unitForm: M3CUnit.Form;
    cu: M3AST_AS.Compilation_Unit;
    &lt;*UNUSED*&gt; compTime: M3Conventions.CompTime) RAISES {} =
  BEGIN
    IF nm = M3CGoList.NotifyMode.Before THEN
      PrintUnit(cl, unitType, name, unitForm, cu);
      INC(cl.indent, 2);
    ELSE
      DEC(cl.indent, 2);
    END; (* if *)
  END PrintUnits;

PROCEDURE <A NAME="PrintUnit"><procedure>PrintUnit</procedure></A>(cl: NotificationClosure;
    unitType: M3CUnit.Type; unitName: TEXT;
    uf: M3CUnit.Form; cu: M3AST_AS.Compilation_Unit) RAISES {} =
  BEGIN
    Err.Print(&quot;&quot;, Err.Severity.Comment, newline := FALSE);
    FOR i := 1 TO cl.indent DIV 2 DO
      Err.Print(&quot;  &quot;, Err.Severity.Continue, newline := FALSE);
    END; (* for *)
    IF uf = M3CUnit.Form.Source THEN
      Err.Print(Fmt.F(&quot;compiling %s \'%s\'&quot;, M3CUnit.TypeName(unitType),
                   unitName), Err.Severity.Continue, newline := FALSE);
    ELSE
      Err.Print(Fmt.F(&quot;reading AST for %s \'%s\'&quot;, M3CUnit.TypeName(unitType),
                   unitName), Err.Severity.Continue, newline := FALSE);
    END; (* if *)
    IF cu # NIL THEN
      Err.Print(Fmt.F(&quot; from %s&quot;, M3CUnit.TextName(cu.fe_uid)),
         Err.Severity.Continue, newline := FALSE);
    END; (* if *)
    Err.Print(&quot;&quot;, Err.Severity.Continue);
  END PrintUnit;

BEGIN
  tool_g := M3Args.New(&quot;m3cfe&quot;, &quot;Modula-3 Compiler Front End&quot;, Version);
  M3Args.RegisterStringList(tool_g, PathNames_Arg,
      &quot;list of files to be compiled&quot;, M3Args.Opt.Positional);
  M3Args.RegisterStringList(tool_g, Modules_Arg,
      &quot;list of modules to be compiled&quot;);
  M3Args.RegisterStringList(tool_g, Interfaces_Arg,
      &quot;list of interfaces to be compiled&quot;);

  M3Args.RegisterFlag(tool_g, PrintUnits_Arg,
      &quot;print name of each unit compiled&quot;);
  M3Args.RegisterFlag(tool_g, Timings_Arg, &quot;time compiler phases&quot;);
END M3CFETool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
