<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/fe/M3CGo.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/fe/M3CGo.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CGo.m3">M3CGo</A></interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;
</PRE> This interface supports the compilation of a single unit, which is
already open on a given stream.  A callback mechanism is included to
cope with the need to compile imported/exported interfaces.


<P><PRE>TYPE ImportedUnitProc = PROCEDURE(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit
    ): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> A call to this procedure is a request for the given unit to be compiled.
The context argument will be the same as that passed in to CompileUnit.
A <CODE>FALSE</CODE> result means that the unit could not be found.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CGo.m3#CompileUnit">CompileUnit</A>(
    cu: M3AST_AS.Compilation_Unit;
    context: M3Context.T;
    stream: Rd.T;
    p: ImportedUnitProc;
    VAR (*inout*) phases: M3CUnit.Status;
    compTime: M3Conventions.CompTime;
    headerOnly := FALSE
    ) RAISES {};
</PRE><BLOCKQUOTE><EM> Compile the unit whose tree root is <CODE>cu</CODE>, and is open on <CODE>stream</CODE>,
and which is a member of <CODE>context</CODE>.  <CODE>p</CODE> will be called to resolve
imported units.  If <CODE>compTime # NIL</CODE> fill in the parse and semantic
analysis times. <CODE>phases</CODE> controls exactly which phases are run - the
usual value is AllPhases, but it can be convenient to restrict to just
parsing, for example.  If you ask for a phase which depends on a
previous one that has not been done, the error state for that phase is
set and the call returns.  Unless parsing is enabled, <CODE>stream</CODE> is
ignored completely.  <CODE>headerOnly</CODE> causes parsing to abort after
parsing the exports and import clauses, which is to support fast
dependency analysis.  </EM></BLOCKQUOTE><PRE>

CONST AllPhases = M3CUnit.AllPhases;

PROCEDURE <A HREF="M3CGo.m3#Current">Current</A>(): M3AST_AS.Compilation_Unit RAISES {};
</PRE><BLOCKQUOTE><EM> This procedure returns the compilation unit which is currently
being compiled. I.e. the <CODE>cu</CODE> that was passed in the CompileUnit. </EM></BLOCKQUOTE><PRE>
</PRE> Compiler Extension.
<P>
   A client can register extra passes to be applied after the
   standard passes. The <CODE>extend</CODE> method for each registered
   extension will be called with the values of <CODE>context</CODE> and <CODE>phases</CODE>, 
   as passed in to <CODE>CompileUnit</CODE>. The value of <CODE>cu</CODE> will also
   be that passed in, unless the unit is a generic instantation,
   in which case the value of <CODE>cu.as_root.sm_ins_comp_unit</CODE> is
   passed instead. The client must explicitly check that a given
   phase has actually occured (by looking at <CODE>cu.fe_status</CODE>).
   The extension code can report errors with <CODE>M3Error</CODE>, and these
   will be displayed along with those from other passes, after all
   the extensions have completed. The extensions will be applied
   in the order they that they were registered. 
   
<P><PRE>TYPE
  <A HREF="M3CGo.m3#Extension">Extension</A> &lt;: Extension_public;
  Extension_public = OBJECT
  METHODS
    extend(
      context: M3Context.T;
      cu: M3AST_AS.Compilation_Unit;
      VAR (*inout*) phases: M3CUnit.Status;
      ) RAISES {};
  END;

PROCEDURE <A HREF="M3CGo.m3#AddExtension">AddExtension</A>(e: Extension) RAISES {};

PROCEDURE <A HREF="M3CGo.m3#RemoveExtension">RemoveExtension</A>(e: Extension) RAISES {};

END M3CGo.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
