<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/fe/M3CGoList.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/fe/M3CGoList.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="M3CGoList.m3">M3CGoList</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>;

PROCEDURE <A HREF="M3CGoList.m3#CompileUnitsInContext">CompileUnitsInContext</A>(
    VAR (*inout*) context: M3Context.T;
    READONLY interfaces, modules, pathNames: ARRAY OF TEXT;
    VAR (*inout*) phases: M3CUnit.Status;
    headerOnly := FALSE;
    setPrimarySource := TRUE;
    setCompTime: BOOLEAN := FALSE
    ) RAISES {};
</PRE><BLOCKQUOTE><EM> (Try to) compile all the units in the arrays <CODE>interfaces</CODE> and <CODE>modules</CODE>, 
and <CODE>pathNames</CODE>. Any imported/exported units will be looked for in 
<CODE>context</CODE> first, which is created if it is NIL.  If any 
notification callbacks have been registered, they will be called
just before a unit is compiled and just after; any error messages
will already have been generated. If a unit cannot be found
an error message will be generated, and the notifications are
not called. The value of <CODE>phases</CODE> controls exactly which 
phases are run - the usual value is<CODE> AllPhases</CODE>, but it can be convenient 
to restrict to just parsing, for example.  <CODE>phases</CODE> is always updated
with any error flags that occur, which provides a cheap check
for a clean compilation.
<P>
<CODE>interfaces</CODE> and <CODE>modules</CODE> are expect to contain unit names, which are
searched for on the search path. <CODE>pathNames</CODE> are treated literally
and, if they have M3 source extensions, are opened and compiled.
<P>
<CODE>headerOnly</CODE> causes parsing to abort after parsing the exports and 
import clauses, which is to support fast dependency analysis.
<CODE>setPrimarySource</CODE> causes <CODE>M3Conventions.PrimarySource</CODE> to be set in
the <CODE>fe_status</CODE> field of all the modules and interfaces that were
explicitly compiled (i.e. those in <CODE>interfaces</CODE> + <CODE>modules</CODE>).
<CODE>setCompTime = TRUE</CODE>, causes an <CODE>M3Conventions.CompTime</CODE> record to be created 
for each unit compiled, which will be passed to any <CODE>notify</CODE> methods. </EM></BLOCKQUOTE><PRE>

CONST AllPhases = M3CUnit.AllPhases; (* convenience re-export *)

PROCEDURE <A HREF="M3CGoList.m3#Current">Current</A>(): M3AST_AS.Compilation_Unit RAISES {};
</PRE><BLOCKQUOTE><EM> This procedure returns the compilation unit which is currently
being compiled. </EM></BLOCKQUOTE><PRE>

TYPE
  NotifyMode = {Before, After};
  <A HREF="M3CGoList.m3#Notification">Notification</A> &lt;: Notification_public;
  Notification_public = OBJECT
  METHODS
    notify(
      context: M3Context.T;
      nm: NotifyMode;
      name: TEXT;
      ut: M3CUnit.Type;
      uf: M3CUnit.Form;
      cu: M3AST_AS.Compilation_Unit;
      compTime: M3Conventions.CompTime := NIL
      ) RAISES {};
  END;

PROCEDURE <A HREF="M3CGoList.m3#AddNotification">AddNotification</A>(e: Notification) RAISES {};
</PRE><BLOCKQUOTE><EM> Register <CODE>e.notify</CODE> to be called for each compiled unit resulting 
from a call of <CODE>M3CGoList.CompileInContext</CODE>.  <CODE>e.notify</CODE>is called just 
before and just after the compilation (<CODE>cu = NIL</CODE> at before). If 
<CODE>setCompTime = TRUE</CODE>, on the call to <CODE>CompileUnitsInContext</CODE>, then
the <CODE>M3Conventions.CompTime</CODE> record created for this unit
is passed to <CODE>notify</CODE>, else it gets NIL. The notifications are
called in the order that they were added. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CGoList.m3#RemoveNotification">RemoveNotification</A>(e: Notification) RAISES {};
</PRE><BLOCKQUOTE><EM> Remove notification <CODE>e</CODE>. </EM></BLOCKQUOTE><PRE>

END M3CGoList.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
