<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/fe/M3CGoList.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/fe/M3CGoList.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CGoList.i3">M3CGoList</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="#x1">Err</A>, <A HREF="../../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../astpickle/M3AST_SC.i3">M3AST_SC</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../astpickle/M3AST_SC_F.i3">M3AST_SC_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_SC_Unit_stub.i3">SeqM3AST_SC_Unit_stub</A>;

IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../misc/M3Time.i3">M3Time</A>, <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3ContextRemove.i3">M3ContextRemove</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="M3CGo.i3">M3CGo</A>;
IMPORT <A HREF="../sem/M3CMkStd.i3">M3CMkStd</A>, <A HREF="../sem/M3CScope.i3">M3CScope</A>;
IMPORT <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A>, <A HREF="../files/Common/M3Extension.i3">M3Extension</A>;
IMPORT <A HREF="../sem/M3CConcTypeSpec.i3">M3CConcTypeSpec</A>;
FROM <A HREF="../toolmisc/M3Conventions.i3">M3Conventions</A> IMPORT IsStandard, ModuleName, Standard,
    PrimarySource;
IMPORT <A HREF="../astpickle/M3ASTPickle.i3">M3ASTPickle</A>, <A HREF="../../../pickle/src/Pickle.i3">Pickle</A>;

TYPE
  ContextData = BRANDED REF RECORD
    setCompTime: BOOLEAN := FALSE;
    compiledStandard: BOOLEAN := FALSE;
    compilees: CompileeArray;
    phases := M3CUnit.Status{};
    headerOnly, setPrimarySource: BOOLEAN := FALSE;
    en: ErrorNotification := NIL;
  END;

  Compilee = {Int, PnInt, Mod, PnMod};
  CompileeArray = ARRAY Compilee OF REF ARRAY OF TEXT;
</PRE>*************************************************************************
                            Notify support                               
*************************************************************************

<P><PRE>REVEAL <A NAME="Notification">Notification</A> = Notification_public BRANDED OBJECT END;

TYPE NotificationElem = REF RECORD e: Notification END;

VAR notifications_g: RefList.T := NIL;
    notificationsMutex_g := NEW(MUTEX);

PROCEDURE <A NAME="AddNotification"><procedure>AddNotification</procedure></A>(e: Notification) RAISES {}=
  BEGIN
    LOCK notificationsMutex_g DO
      notifications_g := RefList.AppendD(notifications_g,
                             RefList.List1(NEW(NotificationElem, e := e)));
    END; (* lock *)
  END AddNotification;

PROCEDURE <A NAME="RemoveNotification"><procedure>RemoveNotification</procedure></A>(e: Notification) RAISES {}=
  VAR l: RefList.T := notifications_g; prev: RefList.T := NIL;
  BEGIN
    LOCK notificationsMutex_g DO
      WHILE l # NIL DO
        IF NARROW(l.head, NotificationElem).e = e THEN
          IF prev = NIL THEN notifications_g := l.tail
          ELSE prev.tail := l.tail;
          END;
          RETURN
        END;
        prev := l; l := l.tail;
      END;
    END; (* lock *)
  END RemoveNotification;

PROCEDURE <A NAME="Notify"><procedure>Notify</procedure></A>(
      context: M3Context.T;
      nm: NotifyMode;
      name: TEXT;
      ut: M3CUnit.Type;
      uf: M3CUnit.Form;
      cu: M3AST_AS.Compilation_Unit;
      compTime: M3Conventions.CompTime := NIL
      ) RAISES {}=
  BEGIN
    LOCK notificationsMutex_g DO
      VAR list: RefList.T := notifications_g;
      BEGIN
        WHILE list # NIL DO
          NARROW(list.head, NotificationElem).e.notify(context, nm, name,
                                                       ut, uf, cu, compTime);
          list := list.tail;
        END;
      END;
    END;
  END Notify;
</PRE>*************************************************************************
                            Error handling                               
*************************************************************************

<P><PRE>TYPE
  ErrorNotification = M3Error.Notification OBJECT
    cd: ContextData;
    errCuList: RefList.T; (* OF ErrCu *)
  OVERRIDES
    notify := ErrorObserver;
  END;

  ErrCu = REF RECORD
    cu: M3AST_AS.Compilation_Unit;
  END;

PROCEDURE <A NAME="InitErrorObserver"><procedure>InitErrorObserver</procedure></A>(
    en: ErrorNotification;
    cu: M3AST_AS.Compilation_Unit;
    ): RefList.T RAISES {} =
  VAR
    sErrCuList: RefList.T;
  BEGIN
    sErrCuList := en.errCuList;
    en.errCuList := NIL;
    M3Error.SetCu(cu);
    RETURN sErrCuList;
  END InitErrorObserver;

PROCEDURE <A NAME="ErrorObserver"><procedure>ErrorObserver</procedure></A>(en: ErrorNotification;
    cu: M3AST_AS.Compilation_Unit; serious: BOOLEAN) RAISES {} =
  VAR
    t: RefList.T;
    current: M3AST_AS.Compilation_Unit;
  CONST
    SErrors = M3CUnit.Status{M3CUnit.State.SErrors};
  BEGIN
    IF serious THEN
      cu.fe_status := cu.fe_status + SErrors;
      current := Current();
      IF current # NIL THEN
        current.fe_status := current.fe_status + SErrors;
      END;
      en.cd.phases := en.cd.phases + SErrors;
    END;
    t := en.errCuList;
    WHILE t # NIL DO
      IF NARROW(t.head, ErrCu).cu = cu THEN RETURN
      ELSE t := t.tail;
      END;
    END; (* while *)
    en.errCuList := RefList.AppendD(en.errCuList,
                                    RefList.List1(NEW(ErrCu, cu := cu)));
  END ErrorObserver;

PROCEDURE <A NAME="ShowErrors"><procedure>ShowErrors</procedure></A>(en: ErrorNotification; sErrCuList: RefList.T) RAISES {} =
  VAR
    t: RefList.T;
    ecu: ErrCu;
  BEGIN
    t := en.errCuList;
    WHILE t # NIL DO
      ecu := NARROW(t.head, ErrCu);
      M3Error.SetCu(ecu.cu);
      M3Error.ShowAll(ecu.cu.as_root);
      t := t.tail;
    END; (* while *)
    en.errCuList := sErrCuList;
    M3Error.SetCu(M3CGo.Current());
  END ShowErrors;

PROCEDURE <A NAME="Current"><procedure>Current</procedure></A>(): M3AST_AS.Compilation_Unit RAISES {} =
  BEGIN
    RETURN M3CGo.Current();
  END Current;
</PRE><P>
TYPE
  TmpAttClosure = ASTWalk.Closure OBJECT id: M3AST_AS.UNIT_ID END;


<P><PRE>PROCEDURE <A NAME="Unpickle"><procedure>Unpickle</procedure></A>(context: M3Context.T; rd: Rd.T; pn: TEXT;
    ): M3AST_AS.Compilation_Unit RAISES {} =
  &lt;*FATAL Thread.Alerted*&gt;
  VAR
    icu, cu: M3AST_AS.Compilation_Unit := NIL;
    usb: M3AST_SC.Unit_stub;
    iter: SeqM3AST_SC_Unit_stub.Iter;
  BEGIN
    TRY
      M3ASTPickle.Read(context, rd, CheckFindUnpickleOrCompileSource, cu);
      Rd.Close(rd);

      iter := SeqM3AST_SC_Unit_stub.NewIter(cu.sc_unit_stub_s);
      WHILE SeqM3AST_SC_Unit_stub.Next(iter, usb) DO
        IF M3Context.FindFromId(context, usb.sc_unit_symrep,
                                usb.sc_unit_type, icu) THEN
          IF NOT M3CUnit.Equal(usb.sc_unit_uid, icu.fe_uid) THEN
            WITH gcu = Current() DO
              M3Error.ReportWithId(gcu.as_root,
                  &quot;version conflict between interfaces '%s' and '%s'&quot;,
                  cu.as_root.as_id.lx_symrep,
                  usb.sc_unit_symrep);
              M3CUnit.InclState(gcu.fe_status, M3CUnit.State.IErrors);
            END
          END
        END; (* if *)
      END; (* while *)
      (* temporary attributes are pickled for now
      cl := NEW(TmpAttClosure, callback := TmpAttSet, id := cu.as_root.as_id);
      ASTWalk.VisitNodes(cu, cl); *)
    EXCEPT
    | Rd.Failure, Pickle.Error =&gt;
        Err.Print(Fmt.F(&quot;unpickling from %s failed&quot;, pn),
            Err.Severity.Error);
        cu := NIL;
    END;
    RETURN cu;
  END Unpickle;
</PRE>********************************************
PROCEDURE TmpAttSet(cl: TmpAttClosure; n: AST.NODE; 
    &lt;*UNUSED*&gt;vm: ASTWalk.VisitMode) RAISES {}=
  BEGIN
    M3CTmpAtt.Set(n, cl.id);
  END TmpAttSet;
**********************************************

<P><PRE>PROCEDURE <A NAME="CheckFindUnpickleOrCompileSource"><procedure>CheckFindUnpickleOrCompileSource</procedure></A>(
    name: TEXT;
    unitType: M3CUnit.Type;
    sourceId: M3CUnit.Uid;
    context: M3Context.T;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit): BOOLEAN RAISES {} =
  BEGIN
    IF FindUnpickleOrCompileSource(name, unitType, context, cu) THEN
      RETURN M3CUnit.Equal(sourceId, cu.fe_uid);
    ELSE
      M3CUnit.InclState(Current().fe_status, M3CUnit.State.IErrors);
      RETURN FALSE
    END;
  END CheckFindUnpickleOrCompileSource;

PROCEDURE <A NAME="FindUnpickleOrCompileSourceWithUF"><procedure>FindUnpickleOrCompileSourceWithUF</procedure></A>(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*inout*) uf: M3CUnit.Form;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit): BOOLEAN
    RAISES {} =
  BEGIN
    (* First see if its already in this context *)
    IF M3Context.Find(context, ModuleName(name), unitType, cu) THEN END;

    IF cu = NIL THEN
      IF UnpickleOrCompileSource(name, unitType, context, uf, cu) THEN END;
    END; (* if *)
    RETURN (cu # NIL) AND (cu.as_root # NIL);
  END FindUnpickleOrCompileSourceWithUF;

PROCEDURE <A NAME="FindUnpickleOrCompileSource"><procedure>FindUnpickleOrCompileSource</procedure></A>(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit): BOOLEAN
    RAISES {} =
  VAR
    uf: M3CUnit.Form;
    res: BOOLEAN;
  BEGIN
    uf := M3CUnit.Form.DontCare;
    res := FindUnpickleOrCompileSourceWithUF(
        name, unitType, context, uf, cu);
    IF res THEN
      TYPECASE cu.as_root OF
      | M3AST_AS.UNIT_GEN_INS(unit_ins) =&gt;
          IF unit_ins.sm_ins_comp_unit # NIL THEN
            cu := unit_ins.sm_ins_comp_unit;
          ELSE
            res := FALSE;
            cu := NIL;
          END;
      ELSE
      END; (* typecase *)
    END;
    RETURN res;
  END FindUnpickleOrCompileSource;

PROCEDURE <A NAME="FindOrCompileSource"><procedure>FindOrCompileSource</procedure></A>(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit): BOOLEAN
    RAISES {} =
  VAR
    uf: M3CUnit.Form;
  BEGIN
    uf := M3CUnit.Form.Source;
    RETURN FindUnpickleOrCompileSourceWithUF(
        name, unitType, context, uf, cu);
  END FindOrCompileSource;

PROCEDURE <A NAME="UnpickleOrCompileSource"><procedure>UnpickleOrCompileSource</procedure></A>(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*inout*) uf: M3CUnit.Form;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit): BOOLEAN
    RAISES {} =
  VAR
    isStandard: BOOLEAN;
    textForm: TEXT;
    stream: Rd.T;
    sourceId: M3CUnit.Uid;
    saveErrCuList: RefList.T;
    startTime: M3Time.T;
    compTime: M3Conventions.CompTime;
    openError := FALSE;
    cd: ContextData := GetData(context);

  PROCEDURE AddCu() RAISES {}=
    BEGIN
      IF isStandard THEN
        M3Context.SetStandard(cu);
      ELSE
        WITH m = ModuleName(name) DO
          CheckedAdd(context, m, unitType, cu);
        END;
      END; (* if *)
    END AddCu;

  BEGIN
    cu := NIL;
    isStandard := IsStandard(name);
    IF cd.setCompTime THEN compTime := NEW(M3Conventions.CompTime).init()
    ELSE compTime := NIL;
    END;

    IF cd.setCompTime THEN startTime := M3Time.Now() END;
    TRY
      VAR finder := context.getSub(TYPECODE(M3FindFile.T));
      BEGIN
        IF isStandard THEN
          &lt;*FATAL M3FindFile.Failed*&gt; BEGIN
            stream := M3CUnit.FindStandard(finder, uf, sourceId);
          END;
        ELSE
          stream := M3CUnit.FindUnit(finder, name, unitType, uf, sourceId);
        END;
      END
    EXCEPT
    | OSError.E =&gt;
        openError := TRUE; stream := NIL;
    END;
    IF cd.setCompTime THEN compTime.open := M3Time.Interval(startTime) END;

    IF stream = NIL THEN
      VAR
        prefix: TEXT := &quot;failed to &quot;;
      BEGIN
        IF openError THEN prefix := prefix &amp; &quot;open&quot;;
        ELSE prefix := prefix &amp; &quot;find&quot;;
        END;
        IF isStandard THEN
          Err.Print(Fmt.F(&quot;%s standard interface&quot;, prefix), Err.Severity.Fatal);
        ELSE
          IF uf = M3CUnit.Form.Source THEN textForm := &quot;source&quot;
          ELSIF uf = M3CUnit.Form.DontCare THEN textForm := &quot;source or AST&quot;
          ELSE textForm := &quot;AST&quot;;
          END; (* if *)
          Err.Print(Fmt.F(&quot;%s %s for %s \'%s\'&quot;, prefix,
                        textForm, M3CUnit.TypeName(unitType), name),
                  Err.Severity.Error);
        END; (* if *)
      END; (* begin *)
    ELSE
      IF uf = M3CUnit.Form.Source THEN
        cu := NEW(M3AST_AS.Compilation_Unit).init();
        cu.fe_uid := sourceId;
        AddCu();
        CheckPrimarySource(unitType, name, cu, cd);
      END;

      Notify(context, NotifyMode.Before, name, unitType, uf, cu, compTime);

      IF uf = M3CUnit.Form.Source THEN        (* needs compiling from source *)
        saveErrCuList := InitErrorObserver(cd.en, cu);
        M3CGo.CompileUnit(cu, context, stream, FindUnpickleOrCompileSource,
            cd.phases, compTime, cd.headerOnly);
        &lt;*FATAL Rd.Failure, Thread.Alerted*&gt; BEGIN
          Rd.Close(stream);
        END;
        CheckUnitNameAndType(context, unitType, name, cu);
        ShowErrors(cd.en, saveErrCuList);
      ELSE
        IF cd.setCompTime THEN startTime := M3Time.Now() END;
        cu := Unpickle(context, stream, M3CUnit.TextName(sourceId));
        IF cd.setCompTime THEN compTime.parse := M3Time.Interval(startTime) END;
        AddCu();
      END; (* if *)

      Notify(context, NotifyMode.After, name, unitType, uf, cu, compTime);
    END; (* if *)

    RETURN cu # NIL;
  END UnpickleOrCompileSource;

PROCEDURE <A NAME="CompileStandard"><procedure>CompileStandard</procedure></A>(context: M3Context.T) RAISES {} =
  VAR
    cu: M3AST_AS.Compilation_Unit;
    cd := GetData(context);
  BEGIN
   IF NOT cd.compiledStandard THEN
    (* Always compile the Standard identifiers, and introduce them into
    the scope permanently for all subsequent compilations. *)
    IF FindUnpickleOrCompileSource(Standard, M3CUnit.Type.Interface, context, cu) THEN
      M3Context.SetStandard(cu);
      (* If we actually compiled standard, this wont do anything.
         If we unpickled, it adds them to the scope.
      *)
      IF M3CUnit.State.SemChecked IN cd.phases THEN
        M3CScope.Standard(cu);
        M3CMkStd.RegisterBuiltIns(cu);
      END; (* if *)
      cd.compiledStandard := TRUE;
    END
   END
  END CompileStandard;

PROCEDURE <A NAME="CompileModulesOrInterfaces"><procedure>CompileModulesOrInterfaces</procedure></A>(
    units: REF ARRAY OF TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T
    ) RAISES {} =
  VAR
    cu: M3AST_AS.Compilation_Unit;
    cd := GetData(context);
  BEGIN
    IF NOT ParseOnly(cd.phases) THEN CompileStandard(context); END;
    FOR i := 0 TO NUMBER(units^)-1 DO
      IF FindOrCompileSource(units[i], unitType, context, cu) THEN
      END;
    END; (* for *)
  END CompileModulesOrInterfaces;

PROCEDURE <A NAME="CompileUnitsInContext"><procedure>CompileUnitsInContext</procedure></A>(
    VAR (*inout*) context: M3Context.T;
    READONLY interfaces, modules, pathNames: ARRAY OF TEXT;
    VAR (*inout*) phases: M3CUnit.Status;
    headerOnly := FALSE;
    setPrimarySource := TRUE;
    setCompTime: BOOLEAN := FALSE;
    ) RAISES {}=
  VAR
    compilees: CompileeArray;
    cd: ContextData;
  BEGIN
    IF context = NIL THEN
      context := M3Context.New();
    END;
    cd := GetData(context);
    M3Error.AddNotification(cd.en);
    cd.phases := phases; (* accumulate status in the global *)
    cd.headerOnly := headerOnly;
    cd.setPrimarySource := setPrimarySource;
    cd.setCompTime := setCompTime;
    CheckGarbageAndExtensions(interfaces, modules, pathNames, compilees);
    FOR i := FIRST(Compilee) TO LAST(Compilee) DO
      cd.compilees[i] := Remember(compilees[i]);
      M3ContextRemove.Units(context, compilees[i]^, ToUnitType(i));
    END;
    M3CConcTypeSpec.Validate(context);
    (* Now compile the requested units *)
    FOR i := FIRST(Compilee) TO LAST(Compilee) DO
      CompileModulesOrInterfaces(compilees[i], ToUnitType(i), context);
    END;
    phases := cd.phases;
    M3Error.RemoveNotification(cd.en);
  END CompileUnitsInContext;

PROCEDURE <A NAME="ToUnitType"><procedure>ToUnitType</procedure></A>(ce: Compilee): M3CUnit.Type=
  BEGIN
    IF ce = Compilee.Int OR ce = Compilee.PnInt THEN
      RETURN M3CUnit.Type.Interface
    ELSE
      RETURN M3CUnit.Type.Module
    END;
  END ToUnitType;

PROCEDURE <A NAME="CheckGarbageAndExtensions"><procedure>CheckGarbageAndExtensions</procedure></A>(
    READONLY interfaces, modules, pathNames: ARRAY OF TEXT;
    VAR (*out*) compilees: CompileeArray)=
  VAR
    n_interfaces, n_modules, n_pn_interfaces, n_pn_modules: INTEGER := 0;
    t: M3Extension.T;
    interfaces_l, modules_l, pn_interfaces_l, pn_modules_l: TextList.T;
  BEGIN
    FOR i := 0 TO NUMBER(interfaces)-1 DO
      IF GarbageModuleName(interfaces[i]) THEN
      ELSE
        interfaces_l := TextList.AppendD(interfaces_l,
                                        TextList.List1(interfaces[i]));
	INC(n_interfaces);
      END;
    END; (* for *)
    compilees[Compilee.Int] := ArrayFromList(interfaces_l);

    FOR i := 0 TO NUMBER(modules)-1 DO
      IF GarbageModuleName(modules[i]) THEN
      ELSE
        modules_l := TextList.AppendD(modules_l,
                                        TextList.List1(modules[i]));
	INC(n_modules);
      END;
    END; (* for *)
    compilees[Compilee.Mod] := ArrayFromList(modules_l);

    (* Now check the pathnames, splitting them into interfaces
       and modules, based on their extensions. *)
    FOR i := 0 TO NUMBER(pathNames)-1 DO
      IF GarbageModuleName(ModuleName(pathNames[i])) THEN
        (* ignore *)
      ELSIF M3Extension.Has(pathNames[i], t) AND t IN M3Extension.Ints THEN
        pn_interfaces_l := TextList.AppendD(pn_interfaces_l,
                      TextList.List1(pathNames[i]));
	INC(n_pn_interfaces);
      ELSIF M3Extension.Has(pathNames[i], t) AND t IN M3Extension.Mods THEN
        pn_modules_l := TextList.AppendD(pn_modules_l,
                      TextList.List1(pathNames[i]));
	INC(n_pn_modules);
      END;
    END;
    compilees[Compilee.PnInt] := ArrayFromList(pn_interfaces_l);
    compilees[Compilee.PnMod] := ArrayFromList(pn_modules_l);

  END CheckGarbageAndExtensions;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="ArrayFromList"><procedure>ArrayFromList</procedure></A>(sl: TextList.T): REF ARRAY OF TEXT RAISES {} =
  VAR
    a := NEW(REF ARRAY OF TEXT, TextList.Length(sl));
  BEGIN
    FOR i := FIRST(a^) TO LAST(a^) DO
      a[i] := sl.head;
      sl := sl.tail;
    END;
    RETURN a;
  END ArrayFromList;

PROCEDURE <A NAME="GarbageModuleName"><procedure>GarbageModuleName</procedure></A>(name: TEXT): BOOLEAN=
  BEGIN
    FOR i := 0 TO Text.Length(name)-1 DO
      VAR ch := ASCII.Upper[Text.GetChar(name, i)];
      BEGIN
        IF ch &gt;= 'A' AND ch &lt;= 'Z' OR
           (i &gt;= 1 AND
             (ch &gt;= '0' AND ch &lt;= '9' OR
             ch = '_')) THEN
          (* ok *)
        ELSE
          Err.Print(Fmt.F(&quot;illegal unit name '%s'- ignored&quot;,
                          name), Err.Severity.Warning);
          RETURN TRUE
        END;
      END;
    END;
    RETURN FALSE;
  END GarbageModuleName;

PROCEDURE <A NAME="Remember"><procedure>Remember</procedure></A>(units: REF ARRAY OF TEXT): REF ARRAY OF TEXT=
  VAR a := NEW(REF ARRAY OF TEXT, NUMBER(units^));
  BEGIN
    FOR i := 0 TO NUMBER(a^)-1 DO
      a[i] := ModuleName(units[i]);
    END; (* for *)
    RETURN a;
  END Remember;

PROCEDURE <A NAME="CheckPrimarySource"><procedure>CheckPrimarySource</procedure></A>(ut: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit;
    cd: ContextData) RAISES {} =
  VAR
    cut: M3CUnit.Type;
  BEGIN
    IF NOT cd.setPrimarySource THEN RETURN END;
    FOR c := FIRST(Compilee) TO LAST(Compilee) DO
      cut := ToUnitType(c);
      IF cut = ut THEN
        FOR i := 0 TO NUMBER(cd.compilees[c]^)-1 DO
          IF Text.Equal(cd.compilees[c][i], ModuleName(name)) THEN
           cu.fe_status := cu.fe_status + M3CUnit.Status{PrimarySource};
          END; (* if *)
        END; (* for *)
      END
    END
  END CheckPrimarySource;

PROCEDURE <A NAME="CheckUnitNameAndType"><procedure>CheckUnitNameAndType</procedure></A>(context: M3Context.T; unitType: M3CUnit.Type;
    name: TEXT; cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR real_name: TEXT;
      real_type: M3CUnit.Type;
      change := FALSE;
  BEGIN
    WITH symrep = cu.as_root.as_id.lx_symrep DO
      IF symrep # NIL THEN
        real_name := M3CId.ToText(symrep);
        real_type := M3CUnit.ToType(cu.as_root);
        IF (real_type IN M3CUnit.Interfaces AND
           NOT (unitType IN M3CUnit.Interfaces)) OR
           (real_type IN M3CUnit.Modules AND
           NOT (unitType IN M3CUnit.Modules)) THEN
          change := TRUE;
          M3Error.Warn(cu.as_root.as_id,
              &quot;unit type does not match file extension&quot;);
        END; (* if *)
        IF NOT Text.Equal(real_name, ModuleName(name)) THEN
          change := TRUE;
          M3Error.WarnWithId(cu.as_root.as_id,
              &quot;unit name \'%s\' does not match filename&quot;, symrep);
        END; (* if *)
        IF change THEN
          M3Context.Remove(context, name, unitType);
          CheckedAdd(context, real_name, real_type, cu);
        END; (* if *)
      END; (* if *)
    END;
  END CheckUnitNameAndType;

PROCEDURE <A NAME="CheckedAdd"><procedure>CheckedAdd</procedure></A>(
    context: M3Context.T;
    name: TEXT;
    ut: M3CUnit.Type;
    cu: M3AST_AS.Compilation_Unit)
    RAISES {}=
  BEGIN
    TRY
      M3Context.Add(context, name, ut, cu);
    EXCEPT
    | M3Context.Duplicate =&gt;
        Err.Print(Fmt.F(&quot;duplicate interface or module with name '%s'&quot;,
                        name), Err.Severity.Error);
    END;
  END CheckedAdd;

PROCEDURE <A NAME="ParseOnly"><procedure>ParseOnly</procedure></A>(s: M3CUnit.Status): BOOLEAN RAISES {} =
  BEGIN
    RETURN (s * AllPhases) = M3CUnit.Status{M3CUnit.State.Parsed};
  END ParseOnly;

PROCEDURE <A NAME="GetData"><procedure>GetData</procedure></A>(c: M3Context.T): ContextData=
  VAR cd: ContextData := c.get(TYPECODE(ContextData));
  BEGIN
    IF cd = NIL THEN
      cd := NEW(ContextData);
      cd.en := NEW(ErrorNotification);
      cd.en.cd := cd;
      c.put(cd);
    END;
    RETURN cd;
  END GetData;

BEGIN

END M3CGoList.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
