<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3DepFindFile.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3DepFindFile.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3DepFindFile</CODE> provides a file-finder with basic support
for dependency analysis in terms of file timestamps. 

<P><PRE>INTERFACE <interface><A HREF="M3DepFindFile.m3">M3DepFindFile</A></interface>;

IMPORT <A HREF="../../../../time/src/Common/Time.i3">Time</A>, <A HREF="../../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>;
IMPORT <A HREF="M3Extension.i3">M3Extension</A>, <A HREF="M3PathElem.i3">M3PathElem</A>, <A HREF="M3DirFindFile.i3">M3DirFindFile</A>;

TYPE <A HREF="M3DepFindFile.m3#T">T</A> &lt;: Public;
  Public = M3DirFindFile.TFinder OBJECT
  METHODS
    init(exts: M3Extension.TSet;
         rd: Rd.T;
         oldFinder: T := NIL): T RAISES {OSError.E};
    rescan(): T;
    validateDir(dir: TEXT): M3PathElem.T;
    interfaces(oldt: T; VAR (*out*) u: UpdateRec;
               inDir: M3PathElem.T := NIL);
    modules(oldt: T; VAR (*out*) u: UpdateRec;
            inDir: M3PathElem.T := NIL);
    infoOf(name: TEXT; ext: M3Extension.T): Info;
  END;

TYPE
  Update = {Deleted, Added, Changed};
  UpdateRec = ARRAY Update OF TextList.T;

  Info = RECORD
    pathName: TEXT := NIL;
    timeStamp: Time.T := 0.0d0
  END;

END M3DepFindFile.
</PRE> <CODE>NEW(T).init(exts, rd, oldFinder)</CODE> first creates a finder by
calling:
<P>
<PRE>
      M3DirFindFile.TFinder.Init(exts, rd, oldFinder) 
</PRE>
It then reads and stores the timestamps of the files that can be
accessed from the finder.
<P>
The <CODE>rescan</CODE> method makes a copy of itself, and then updates the
timestamps on the files in the mutable directories, that is those
search path elements for which <CODE>elem.readOnly()</CODE> returns <CODE>FALSE</CODE>.
<P>
The <CODE>validate</CODE> method checks if <CODE>dir</CODE> is in the list associated with 
its finder and returns the associated <CODE>M3PathElem.T</CODE>, if so. 
Otherwise it returns <CODE>NIL</CODE>.
<P>
The <CODE>interfaces</CODE> method returns the units in that are newer than in
<CODE>oldt</CODE>.  If <CODE>oldt = NIL</CODE>, all interfaces are returned.  If <CODE>inDir #
NIL</CODE>, then the search is restricted to units in directory <CODE>inDir</CODE>.
<P>
The <CODE>infoOf</CODE> method returns the pathname and file system time stamp for
the unit denoted by <CODE> name, ext</CODE>.  The <CODE>pathName</CODE> field will be <CODE>NIL</CODE> if
such a unit does not exist.  The <CODE>timeStamp</CODE> field will be <CODE>NIL</CODE> if it
cannot be read. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
