<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3DepFindFile.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3DepFindFile.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3DepFindFile.i3">M3DepFindFile</A></implements></module>;

IMPORT <A HREF="../../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">Err</A>, <A HREF="../../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../../time/src/Common/Time.i3">Time</A>, <A HREF="../../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../../os/src/Common/File.i3">File</A>, <A HREF="../../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="M3FindFile.i3">M3FindFile</A>, <A HREF="M3Extension.i3">M3Extension</A>, <A HREF="M3DirFindFile.i3">M3DirFindFile</A>, <A HREF="M3PathElem.i3">M3PathElem</A>;

&lt;*FATAL M3FindFile.Failed*&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init := Init;
    rescan := Rescan;
    validateDir := ValidateDir;
    interfaces := Interfaces;
    modules := Modules;
    infoOf := InfoOf;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(
    newFinder: T;
    exts: M3Extension.TSet;
    rd: Rd.T;
    oldFinder: T := NIL)
    : T
    RAISES {OSError.E} =
  BEGIN
    EVAL M3DirFindFile.TFinder.init(newFinder, exts, rd, oldFinder);
    Scan(newFinder);
    RETURN newFinder;
  END Init;

PROCEDURE <A NAME="Rescan"><procedure>Rescan</procedure></A>(f: T): T=
  VAR t := NEW(T).merge(f, NIL);
  BEGIN
    Scan(t);
    RETURN t;
  END Rescan;

PROCEDURE <A NAME="Scan"><procedure>Scan</procedure></A>(f: T) RAISES {}=
  VAR
    iter := f.iterate();
    unitName: TEXT;
    dir: M3PathElem.T;
    ext: M3Extension.T;
  BEGIN
    WHILE iter.next(unitName, ext, dir) DO
      IF ext IN M3Extension.Ints OR ext IN M3Extension.Mods THEN
	IF f.getProperty(unitName, ext) = NIL OR NOT dir.readOnly() THEN
	  VAR fullName := Pathname.Join(dir.text(),
	                                unitName, M3Extension.ToText(ext));
              status : File.Status;
              fs := NEW(REF Time.T);
          BEGIN
	    TRY	
              status := FS.Status(fullName);
              fs^ := status.modificationTime;
              f.setProperty(unitName, ext, fs);
            EXCEPT OSError.E(e) =&gt;
	      Err.Print(
	          Fmt.F(&quot;problem reading timestamp for %s - %s\n&quot;,
		        fullName, Atom.ToText(e.head)), Err.Severity.Warning);
            END;
          END;
        END;
      END; (* if *)	
    END; (* while *)
  END Scan;

PROCEDURE <A NAME="ValidateDir"><procedure>ValidateDir</procedure></A>(t: T; dirName: TEXT): M3PathElem.T RAISES {}=
  VAR
    dirs := t.dirs();
    dirElem := M3PathElem.FromText(dirName, dirName);
  BEGIN
    WHILE dirs # NIL DO
      IF dirs.head = dirElem THEN RETURN dirs.head
      ELSE dirs := dirs.tail
      END;
    END;
    RETURN NIL;
  END ValidateDir;

PROCEDURE <A NAME="Interfaces"><procedure>Interfaces</procedure></A>(
    t, oldt: T;
    VAR (*out*) u: UpdateRec;
    inDir: M3PathElem.T := NIL)
    RAISES {}=
  BEGIN
    Units(oldt, t, u, inDir, M3Extension.Ints);
  END Interfaces;

PROCEDURE <A NAME="Modules"><procedure>Modules</procedure></A>(
    t, oldt: T;
    VAR (*out*) u: UpdateRec;
    inDir: M3PathElem.T := NIL)
    RAISES {}=
  BEGIN
    Units(oldt, t, u, inDir, M3Extension.Mods);
  END Modules;

PROCEDURE <A NAME="Units"><procedure>Units</procedure></A>(oldt, t: T;
    VAR (*out*) u: UpdateRec;
    thisDirElem: M3PathElem.T;
    wantedExts: M3Extension.TSet;)
    RAISES {}=
  VAR
    iter: M3DirFindFile.Iter;
    ext: M3Extension.T;
    unitName: TEXT;
    new: BOOLEAN;
    dirElem, oldDirElem: M3PathElem.T;
  BEGIN
    FOR a := FIRST(Update) TO LAST(Update) DO u[a] := NIL END;
    (* generate 'Deleted' array *)
    IF oldt # NIL THEN
      iter := oldt.iterate();
      WHILE iter.next(unitName, ext, dirElem) DO
        IF ext IN wantedExts THEN
	  TRY
	    EVAL t.find(unitName, ext);
	  EXCEPT
	  | M3FindFile.Failed =&gt;
	      u[Update.Deleted] := TextList.AppendD(u[Update.Deleted],
	                                           TextList.List1(unitName));
          END;
 	END; (* if *)
     END; (* while *)
    END; (* if *)
    (* generate 'Changed' and 'Added' *)
    iter := t.iterate();
    WHILE iter.next(unitName, ext, dirElem) DO
      IF ext IN wantedExts THEN
        IF thisDirElem = NIL OR dirElem = thisDirElem THEN
           new := TRUE;
           IF oldt # NIL THEN
             TRY
	       oldDirElem := oldt.dirOf(unitName, ext);
	       (* Ok, existed before, check directory *)
	       IF dirElem = oldDirElem THEN
	         new := FALSE;
	         (* ok, check timestamp *)
                 VAR
	           f1 := NARROW(oldt.getProperty(unitName, ext),
                             REF Time.T);
	           f2 := NARROW(t.getProperty(unitName, ext),
                             REF Time.T);
	         BEGIN
	           IF (f1 # f2) AND (f1^ # f2^) THEN
	      	     u[Update.Changed] := TextList.AppendD(u[Update.Changed],
                                              TextList.List1(unitName));
	           END; (* if *)
                 END;
               ELSE
                 (* Changed directory! Treat this as Deleted + Added *)
	         u[Update.Deleted] := TextList.AppendD(u[Update.Deleted],
                                          TextList.List1(unitName));
	       END; (* if *)
             EXCEPT
             | M3FindFile.Failed =&gt; (* new is TRUE *)
	     END;
          END;

	  IF new THEN
	    (* brand new unit *)
	    u[Update.Added] := TextList.AppendD(u[Update.Added],
                                   TextList.List1(unitName));
	  END;
        END;
      END; (* if *)
    END; (* while *)
  END Units;

PROCEDURE <A NAME="InfoOf"><procedure>InfoOf</procedure></A>(t: T; name: TEXT; ext: M3Extension.T): Info=
  VAR info: Info;
  BEGIN
    TRY
      VAR
        dirElem := t.dirOf(name, ext);
      BEGIN
        info.pathName := Pathname.Join(dirElem.text(),
                                       name, M3Extension.ToText(ext));
        info.timeStamp := NARROW(t.getProperty(name, ext), REF Time.T)^;
      END;
    EXCEPT M3FindFile.Failed =&gt;
    END;
    RETURN info;
  END InfoOf;

BEGIN

END M3DepFindFile.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
