<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3DirFindFile.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3DirFindFile.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3DirFindFile</CODE> provides a file finder for a search path
specified as a list of directories (an <CODE>M3PathElemList.T</CODE>). 

<P><PRE>INTERFACE <interface><A HREF="M3DirFindFile.m3">M3DirFindFile</A></interface>;

IMPORT <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="M3Extension.i3">M3Extension</A>, <A HREF="M3FindFile.i3">M3FindFile</A>, <A HREF="M3PathElem.i3">M3PathElem</A>, <A HREF="M3PathElemList.i3">M3PathElemList</A>;
FROM <A HREF="M3FindFile.i3">M3FindFile</A> IMPORT Failed;

TYPE
  <A HREF="M3DirFindFile.m3#Finder">Finder</A> &lt;: FinderPublic;
  FinderPublic = M3FindFile.T OBJECT
  METHODS
    init(exts: M3Extension.TSet;
         dirs: M3PathElemList.T;
         oldFinder: Finder := NIL;
         errorHandler: ErrorHandler := NIL
        ): Finder RAISES {OSError.E};

    dirOf(name: TEXT; ext: M3Extension.T
         ): M3PathElem.T RAISES {Failed};

    dirs(): M3PathElemList.T;

    iterate(): Iter;

    setProperty(name: TEXT; ext: M3Extension.T;
                value: REFANY) RAISES {Failed};
    getProperty(name: TEXT; ext: M3Extension.T
               ): REFANY RAISES {Failed};

    merge(f1, f2: Finder): Finder;
  END;

  ErrorHandler = OBJECT
  METHODS
    callback(dir: M3PathElem.T; ec: OSError.Code): BOOLEAN;
  END;

  <A HREF="M3DirFindFile.m3#TFinder">TFinder</A> &lt;: TFinderPublic;
  TFinderPublic = Finder OBJECT
  METHODS
    init(
        exts: M3Extension.TSet;
        rd: Rd.T;
        oldFinder: Finder := NIL): Finder RAISES {OSError.E};
  END;

TYPE
  <A HREF="M3DirFindFile.m3#Iter">Iter</A> &lt;: IterPublic;
  IterPublic = OBJECT
  METHODS
    next(VAR (*out*) unitName: TEXT;
         VAR (*out*) ext: M3Extension.T;
         VAR (*out*) dir: M3PathElem.T): BOOLEAN;
    close();
  END;

END M3DirFindFile.
</PRE> <CODE>NEW(Finder).init(...)</CODE> returns a finder object for the given list
of directories. The <CODE>find</CODE> method of the returned finder object will
look for the file corresponding to the name and extension in each of
the directories in the list. The search is ordered so if there are two
file names in different directories which match a given name and
extension the file name earliest on the directory list will be
returned. If <CODE>oldFinder # NIL</CODE>, it is used to propagate information
from directories marked as {\it read-only} to the new finder. If an
error occurs reading any of the directories, then if <CODE>errorHandler = NIL</CODE>
<CODE>OSError.E</CODE> will be raised. If <CODE>errorHandler # NIL</CODE>, 
<CODE>errorHandler.callback(dir, ec)</CODE> will be called, where <CODE>dir</CODE> represents
the directory element that could not be opened and <CODE>ec</CODE> represents
the code that would have been passed with the <CODE>OSError.E</CODE> exception.
Processing continues if a result of <CODE>TRUE</CODE> is returned from the
callback, or aborts otherwise with a result of <CODE>NIL</CODE> from <CODE>Init</CODE>.
<P>
The <CODE>exts</CODE> method returns the value of <CODE>exts</CODE> passed to <CODE>init</CODE>.  The
<CODE>dirOf</CODE> method returns the directory, as an <CODE>Elem</CODE>, of the pathname
returned by the <CODE>find</CODE> method.  The <CODE>dirs</CODE> method returns the list of
directories that were returned by the internal call of <CODE>Read</CODE> when the
finder was created.
<P>
The <CODE>iterate</CODE> method returns an iterator on the files associated with
the finder. The <CODE>next</CODE> method will return FALSE if the iteration is
exhausted, else it returns <CODE>TRUE</CODE> and sets the <CODE>VAR</CODE> parameters to the
unit name, extension and directory of the next file, respectively.
<P>
The <CODE>setProperty</CODE> method associates <CODE>value</CODE> with file defined by the
pair <CODE>name,ext</CODE>, raising <CODE>M3FindFile.Failed</CODE> if no such file exists.
Any existing value is overwritten. The <CODE>getProperty</CODE> returns the value
associated with <CODE>name,ext</CODE>, or <CODE>NIL</CODE> if no such value has been
associated.
<P>
<P>
<CODE>NEW(T).merge(f1, f2)</CODE> merges <CODE>f1</CODE>, with <CODE>f2</CODE>, and returns the finder.
Viewing a finder as defining a set of pairs, <CODE>name, ext</CODE>, the new
finder is defined by the union of <CODE>f1</CODE> and <CODE>f2</CODE>. Where the finders
overlap, the information from <CODE>f1</CODE> is taken. It is legal for <CODE>f2</CODE> to
be <CODE>NIL</CODE>, in which case the result is a copy of <CODE>self</CODE>.
<P>
The effect of altering the directories given in the path list while
the find object is in use is undefined (e.g. the implementation of
<CODE>Find</CODE> may build a cache which may become out of date). Create a new
finder if the directory list or the contents of the directory may have
changed.
<P>
A <CODE>TFinder</CODE> is very like a <CODE>Finder</CODE>, except that the list of directory
names and the set of filenames in those directories is explicitly
encoded on the reader <CODE>rd</CODE> passed to <CODE>NEW(TFinder).init</CODE>, according to
the following syntax:
<P>
<PRE>
      TSpec = { Dir {File} } .
      Dir = @Pathname .
      File = Filename .
</PRE>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
