<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3Directory.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3Directory.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3Directory.i3">M3Directory</A></implements></module>;

IMPORT
  <A HREF="M3Extension.i3">M3Extension</A>, <A HREF="../../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>;

REVEAL
  <A NAME="Iter">Iter</A> = Public BRANDED OBJECT
    d: Pathname.T; (* name of directory we're iterating *)
    e: M3Extension.TSet; (* extensions this iterator is interested in *)
    dirIter: FS.Iterator;
  OVERRIDES
    next := Next;
    close := Close;
  END;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(
    d: Pathname.T;
    exts: M3Extension.TSet
      := M3Extension.TSet{FIRST(M3Extension.T)..LAST(M3Extension.T)})
    : Iter RAISES {OSError.E} =
  BEGIN
    RETURN NEW(Iter, d := d, e := exts, dirIter := FS.Iterate(d));
  END NewIter;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(t: Iter)=
  BEGIN
    t.dirIter.close();
  END Close;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(
    t: Iter;
    VAR name: TEXT;
    VAR ext: M3Extension.T)
    : BOOLEAN  =
  VAR
    p: Pathname.T;
  BEGIN
    WHILE t.dirIter.next(p) DO
      IF M3Extension.Has(p, ext) THEN
        IF ext IN t.e THEN
          name := Pathname.LastBase(p);
          RETURN TRUE;
        END;
      END;
    END;
    RETURN FALSE;
  END Next;

BEGIN
END M3Directory.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
