<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3Extension.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3Extension.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3Extension</CODE> provides operations on filename extensions. 

<P><PRE>INTERFACE <interface><A HREF="M3Extension.m3">M3Extension</A></interface>;

TYPE
  T =
    {Int,       (* interface source *)
     IntG,      (* generic interface source *)
     PInt,      (* pickled interface (AST) *)
     PIntR,     (* pickled interface, reduced AST *)
     Mod,       (* module source *)
     ModG,      (* generic module source *)
     PMod,      (* pickled module (AST)  *)
     PModR,     (* pickled module, reduced AST *)
     IObj,      (* (interface) object *)
     MObj,      (* (module) object *)
     Exe,       (* executable *)
     IC,        (* (interface) C intermediate *)
     MC,        (* (module) C intermediate *)
     IAsm,      (* (interface) assembly code *)
     MAsm,      (* (module) assembly code *)
     IX,        (* (interface) pre-linker input *)
     MX,        (* (module) pre-linker input *)
     ObjLib,    (* object library *)
     ObjLibX,   (* pre-linker input library *)
     Tmp,       (* temporary file *)
     Null};     (* no extension *)

  TSet = SET OF T;
</PRE> There are a number of extensions commonly used by an M3 system, captured
by the enumeration type <CODE>T</CODE>. Not all the extension types may be utilised
by a given implementation. The actual characters used to denote a <CODE>T</CODE>
may vary between implementations. 

<P><PRE>CONST
  Ints = TSet{T.Int, T.IntG};
  Mods = TSet{T.Mod, T.ModG};
  All = TSet{FIRST(T)..LAST(T)};

PROCEDURE <A HREF="M3Extension.m3#ToText">ToText</A>(t: T): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the <CODE>TEXT</CODE> corresponding to <CODE>t</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Extension.m3#FromText">FromText</A>(text: TEXT; VAR t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> If <CODE>text</CODE> is a valid Modula-3 extension, set <CODE>t</CODE> and return <CODE>TRUE</CODE>.
Otherwise, leave <CODE>t</CODE> unchanged and return <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Extension.m3#Extend">Extend</A>(name: TEXT; t: T): TEXT;
</PRE><BLOCKQUOTE><EM> If <CODE>t = T.Null</CODE>, then return <CODE>Pathname.Base(name)</CODE> else
return <CODE>Pathname.Join(NIL, Pathname.Base(name), ToText(t))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Extension.m3#Has">Has</A>(name: TEXT; VAR t: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Returns <CODE>FromText(Pathname.LastExt(name), t)</CODE>. </EM></BLOCKQUOTE><PRE>

END M3Extension.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
