<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3Extension.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3Extension.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> Version which support DEC SRC Modula-3 extensions 

<P><PRE>MODULE <module><implements><A HREF="M3Extension.i3">M3Extension</A></implements></module>;

IMPORT <A HREF="../../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;

VAR
  exts_g := NEW(TextRefTbl.Default).init();

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(t: T): TEXT  =
  BEGIN
    CASE t OF
      T.Int =&gt;   RETURN &quot;i3&quot;;
    | T.IntG =&gt; RETURN &quot;ig&quot;;
    | T.PInt =&gt;  RETURN &quot;pi&quot;;
    | T.PIntR =&gt; RETURN &quot;pir&quot;;
    | T.Mod =&gt;   RETURN &quot;m3&quot;;
    | T.ModG =&gt; RETURN &quot;mg&quot;;
    | T.PMod =&gt;  RETURN &quot;pm&quot;;
    | T.PModR =&gt; RETURN &quot;pmr&quot;;
    | T.IObj =&gt; RETURN &quot;io&quot;;
    | T.MObj =&gt; RETURN &quot;mo&quot;;
    | T.Exe =&gt; RETURN &quot;out&quot;;
    | T.MC =&gt; RETURN &quot;mc&quot;;
    | T.IC =&gt; RETURN &quot;ic&quot;;
    | T.MX =&gt; RETURN &quot;mx&quot;;
    | T.IX =&gt; RETURN &quot;ix&quot;;
    | T.MAsm =&gt; RETURN &quot;ms&quot;;
    | T.IAsm =&gt; RETURN &quot;is&quot;;
    | T.Tmp =&gt;  RETURN &quot;tmp&quot;;
    | T.ObjLib =&gt; RETURN &quot;a&quot;;
    | T.ObjLibX =&gt; RETURN &quot;ax&quot;;
    | T.Null =&gt; RETURN &quot;&quot;;
    END;
  END ToText;

PROCEDURE <A NAME="FromText"><procedure>FromText</procedure></A>(text: TEXT; VAR t: T): BOOLEAN=
  VAR
    ref: REFANY;
  BEGIN
    IF exts_g.get(text, ref) THEN
      t := NARROW(ref, REF T)^;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END FromText;

PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A>(name: TEXT; t: T): TEXT=
  VAR b := Pathname.Base(name);
  BEGIN
    IF t = T.Null THEN RETURN b;
    ELSE RETURN Pathname.Join(NIL, b, ToText(t));
    END;
  END Extend;

PROCEDURE <A NAME="Has"><procedure>Has</procedure></A>(name: TEXT; VAR t: T): BOOLEAN=
  BEGIN
    RETURN FromText(Pathname.LastExt(name), t);
  END Has;

EXCEPTION Fatal;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>() =
  BEGIN
    FOR i := FIRST(T) TO LAST(T) DO
      IF exts_g.put(ToText(i), NewRefT(i)) THEN
        &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal; END;
      END;
    END; (* for *)
  END Init;

PROCEDURE <A NAME="NewRefT"><procedure>NewRefT</procedure></A>(t: T): REF T=
  VAR
    r: REF T;
  BEGIN
    r := NEW(REF T);
    r^ := t;
    RETURN r;
  END NewRefT;

BEGIN
  Init();
END M3Extension.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
