<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3FindFile.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3FindFile.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3FindFile</CODE> defines an abstract object type that provides some
basic file handling operations. 

<P><PRE>INTERFACE <interface>M3FindFile</interface>;

IMPORT <A HREF="../../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="M3Extension.i3">M3Extension</A>;

EXCEPTION
  Failed;

TYPE
  T = OBJECT
  METHODS
    exts(): M3Extension.TSet;
    find(name: TEXT; ext: M3Extension.T): TEXT
        RAISES {Failed};
    openRead(name: TEXT; ext: M3Extension.T): Rd.T
        RAISES {OSError.E, Failed};
  END;

END M3FindFile.
</PRE> Objects of this type are used to find a file name given a module or
interface name and an extension.  The <CODE>exts</CODE> method returns the set of
extensions for which the file finder provides this lookup service.
Trying to look up a file with an extension not in the set returned by
<CODE>exts</CODE> will typically cause a checked runtime error.  The <CODE>find</CODE>
method does the work; it constructs the name of the file corresponding
to <CODE>name</CODE> and <CODE>ext</CODE> and returns it. If there is no such file it raises
<CODE>Failed</CODE>. For example a simple file <CODE>find</CODE> method might just use
<CODE>M3Extension.Extend</CODE> to construct a file name and then check if the
name corresponds to an existing file. More complex <CODE>find</CODE> methods
might look for the corresponding file in some list of locations.  Note
that on some systems a file may exist but it is impossible to tell
that it exists because it is totally inaccessible. If the file
corresponding to <CODE>name</CODE> and <CODE>ext</CODE> is totally inaccessible in this way
the <CODE>find</CODE> method will raise <CODE>Failed</CODE>. The <CODE>openRead</CODE> method tries to
open a reader on the pathname returned by <CODE>find(name, ext)</CODE>. If there
is no such file, <CODE>Failed</CODE> is raised. If an error occurs trying to open
the file, <CODE>OSError.E</CODE> is raised. 

<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
