<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3PathDefaults.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3PathDefaults.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3PathDefaults.i3">M3PathDefaults</A></implements></module>;

IMPORT <A HREF="../../../../os/src/Common/Process.i3">Process</A>, <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>;
IMPORT <A HREF="M3PathElemList.i3">M3PathElemList</A>, <A HREF="M3PathElem.i3">M3PathElem</A>;

VAR
  currentElem_g: M3PathElem.T := NIL;

PROCEDURE <A NAME="EnsureCurrentFirst"><procedure>EnsureCurrentFirst</procedure></A>(l: M3PathElemList.T): M3PathElemList.T=
  VAR t := l;
  &lt;* FATAL OSError.E *&gt;
  BEGIN
    IF currentElem_g = NIL THEN
      WITH cd = Process.GetWorkingDirectory() DO
        currentElem_g := M3PathElem.FromText(cd, cd);
      END;
    END;
    WHILE t # NIL DO
      IF t.head = currentElem_g THEN
        (* delete it and move it to front *)
        l := M3PathElemList_DeleteD(l, currentElem_g);
        EXIT;
      ELSE
        t := t.tail;
      END;
    END;
    RETURN M3PathElemList.Cons(currentElem_g, l)
  END EnsureCurrentFirst;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(l: M3PathElemList.T; d: M3PathElem.T): M3PathElemList.T=
  VAR t := l;
  BEGIN
    WHILE t # NIL DO
      IF t.head = d THEN
        RETURN l;
      ELSE
        t := t.tail;
      END;
    END;
    RETURN M3PathElemList.AppendD(l, M3PathElemList.List1(d));
  END Add;

PROCEDURE <A NAME="M3PathElemList_DeleteD"><procedure>M3PathElemList_DeleteD</procedure></A>(list: M3PathElemList.T;
                                 x: REFANY): M3PathElemList.T=
  VAR result, t: M3PathElemList.T;
  BEGIN
    IF list.head = x THEN result := list.tail
    ELSE
      result := list; t := list; list := list.tail;
      WHILE list # NIL DO
        IF list.head = x THEN t.tail := list.tail; EXIT
        ELSE t := list; list := list.tail;
        END;
      END;
    END;
    RETURN result;
  END M3PathElemList_DeleteD;

BEGIN
END M3PathDefaults.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
