<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3PathElem.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3PathElem.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3PathElem</CODE> provides the abstraction of a search path element,
defined as a file system directory. 

<P><PRE>INTERFACE <interface><A HREF="M3PathElem.m3">M3PathElem</A></interface>;

CONST
  Brand = &quot;M3PathElem&quot;;

TYPE <A HREF="M3PathElem.m3#T">T</A> &lt;: Public;
  Public = OBJECT
  METHODS
    text(): TEXT;
    unexpanded(): TEXT;
    readOnly(): BOOLEAN;
    setReadOnly(ro: BOOLEAN := TRUE);
  END;

CONST
  CurrentDir = &quot;&quot;;
</PRE> An <CODE>M3PathElem.T</CODE> is a unique representative for a set of {\it
equal} directories, where equality is a file system specific notion.
For example two textually different names may denote the same
directory by the mechanism of symbolic links.  The <CODE>text</CODE> method
returns the directory name after any environment variables have been
expanded.  <CODE>unexpanded</CODE> returns the unexpanded form. <CODE>readOnly</CODE>
implies that the directory has been designated as read-only.  The
read-only status may be changed via the <CODE>setReadOnly</CODE> call.
<P>
<CODE>CurrentDir</CODE> can be used as an operating system independent denotation
for the current working directory. If it is passed to <CODE>FromText</CODE> it is
as if <CODE>Process.GetWorkingDirectory()</CODE> had been passed instead. 

<P><PRE>PROCEDURE <A HREF="M3PathElem.m3#Equal">Equal</A>(e1, e2: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Returns e1 = e2. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3PathElem.m3#FromText">FromText</A>(expanded, unexpanded: TEXT;
                   readOnly := FALSE): T;
</PRE><BLOCKQUOTE><EM> Return an <CODE>T</CODE> object for <CODE>expanded</CODE>, such that <CODE>t.text()</CODE> will return
<CODE>expanded</CODE>,  <CODE>t.unexpanded()</CODE> will return <CODE>unexpanded</CODE> and <CODE>t.readOnly()</CODE> 
will return <CODE>readOnly</CODE>. </EM></BLOCKQUOTE><PRE>

END M3PathElem.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
