<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3PathElem.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3PathElem.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3PathElem.i3">M3PathElem</A></implements></module>;

IMPORT <A HREF="M3PathElemOS.i3">M3PathElemOS</A>, <A HREF="M3PathElemList.i3">M3PathElemList</A>, <A HREF="../../../../os/src/Common/Process.i3">Process</A>, <A HREF="../../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../../../../os/src/Common/OSError.i3">OSError</A>;
&lt;*FATAL OSError.E*&gt;

VAR
  elemTable_g: M3PathElemList.T := NIL;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    elemText: TEXT;
    elemUnexpanded: TEXT;
    elemReadOnly: BOOLEAN := FALSE;
    uid: M3PathElemOS.T;
  OVERRIDES
    text := ElemText;
    unexpanded := ElemUnexpanded;
    readOnly := ElemReadOnly;
    setReadOnly := SetReadOnly
  END;

PROCEDURE <A NAME="ElemText"><procedure>ElemText</procedure></A>(t: T): TEXT=
  BEGIN
    RETURN t.elemText;
  END ElemText;

PROCEDURE <A NAME="ElemUnexpanded"><procedure>ElemUnexpanded</procedure></A>(t: T): TEXT=
  BEGIN
    RETURN t.elemUnexpanded;
  END ElemUnexpanded;

PROCEDURE <A NAME="ElemReadOnly"><procedure>ElemReadOnly</procedure></A>(t: T): BOOLEAN=
  BEGIN
    RETURN t.elemReadOnly;
  END ElemReadOnly;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(e1, e2: T): BOOLEAN=
  BEGIN
    RETURN e1 = e2;
  END Equal;

PROCEDURE <A NAME="FromText"><procedure>FromText</procedure></A>(expanded, unexpanded: TEXT; readOnly := FALSE): T=
  VAR
    uid: M3PathElemOS.T;
    list := elemTable_g;
    result: T := NIL;
  BEGIN
    IF Text.Equal(expanded, CurrentDir) THEN
      expanded := Process.GetWorkingDirectory()
    END;
    uid := M3PathElemOS.Uid(expanded);
    WHILE list # NIL DO
      IF M3PathElemOS.Equal(list.head.uid, uid) THEN
        result := list.head;
        EXIT;
      ELSE
        list := list.tail;
      END;
    END;
    IF result = NIL THEN
      result := NEW(T, elemText := expanded, elemUnexpanded := unexpanded,
                    uid := uid, elemReadOnly := readOnly);
      elemTable_g := M3PathElemList.Cons(result, elemTable_g);
    END;
    RETURN result;
  END FromText;

PROCEDURE <A NAME="SetReadOnly"><procedure>SetReadOnly</procedure></A>(elem: T; ro := TRUE)=
  BEGIN
    elem.elemReadOnly := ro;
  END SetReadOnly;

BEGIN
END M3PathElem.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
