<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3PathElemOS.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3PathElemOS.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>M3PathElemOS</CODE> is an operating system independent interface to
basic operations on search paths and search path elements. 

<P><PRE>INTERFACE <interface><A HREF="#x1">M3PathElemOS</A></interface>;

IMPORT <A HREF="M3PathElemList.i3">M3PathElemList</A>;

TYPE <A HREF="../POSIX/M3PathElemPosix.m3#T">T</A> &lt;: REFANY;

PROCEDURE <A HREF="../POSIX/M3PathElemPosix.m3#Uid">Uid</A>(dir: TEXT): T;
</PRE><BLOCKQUOTE><EM> Return a handle to denote directory <CODE>dir</CODE>. Two handles that
denote the same directory will return <CODE>TRUE</CODE> wwhen passed to <CODE>Equal</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../POSIX/M3PathElemPosix.m3#Equal">Equal</A>(t1, t2: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>t1</CODE> and <CODE>t2</CODE> denote the same directory. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../POSIX/M3PathElemPosix.m3#EnvExpand">EnvExpand</A>(dir: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Expand any environment variables in <CODE>dir</CODE>, according to the conventions
of the operating system. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3PathElemOS.m3#RemoveParentDenotations">RemoveParentDenotations</A>(dir: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Return a pathname with as many <CODE>parent directory</CODE> denotations
removed as possible. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3PathElemOS.m3#DecomposePath">DecomposePath</A>(path: TEXT; readOnly := FALSE): M3PathElemList.T;
</PRE><BLOCKQUOTE><EM> <CODE>path</CODE> is a list of directories separated by an OS-specific
character, e.g. <CODE>:</CODE>. The path is decomposed into its components
and an <CODE>M3PathElemList.T</CODE> is generated. Each member of the result is
created by a call of <CODE>M3PathElem.FromText(EnvExpand(c), c, readOnly)</CODE>,
where <CODE>c</CODE> is the component pathname. </EM></BLOCKQUOTE><PRE>

END M3PathElemOS.
</PRE>
</inInterface>
<HR>
<A NAME="x1">M3PathElemOS's implementation  is in:
</A><UL>
<LI><A HREF="M3PathElemOS.m3#0TOP0">m3tk/src/files/Common/M3PathElemOS.m3</A>
<LI><A HREF="../POSIX/M3PathElemPosix.m3#0TOP0">m3tk/src/files/POSIX/M3PathElemPosix.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
