<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/M3PathElemOS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/M3PathElemOS.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3PathElemOS.i3">M3PathElemOS</A></implements></module>;

IMPORT <A HREF="../../../../text/src/Text.i3">Text</A>, <A HREF="../../misc/TextExtras.i3">TextExtras</A>, <A HREF="M3PathElem.i3">M3PathElem</A>, <A HREF="M3PathElemList.i3">M3PathElemList</A>;
FROM <A HREF="M3PathElemOSPriv.i3">M3PathElemOSPriv</A> IMPORT SCurrentS, SParentS, PathnameSeparator,
                             PathSeparator;

PROCEDURE <A NAME="RemoveParentDenotations"><procedure>RemoveParentDenotations</procedure></A>(t: TEXT): TEXT=
  VAR a, b: CARDINAL := 0; spsl := Text.Length(SParentS);
  BEGIN
    LOOP
      IF TextExtras.FindSub(t, SParentS, b) THEN
        IF FindPreDirSepChar(t, b, a) THEN
      	  t := TextExtras.Extract(t, 0, a) &amp; (* includes separator *)
	       TextExtras.Extract(t, b+spsl, Text.Length(t));
          (* step 'b', but 't' has shrunk! *)
	  b := a-1;
	ELSE
	  INC(b, spsl);
        END;
      ELSE
      	RETURN t;
      END; (* if *)
    END; (* loop *)
  END RemoveParentDenotations;

PROCEDURE <A NAME="FindPreDirSepChar"><procedure>FindPreDirSepChar</procedure></A>(t: TEXT; b: CARDINAL;
    VAR (*out*) a: CARDINAL): BOOLEAN RAISES {}=
  BEGIN
    (* t[b] begins &quot;SParentS&quot;, look back for preceding separator. *)
    a := b;
    WHILE a &gt; 0 DO
      IF Text.GetChar(t, a-1) = PathnameSeparator THEN
        VAR n := TextExtras.Extract(t, a-1, b+1);
	BEGIN
          IF Text.Equal(n, SCurrentS) OR Text.Equal(n, SParentS) THEN
            RETURN FALSE
	  ELSE
	    RETURN TRUE;
	  END; (* if *)
	END;
      END;
      DEC(a);
    END; (* while *)
    RETURN FALSE;
  END FindPreDirSepChar;

PROCEDURE <A NAME="DecomposePath"><procedure>DecomposePath</procedure></A>(t: TEXT; readOnly := FALSE): M3PathElemList.T=
  VAR
    index, sindex: CARDINAL := 0;
    l := Text.Length(t);
    name: TEXT;
    result: M3PathElemList.T := NIL;
  BEGIN
    WHILE index &lt; l DO
      IF NOT TextExtras.FindChar(t, PathSeparator, index) THEN
        index := l;
      END; (* if *)
      name := TextExtras.Extract(t, sindex, index);
      result := M3PathElemList.AppendD(result, M3PathElemList.List1(
                    M3PathElem.FromText(EnvExpand(name), name, readOnly)));
      sindex := index+1; index := sindex;
    END; (* while *)
    RETURN result;
  END DecomposePath;

BEGIN
END M3PathElemOS.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
