<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/OLD/M3Path.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/OLD/M3Path.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>M3Path</module> EXPORTS <implements>M3Path</implements>;

IMPORT
  CITxtRefTbl, TxtRefTbl, <A HREF="../../../../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../../../rw/src/Common/FileRd.i3">FileRd</A>,
  <A HREF="../M3Directory.i3">M3Directory</A>, <A HREF="../M3Extension.i3">M3Extension</A>, <A HREF="../M3FindFile.i3">M3FindFile</A>, <A HREF="../M3PathElemList.i3">M3PathElemList</A>,
  <A HREF="../../../../../os/src/Common/Pathname.i3">Pathname</A>, TxtList, <A HREF="../../../../../text/src/Text.i3">Text</A>, <A HREF="../../../../../os/src/Common/OSError.i3">OSError</A>;

CONST AllExts
  = M3Extension.TSet{FIRST(M3Extension.T)..LAST(M3Extension.T)};

REVEAL <A NAME="Finder">Finder</A> = FinderPublic BRANDED OBJECT
    table: TxtRefTbl.T;
    localDir: TEXT := &quot;&quot;;
    allDirs: M3PathElemList.T;
    extSet: M3Extension.TSet;
    extCount: CARDINAL;
    extToIndex: ARRAY M3Extension.T OF CARDINAL;
    indexToExt: IndexToExts;
  METHODS
    add(name: TEXT; ext: M3Extension.T; dir: Elem) := Add;
  OVERRIDES
    exts := Exts;
    init := Init;
    find := Find;
    dirOf := DirOf;
    dirs := Dirs;
    iterate := NewIter;
    setProperty := SetProperty;
    getProperty := GetProperty;
    openRead := OpenRead;
  END;

TYPE
  IndexToExts = ARRAY [ORD(FIRST(M3Extension.T))..ORD(LAST(M3Extension.T))]
    OF M3Extension.T;

  (* data associated with each unit entered in the hash table *)
  Info = REF ARRAY OF RECORD
    dir: Elem;          (* handle on associated directory, NIL =&gt; missing *)
    userData: REFANY;   (* place to hang other stuff, e.g. filestamp *)
  END;

PROCEDURE <A NAME="BuildHashTable"><procedure>BuildHashTable</procedure></A>(dirs: M3PathElemList.T;
    oldFinder: Finder;
    newFinder: Finder) RAISES {OSError.E}=
  VAR
    d: Elem;
  BEGIN
    InitHashTable(newFinder);
    newFinder.allDirs := dirs;
    (* Any directory which is read-only in 'dirs' AND appears
       in the old finder list, can have its info copied into
       the new hash table.
    *)
    WHILE dirs # NIL DO
      d := dirs.head;
      IF oldFinder # NIL AND d.readOnly AND
         AppearsIn(oldFinder.allDirs, d) THEN
        VAR
	  iter := oldFinder.table.iterate();
	  name: TEXT;
	  val: REFANY;
	  info: Info;
	BEGIN
	  WHILE iter.next(name, val) DO
	    info := NARROW(val, Info);
	    FOR i := 0 TO oldFinder.extCount-1 DO
	      IF info[i].dir # NIL AND
	          Same(info[i].dir, d) THEN
	        newFinder.add(name, oldFinder.indexToExt[i], d);
		SetProperty(newFinder, name, oldFinder.indexToExt[i],
		    info[i].userData);
              END;
	    END; (* for *)
	  END; (* while *)
	END;
      ELSE
        (* needs scanning *)
        AddOneDir(d, newFinder);
      END;
      dirs := dirs.tail;
    END; (* while *)
  END BuildHashTable;

PROCEDURE <A NAME="AppearsIn"><procedure>AppearsIn</procedure></A>(dirs: M3PathElemList.T; d: Elem): BOOLEAN RAISES {}=
  BEGIN
    WHILE dirs # NIL DO
      IF Same(dirs.head, d) THEN RETURN TRUE END;
      dirs := dirs.tail;
    END; (* while *)
    RETURN FALSE;
  END AppearsIn;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="InitHashTable"><procedure>InitHashTable</procedure></A>(f: Finder) RAISES {} =
  BEGIN
    IF (*Directory.CaseSensitive()*) TRUE THEN
      f.table := NEW(TxtRefTbl.T).init();
    ELSE f.table := NEW(CITxtRefTbl.T).init();
    END;
  END InitHashTable;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="AddOneDir"><procedure>AddOneDir</procedure></A>(d: Elem; f: Finder) RAISES {OSError.E} =
  VAR
    i := M3Directory.NewIter(d.text, f.extSet);
    name: TEXT;
    ext: M3Extension.T;
  BEGIN
    WHILE i.next(name, ext) DO
      f.add(name, ext, d);
    END; (* while *)
    i.close();
  END AddOneDir;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(
    newFinder: Finder;
    exts: M3Extension.TSet;
    dir := &quot;&quot;;
    name := FileName;
    doTransitiveClosure := TRUE;
    oldFinder: Finder := NIL)
    : Finder
    RAISES {OSError.E, Rd.Failure} =
  VAR
    result: Finder;
    extToIndex: ARRAY M3Extension.T OF CARDINAL;
    indexToExt: IndexToExts;
    count: CARDINAL := 0;
  BEGIN
    CountAndExtToIndex(exts, count, extToIndex, indexToExt);

    newFinder.extSet := exts; newFinder.localDir := dir;
    newFinder.extCount := count; newFinder.extToIndex := extToIndex;
    newFinder.indexToExt := indexToExt;

    BuildHashTable(Read(dir, name, doTransitiveClosure),
        oldFinder, newFinder);

    RETURN newFinder;
  END Init;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="CountAndExtToIndex"><procedure>CountAndExtToIndex</procedure></A>(
    exts: M3Extension.TSet;
    VAR count: CARDINAL;
    VAR extToIndex: ARRAY M3Extension.T OF CARDINAL;
    VAR indexToExt: IndexToExts) RAISES {} =
  BEGIN
    count := 0;
    FOR i := FIRST(M3Extension.T) TO LAST(M3Extension.T) DO
      IF i IN exts THEN
        extToIndex[i] := count;
	indexToExt[count] := i;
        INC(count);
      END;
    END;
  END CountAndExtToIndex;

EXCEPTION Fatal;

PROCEDURE <A NAME="Exts"><procedure>Exts</procedure></A>(p: Finder): M3Extension.TSet RAISES {}=
  BEGIN
    RETURN p.extSet;
  END Exts;

PROCEDURE <A NAME="Find"><procedure>Find</procedure></A>(
    m: Finder;
    name: TEXT;
    ext: M3Extension.T)
    : TEXT
    RAISES {M3FindFile.Failed}=
  BEGIN
    RETURN Pathname.Compose(TxtList.List1(DirOf(m, name, ext).text),
                            name, M3Extension.ToText(ext))
  END Find;

PROCEDURE <A NAME="DirOf"><procedure>DirOf</procedure></A>(
    m: Finder;
    name: TEXT;
    ext: M3Extension.T): Elem RAISES {M3FindFile.Failed}=
  VAR
    id: REFANY;
  BEGIN
    IF NOT ext IN m.extSet THEN &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal END; END;
    IF m.table.get(name, id) THEN
      VAR
        p := NARROW(id, Info);
	dir := p[m.extToIndex[ext]].dir;
      BEGIN
        IF dir # NIL THEN RETURN dir END;
      END;
    END; (* if *)
    RAISE M3FindFile.Failed;
  END DirOf;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(
    m: Finder;
    name: TEXT;
    ext: M3Extension.T;
    dir: Elem)
    RAISES {}=
  VAR
    id: REFANY;
    index := m.extToIndex[ext];
    info: Info;
  BEGIN
    IF m.table.get(name, id) THEN
      info := NARROW(id, Info);
      IF info[index].dir # NIL THEN
      	RETURN (* duplicate, later in path, ignored *)
      END; (* if *)
    ELSE
      info := NEW(Info, m.extCount);
      FOR i := 0 TO m.extCount-1 DO
        WITH xinfo = info[i] DO
      	  xinfo.dir := NIL; xinfo.userData := NIL;
        END;
      END; (* for *)
      EVAL m.table.put(name, info);
    END; (* if *)
    info[index].dir := dir;
  END Add;

PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(f: Finder): Iter RAISES {} =
  BEGIN
    RETURN NEW(Iter,
               hashIter := f.table.iterate(),
               f := f);
  END NewIter;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(
    i: Iter;
    VAR (*out*) unitName: TEXT;
    VAR (*out*) ext: M3Extension.T;
    VAR (*out*) dir: Elem)
    : BOOLEAN
    RAISES {} =
  VAR
    si: CARDINAL;
  BEGIN
    LOOP
      IF i.info = NIL THEN
        VAR
          val: REFANY;
        BEGIN
          IF NOT i.hashIter.next(unitName, val) THEN
	    RETURN FALSE;
	  END;
          i.info := NARROW(val, Info);
        END;
      END;
      (* got a unit, iterate the extensions *)
      dir := i.info[i.i].dir; si := i.i;
      INC(i.i);
      IF i.i &gt;= i.f.extCount THEN i.i := 0; i.info := NIL; END;
      IF dir # NIL THEN
	ext := i.f.indexToExt[si];
	RETURN TRUE;
      END;
    END; (* loop *)
  END Next;

PROCEDURE <A NAME="Dirs"><procedure>Dirs</procedure></A>(f: Finder): M3PathElemList.T RAISES {}=
  BEGIN
    RETURN f.allDirs;
  END Dirs;

REVEAL <A NAME="Iter">Iter</A> = IterPublic BRANDED OBJECT
    hashIter: CITxtRefTbl.Iterator;
    f: Finder;
    i: CARDINAL := 0;
    info: Info := NIL;
  OVERRIDES
    next := Next;
    close := Close;
  END;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(&lt;*UNUSED*&gt; iter: Iter)=
  BEGIN
  END Close;

PROCEDURE <A NAME="SetProperty"><procedure>SetProperty</procedure></A>(
    f: Finder;
    unitName: TEXT;
    ext: M3Extension.T;
    value: REFANY)
    RAISES {M3FindFile.Failed}=
  VAR
    id: REFANY;
  BEGIN
    IF NOT ext IN f.extSet THEN &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal END; END;
    IF f.table.get(unitName, id) THEN
      VAR
        p := NARROW(id, Info);
	dir := p[f.extToIndex[ext]].dir;
      BEGIN
        IF dir # NIL THEN
	  p[f.extToIndex[ext]].userData := value;
        END;
      END;
    ELSE RAISE M3FindFile.Failed
    END;
  END SetProperty;

PROCEDURE <A NAME="GetProperty"><procedure>GetProperty</procedure></A>(
    f: Finder;
    unitName: TEXT;
    ext: M3Extension.T)
    : REFANY RAISES {M3FindFile.Failed}=
  VAR
    id: REFANY;
  BEGIN
    IF NOT ext IN f.extSet THEN &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal END; END;
    IF f.table.get(unitName, id) THEN
      VAR
        p := NARROW(id, Info);
	dir := p[f.extToIndex[ext]].dir;
      BEGIN
        IF dir # NIL THEN
	  RETURN p[f.extToIndex[ext]].userData;
        END;
      END;
    ELSE RAISE M3FindFile.Failed
    END;
  END GetProperty;

PROCEDURE <A NAME="OpenRead"><procedure>OpenRead</procedure></A>(f: Finder; name: TEXT; ext: M3Extension.T
      ): Rd.T RAISES {OSError.E, M3FindFile.Failed}=
  BEGIN
    RETURN FileRd.Open(f.find(name, ext));
  END OpenRead;

BEGIN
END M3Path.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
