<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/Common/OLD/M3PathPosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/Common/OLD/M3PathPosix.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>M3PathPosix</module> EXPORTS <implements>M3Path</implements>;

IMPORT <A HREF="../../../../../word/src/Word.i3">Word</A>, <A HREF="../../../../../types/src/Char.i3">Char</A>, <A HREF="../../../../../params/src/Env.i3">Env</A>, <A HREF="../../../../../os/src/Common/File.i3">File</A>, <A HREF="../../../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../M3PathElem.i3">M3PathElem</A>, <A HREF="../M3PathElemList.i3">M3PathElemList</A>,
    <A HREF="../../../../../text/src/Text.i3">Text</A>, <A HREF="../../../misc/TextExtras.i3">TextExtras</A>, TxtList, <A HREF="../../../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../misc/RdExtras.i3">RdExtras</A>, Directory, <A HREF="../../../../../rw/src/Common/FileRd.i3">FileRd</A>;
</PRE> Much more of this portable now and should be moved to M3Path.
   ToDo: Replace FileOp.Same call with os-dependent call 

<P><PRE>VAR
  currentFirst_g := FALSE;
  currentFileInfo_g: REF File.Status;
  explicit_g := FALSE;
  explicitList_g: M3PathElemList.T := NIL;
  defaultList_g: M3PathElemList.T := NIL;

TYPE ReadOnlyState = REF BOOLEAN; (* kept in table *)
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="EnsureCurrentFirst"><procedure>EnsureCurrentFirst</procedure></A>() RAISES {}=
  BEGIN
    currentFirst_g := TRUE;
    (* get info on current dir *)
    IF currentFileInfo_g = NIL THEN
      &lt;*FATAL OSError.E*&gt;
      BEGIN
        currentFileInfo_g := NEW(REF File.Status);
        currentFileInfo_g^ := Directory.Status(Pathname.Dot());
      END;
    END;
  END EnsureCurrentFirst;

PROCEDURE <A NAME="AddDefault"><procedure>AddDefault</procedure></A>(t: TEXT; readOnly := TRUE) RAISES {}=
  BEGIN
    IF t = NIL THEN defaultList_g := NIL
    ELSE AddUniqueName(&quot;&quot;, t, readOnly, FALSE, defaultList_g);
    END;
  END AddDefault;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="AddExplicit"><procedure>AddExplicit</procedure></A>(t: TEXT; readOnly := TRUE) RAISES {}=
  BEGIN
    explicit_g := TRUE;
    IF t = NIL THEN explicitList_g := NIL;
    ELSE
        VAR
          index, sindex: CARDINAL := 0;
          l := Text.Length(t);
          name: TEXT;
          these: TxtList.T := NIL;
        BEGIN
          WHILE index &lt; l DO
            IF NOT TextExtras.FindChar(t, ':', index) THEN
              index := l;
            END; (* if *)
            name := TextExtras.Extract(t, sindex, index);
            these := TxtList.New(head := name, tail := these);
	    sindex := index+1; index := sindex;
          END; (* while *)
	  WHILE these # NIL DO
            AddUniqueName(&quot;&quot;, these.head, readOnly, FALSE, explicitList_g);
	    these := these.tail;
	  END; (* while *)
        END;
    END;
  END AddExplicit;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Append"><procedure>Append</procedure></A>(result: M3PathElemList.T; list: M3PathElemList.T) RAISES {}=
  VAR elem: Elem;
  BEGIN
    IF list # NIL THEN
      WHILE list # NIL DO
        elem := list.head;
        IF CheckUnique(result, elem.text, elem.fileInfo, elem.readOnly) = NIL THEN
          result := M3PathElemList.AppendD(result, M3PathElemList.List1(elem));
        END; (* if *)
        list := list.tail;
      END; (* while *)
    END;
  END Append;

PROCEDURE <A NAME="CheckUnique"><procedure>CheckUnique</procedure></A>(list: M3PathElemList.T; name: TEXT;
                      fileInfo: REF File.Status;
                      readOnly: BOOLEAN): Elem=
</PRE><BLOCKQUOTE><EM> Checks if the file denoted by <CODE>name, fileInfo</CODE> is
   already on <CODE>list</CODE>. If so, returns the <CODE>Elem</CODE>,
   else <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>
  VAR
    elem: Elem;
    id := TableEnter(name, readOnly);
  BEGIN
    WHILE list # NIL DO
      elem := list.head;
      IF PSame(elem, id, fileInfo) THEN
	(* not unique, don't add, but make writable pervasive *)
	IF NOT readOnly AND elem.readOnly THEN
          elem.readOnly := FALSE;
          VAR ros := NEW(ReadOnlyState);
          BEGIN
            ros^ := FALSE;
            EVAL elemTable_g.put(name, ros);
          END;
        END;
        RETURN elem;
      ELSE list := list.tail;
      END;
    END; (* while list *)
    RETURN NIL;
  END CheckUnique;

PROCEDURE <A NAME="CheckROInList"><procedure>CheckROInList</procedure></A>(list: M3PathElemList.T; elem: Elem) RAISES {}=
  VAR dir: Elem;
  BEGIN
    WHILE list # NIL DO
      dir := list.head;
      IF elem = dir THEN RETURN
      ELSIF PSame(dir, elem.id, elem.fileInfo) THEN
        dir.readOnly := elem.readOnly;
      END; (* if *)
      list := list.tail;
    END; (* while *)
  END CheckROInList;

BEGIN
END M3PathPosix.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
