<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/files/POSIX/M3PathElemPosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/files/POSIX/M3PathElemPosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3PathElemPosix</module> EXPORTS <A HREF="../Common/M3PathElemOS.i3"><implements>M3PathElemOS</A></implements>, <A HREF="../Common/M3PathElemOSPriv.i3"><implements>M3PathElemOSPriv</A></implements>;

IMPORT <A HREF="../../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../../params/src/Env.i3">Env</A>, <A HREF="../../../../text/src/Text.i3">Text</A>, <A HREF="../../misc/TextExtras.i3">TextExtras</A>;

REVEAL <A NAME="T">T</A> = BRANDED REF Atom.T;

PROCEDURE <A NAME="Uid"><procedure>Uid</procedure></A>(dir: TEXT): T=
  VAR result := NEW(T);
  BEGIN
    result^ := Atom.FromText(dir);
    RETURN result
  END Uid;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(t1, t2: T): BOOLEAN=
  BEGIN
    RETURN t1^ = t2^;
  END Equal;

PROCEDURE <A NAME="EnvExpand"><procedure>EnvExpand</procedure></A>(e: TEXT): TEXT=
</PRE><BLOCKQUOTE><EM> Expand environment variables in a TEXT.  The environment vars are
 * enclosed $(thusly).  If the surounded text is not an environment var,
 * it expands to the null string.  Unmatched or nested $()'s cause trouble.
 * e.g.  'abc$(TERM)def' -&gt; 'abcsundef'; 'abc$(foo)def' -&gt; 'abcdef';
 * 'abc$(def$(TERM)ghi' -&gt; 'abcghi'; etc.
 </EM></BLOCKQUOTE><PRE>
  VAR
    res: TEXT := &quot;&quot;;
    start, end: CARDINAL := 0;
  BEGIN
    WHILE start &lt; Text.Length(e) DO
      IF TextExtras.FindSub(e, &quot;$(&quot;, start) THEN
        res := res &amp; TextExtras.Extract(e, end, start);
        start := start + 2;
        end := start;
        IF TextExtras.FindChar(e, ')', end) THEN (* found $(xxx) *)
          WITH env = Env.Get(TextExtras.Extract(e, start, end)) DO
            IF env # NIL THEN res := res &amp; env; END;
          END;
          INC(end);
        ELSE (* unmatched $( *)
          res := res &amp; &quot;$(&quot; &amp; TextExtras.Extract(e, start, Text.Length(e));
        END; (* if $(xxx) found *)
        start := end;
      ELSE (* no $( (done, grab rest) *)
        res := res &amp; TextExtras.Extract(e, end, Text.Length(e));
      END; (* if $( found *)
    END; (* while still to expand *)
    RETURN res;
  END EnvExpand;

BEGIN
  SCurrentS := &quot;/./&quot;; SParentS := &quot;/../&quot;; PathSeparator := ':';
  PathnameSeparator := '/';
END M3PathElemPosix.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
