<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The traditional method for specifying the syntax of a programming
language is in some variant of Backus-Naur form, or BNF. In this
method, one specifies the syntax by a grammar consisting of {\it
productions}. Each production defines the syntax of one element of the
language, say, a statement. For example, the Modula-3 <CODE>WHILE</CODE>
statement is defined as follows:
<P>
<PRE>
       WhileSt = WHILE Expr DO S END.
       S = [ Stmt { &quot;;&quot; Stmt } [&quot;;&quot;] ].
       Expr = ... .
</PRE>
Names that appear to the left of the <CODE>=</CODE> sign are called
<CODE>non-terminals</CODE>.  Names, like <CODE>WHILE</CODE>, that only appear on the
right-hand side are called <CODE>terminals</CODE>. A terminal may denote a
language keyword like <CODE>WHILE</CODE> or an entity that is defined elsewhere,
for example a <CODE>TEXT</CODE> literal defined by the Modula-3 token grammar.
<P>
Such grammars define the {\it external} form of programs, which is
biased towards ease of reading by programmers and parsing by
compilers. As a result they tend to obscure the {\it essential}
structure of the language. For example, what is really important about
a <CODE>WHILE</CODE> statement is that it contains an <CODE>Expr</CODE> and an <CODE>S</CODE>
construct; the keywords <CODE>WHILE</CODE>, <CODE>DO</CODE> and <CODE>END</CODE> could be altered
without changing the meaning, as indeed could the order of occurrence
of the constructs. It should be obvious that the details of the
external syntax are of no help in analysing or reasoning on the
essential properties of programs. Therefore, we seek a more abstract
representation of programs that carries only the essential
information.
<P>
We will refer to the syntax of the external form of a language as the
{\it concrete} syntax. If we abstract from the representational
details of the concrete syntax, what we are left with is an {\it
abstract} syntax for the language, defined by an {\it abstract
grammar}.
<P>
Like the grammar for the concrete syntax, the abstract grammar is also
defined in terms of productions, terminals and non-terminals. To
define the abstract grammar we will use a slightly different syntax
for productions, one that is closer to the syntax of aggregate types
(e.g. <CODE>RECORD</CODE>) in programming languages.  This syntax also
facilitates the mapping of the abstract syntax into Modula-3 data
types.
<P>
The abstract grammar defines a finite set of {\it constructs}
using a finite set of {\it productions}, defined according to
the conventions in the Modula-3 report, as follows:
<P>
<PRE>
       Production = Construct &quot;=&quot; Aggregate | Choice .
       Aggregate = { &quot;[&quot; AttributeName &quot;:&quot; AttributeType &quot;;&quot; &quot;]&quot; } .
       Choice = Construct { &quot;|&quot; Construct } .
       AttributeType = Construct | &quot;{&quot; Construct &quot;}&quot; .
</PRE>
A construct that is not defined by a production is a terminal;
otherwise it is a non-terminal. An <CODE>AttributeName</CODE> is a tag that
distinguishes repeated occurrences of the same construct in a
production. By convention <CODE>Choice</CODE> constructs are spelled in
upper-case and <CODE>Aggregate</CODE> constructs begin with an upper-case letter.
<P>
The abstract grammar production for a <CODE>WhileSt</CODE> might be defined as:
<P>
<PRE>
       WhileSt = as_expr: EXPR; as_s: Stmts .
       Stmts = as_stmt_s: { STM } .
       STM = WhileSt | ... .
</PRE>
In the same way that a program defined by the concrete grammar has an
associated representation as a {\it parse tree}, so the equivalent
program defined in terms of the abstract grammar has a representation
as an {\it abstract syntax tree}. The leaves of the tree denote
terminal constructs, the interior nodes represent non-terminal
constructs, and the attribute names label the branches. The above
definition of the abstract grammar permits a node to have either a
fixed number of descendent nodes, a variable number, or a combination
of both.  Some abstract grammar definitions restrict a node to have
either a fixed number of descendents or a variable number but not
both.  However, this requires more constructs in the grammar. Indeed
the <CODE>WhileSt</CODE> production can be rewritten more compactly as follows:
<P>
<PRE>
       WhileSt = as_expr: EXPR; as_stmt_s: { STM } .
       STM = WhileSt | ... .
</PRE>
The acronym <CODE>AST</CODE> is widely used in place of abstract syntax tree. An
AST and its associated parse tree will always be similar in form;
however, the AST will usually contain less nodes, due to the reduction
in the number of constructs.
<P>
It is important to note that when we talk of a {\it tree}, we are
referring to the {\it abstraction} of a tree. It is not implied
that there is an actual data structure containing records and
pointers. Such a structure is only one possible representation,
although a convenient and common choice.
<P>
\subsection{Specifying an AST in Modula-3}
<P>
This section describes in general terms how the definition of a
language in terms of an abstract grammar, and its associated AST, is
mapped into an abstraction using the Modula-3 programming language.
<P>
There is an an obvious mapping from an <CODE>Aggregate</CODE> construct into
either a <CODE>RECORD</CODE> type or an <CODE>OBJECT</CODE> type. We choose the latter
because it supports abstraction better (the representation of
the components can more easily be hidden from a client) and
because the subtyping of <CODE>OBJECT</CODE> types directly supports the
<CODE>Choice</CODE> construct. For example, the production:
<P>
<PRE>
       T = A | B | C.
</PRE>
can be expressed using objects as:
<P>
<PRE>
       TYPE T &lt;: ROOT; A &lt;: T; B &lt;: T; C &lt;: T;
</PRE>
Modula-3 not only supports abstraction directly through interfaces and
opaque object types, it is also augmented with a formal specification
language called Larch/Modula-3, or LM3 for short. Amongst other things
LM3 allows object types to be annotated with <CODE>abstract</CODE> or
<CODE>specification</CODE> fields, thus permitting one to reason about these fields
without having to commit to a representation as an actual object
field. We will use specification fields to denote the attributes of an
aggregate production. LM3 also provides the notion of a {\it sequence}
as a primitive, again allowing the representation to be deferred.  We
will use this facility to denote attributes that represent sequences
of nodes.
<P>
In this formalism, the <CODE>WhileSt</CODE> example would be defined as:
<P>
<PRE>
       TYPE WhileSt &lt;: STM;
       &lt;* FIELDS OF WhileSt
            as_expr: EXPR;
            as_stmt_s: SEQUENCE OF STM; *&gt;
</PRE>
This is a simple, clear and concise notation in which to define an AST
for a given programming language. Furthermore, because it is defined
by a formal language, it offers the prospect of that some components
of a programming environment for the given language could be generated
automatically. For example, code could be generated that will
systematically visit every node in an AST. Note that the <CODE>type</CODE> of an
attribute must either be an object type denoting an abstract grammar
construct, or a sequence of such types. Later we will see how to add
additional attributes that can be any type allowed by the Modula-3
language.
<P>
The <CODE>WhileSt</CODE> node is an example of a situation that occurs frequently
in which all the members of a <CODE>Choice</CODE> construct in the grammar share
a common attribute. In such cases we can simplify the AST
specification by associating the attribute with the class that denotes
the choice.  The different alternatives then inherit the attribute by
the normal rules of object subtyping.
<P>
Ultimately, this abstract definition of an AST node must be given a
concrete representation. There are many possible representation for
such a tree and there are trade-offs to be made between storage
requirements and processing time. It is not the role of this interface
to make those choices, only to provide mechanisms and standards to
support them.
<P>
\subsection{Augmenting an AST}
<P>
There are many reasons why we might want to augment an AST definition
with additional constructs and attributes. The overriding reason is
that the abstract grammar is unable to define all the constraints on a
legal program.  program. Many of the programs that can be generated
from the grammar are in fact illegal. There is no easy way in such a
context free grammar to express the fact that, for example, the type
of the <CODE>EXPR</CODE> construct of the <CODE>WhileSt</CODE> must be <CODE>BOOLEAN</CODE>. Nor that
all identifier uses must be bound to a declaration in scope.  Such
constraints are defined by what is referred to as the <CODE>static
semantics</CODE> of the language, as opposed to the <CODE>dynamic semantics</CODE>
which define the meaning of the program when it is executed.
<P>
So, in order to analyse programs in a useful way we need, at the very
least, some way to represent the results of the static semantic
analysis.  The obvious way to do this is to augment certain nodes in
an AST with additional attributes that specify this information, for
example the type of expressions.  Choosing which nodes to annotate
and precisely what information to represent is a tricky task and
beyond the scope of this discussion. We can observe, however, that the
formalism that we have chosen is quite capable of specifying these
additional attributes, merely by adding them to the <CODE>FIELDS</CODE>
declaration. The result is an AST augmented with the additional
attributes. In truth the term augmented AST is somewhat of a misnomer
since there is nothing to prevent the augmented attributes in several
nodes having as value a reference to the same node, thus forming a
directed graph structure. However, it is conventional to continue to
use the term <CODE>AST</CODE> to refer to the entire structure. Note also that, unlike
the the attributes that denote the {\it pure} abstract syntax tree,
the additional attributes can be of any type that is provided by the
Modula-3 language.
<P>
Finally we can observe that practically all analyses of an AST will
generate additional information that is of potential use by other
tools.  It is generally very much easier to attach this information
directly to the AST than to create a separate data structure.
<P>
\subsection{AST Layers}
<P>
The previous section suggested augmenting the AST with attributes that
capture the result of an analysis by a given tool. In a rich
programming environment, consisting of many tools, many additional
sets of attributes might be defined. If these attributes are all
declared in the same interface, the result will be overwhelming. In
addition, the scope for separate development will be greatly reduced.
Previous AST designs, for example, DIANA, have specified the
attributes for a fixed set of tools, thus placing additional tools at
a disadvantage. One solution is to define a {\it property set}
attribute on each node, that is capable of storing many attributes of
different types, but this has the disadvantages of storage and access
time overheads plus a more complex programming interface.
<P>
The basic idea is to define each set of nodes and attributes independently,
and then define an AST as a combination of some or all of these
sets. We refer to each set as an AST {\em layer} or, occasionally,
a {\em view}. 
<P>
\subsection{AST Layers in Modula-3}
<P>
This section describes how the notion of separate layers of an AST
is mapped into the facilities available in Modula-3. The solution
makes extensive use of {\it interfaces} and {\it partial revelations}. 
<P>
An AST for a specific language is specified as a set of interfaces,
which share the naming convention <CODE>LLAST</CODE>, where <CODE>LL</CODE> is a
language-specific prefix, e.g. <CODE>M3</CODE>, for the Modula-3 AST. Each AST
layer is defined in an interface named <CODE>LLAST_VV</CODE>, where <CODE>VV</CODE> is a tag
denoting the layer, for example, <CODE>AS</CODE> for the syntactic layer. Each
interface defines the attributes available on a given node using the
<CODE>FIELDS OF</CODE> mechanism introduced previously. In order to quickly
relate an attribute to the layer in which is declared, attribute names
are given a prefix of the form <CODE>vv_</CODE>, for example, <CODE>as_exp</CODE>.
<P>
All AST nodes are declared to be subtypes of the <CODE>AST.NODE</CODE> class,
defined by this interface. An implementation of the interface will
define a set of standard methods that support common actions, such as
systematically visiting nodes in the AST.  This interface does not
prescribe a set of methods; this is left to other interfaces.
<P>
Non-terminals that are defined as a set of alternatives using the
<CODE>Choice</CODE> construct in the abstract grammar are named using all upper
case characters. There are never any instances of these nodes in an
AST.
<P>
Sequence attributes are named with a suffix <CODE>_s</CODE>, to distinguish them
from other attributes.
<P>
Because of the prevalence of prefixes and suffixes in attribute names,
the standard Modula-3 capitalisation rules for multiword identifiers
are modified. Instead of <CODE>WhileSt</CODE>, we write <CODE>While_st</CODE>, and an
attribute of such a type in the <CODE>AS</CODE> layer would be named
<CODE>as_while_st</CODE>, rather than <CODE>as_whileSt</CODE>.
<P>
Using these conventions, interfaces are constructed as follows. The 
<CODE>WhileSt</CODE> grammar fragment is used as an example.
<P>
<PRE>
       INTERFACE LLAST_AS;
       IMPORT AST;
       TYPE
         STM &lt;: AST.NODE; EXPR &lt;: AST.NODE;
         WhileSt &lt;: STM;
         &lt;* FIELDS OF WhileSt
              as_expr: EXPR;
              as_stmt_s: SEQUENCE OF STM; *&gt;
      
</PRE>
Now consider a {\em static semantic} layer for the above grammer, in which
all <CODE>EXPR</CODE> nodes are given a <CODE>type</CODE>, denoted by the class <CODE>LTYPE</CODE>.
<P>
<PRE>
       INTERFACE LLAST_SM;
       IMPORT AST, LLAST_AS;
       TYPE
         LTYPE &lt;: AST.NODE;
      
       &lt;* FIELDS OF LLAST_AS.EXPR
            sm_ltype: LTYPE; *&gt;
</PRE>
<P>
\subsubsection{Defining the concrete representation}
<P>
In practice there are two ways in which to represent the abstract
attributes defined in the <CODE>FIELDS</CODE> specifications, either directly as
fields of the object type, or indirectly through methods that set or
get the value. The convention is to reveal these access methods in
interfaces called <CODE>LLAST_VV_F</CODE> and <CODE>LLAST_VV_M</CODE>, respectively. In
either case this interface will contain, for each node to be
attributed, an object type with the same name as the abstract type,
plus a partial revelation that the abstract type is a subtype of this
new object type.
<P>
<P>
<PRE>
       INTERFACE LLAST_AS_F;
       IMPORT AST, LLAST_AS;
       TYPE
         While_st = LLAST_AS.STMT OBJECT
           as_expr: LLAST_AS.EXPR := NIL;
           as_stmt_s := REF ARRAY OF LLAST_AS.STMT := NIL;
         END;
</PRE>
<PRE>
       REVEAL
         LLAST_AS.While_st &lt;: While_st;
</PRE>
<PRE>
       TYPE EXPR = LLAST_AS.EXPR; STMT = LLAST_AS.STMT;
       END LLAST_AS_F.
</PRE>
When the <CODE>LLAST_AS_F</CODE> interface is imported, it allows access to
<CODE>as_expr</CODE> and <CODE>as_stmt_s</CODE>, and the <CODE>REVEAL</CODE> statement tells the
compiler that the actual node will have all of these fields, and
possibly some more. It is conventional to <CODE>pass through</CODE> the node and
class types that are not revealed, for example <CODE>EXPR</CODE> in the above, to
ensure that the next layer can access all the node names by referrring
to this layer alone.
<P>
The static semantic attributes can be given a similar concrete
representation as follows:
<P>
<PRE>
       INTERFACE LLAST_SM_F;
       IMPORT AST, LLAST_AS, LLAST_SM;
       IMPORT LLAST_AS_F AS Previous_View;
</PRE>
<PRE>
       TYPE 
         EXPR = Previous_View.EXPR OBJECT
           sm_ltype: LLAST_SM.LTYPE;
         END;
</PRE>
<PRE>
       REVEAL 
         LLAST_AS.EXPR &lt;: EXPR;
       TYPE
         While_st = Previous_View.While_st;
         STM = Previous_View.STM;
         LTYPE = LLAST_SM.LTYPE;
       END LLAST_SM_F.
</PRE>
Notice that in this layer the supertype is inherited from the previous
view, in this case, <CODE>LLAST_AS_F</CODE>.
<P>
Owing to the constraints of Modula-3 object subtyping, it is necessary
to know the name of the layer that last added attributes to the node.
If you get this wrong you will get an error message complaining about
incompatible revelations at some point. However, whether this occurs
at compile, link, or run-time depends on the Modula-3 implementation.
<P>
Ultimately, there must be an interface or module that chooses which layers
will actually exist in a given program, by making a concrete revelation
containing the corresponding declaration in the lowest layer that
is to be included. This is conventionally named <CODE>LLAST_all</CODE>. E.g.
<P>
<PRE>
       INTERFACE LLAST_all;
       IMPORT LLAST_AS, LLAST_SM;
       IMPORT LLAST_SM_F AS Last_View;
</PRE>
<PRE>
       REVEAL LLAST_AS.STMT = Last_View.STMT BRANDED OBJECT END;
       REVEAL LLAST_AS.EXPR = Last_View.EXPR BRANDED OBJECT END;
       REVEAL LLAST_AS.While_st = Last_View.While_st
                                             BRANDED OBJECT END;
       REVEAL LLAST_SM.LTYPE = Last_View.LTYPE 
                                             BRANDED OBJECT END;
       END LLAST_all;
</PRE>
<P>
At first sight, this may all seem rather complicated.  However,
AST specifications for real languages and tools are inherently complex
and there is much value to be gained in separating the specification
into more manageable pieces. For example, the syntactic, semantic and
code-generator attributes can be specified independently.  To
understand the syntactic specification, there is no need to see or
understand the other two. Secondly, it is possible to replace a layer
without affecting any of its ancestors, or add a completely new layer,
for example to support a new programming environment tool. The key
point to note is that although there may be many layers of a node,
there is only one actual node type. Whenever an instance of a node is
created it has the sum total of all the attributes that were specified
in the contributing layers. So, although a parser might be separately
compiled against the syntactic layer, it need only be relinked to
incorporate a new tool with its own layer. This greatly facilitates
the extensibility of the environment. It is perhaps unfortunate that
Modula-3 does not support multiple inheritance, which would avoid the
nuisance of the layer linearisation.  

<P> \subsection{Basic Definitions} 

<P><PRE>INTERFACE <interface>AST</interface>;

TYPE
  <A HREF="../astall/M3AST_all.i3#NODE">NODE</A> &lt;: ROOT;
  T = NODE;
</PRE> An <CODE>AST.T</CODE> is denoted by the node that defines the root of the tree. 
A particular implementation of this interface will typically define
a standard set of methods on an <CODE>AST.NODE</CODE>. 

<P><PRE>END AST.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
