<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/ASTCopy.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/ASTCopy.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P> <CODE>ASTCopy</CODE> provides a way to copy all or part of an AST. 

<P><PRE>INTERFACE <interface><A HREF="ASTCopy.m3">ASTCopy</A></interface>;

IMPORT <A HREF="AST.i3">AST</A>, <A HREF="ASTWalk.i3">ASTWalk</A>;

TYPE
  <A HREF="ASTCopy.m3#Closure">Closure</A> &lt;: Closure_public;
  Closure_public = OBJECT
  METHODS
    callback(n, ncopy: AST.NODE;
             vm: ASTWalk.VisitMode) RAISES ANY;
    init(): Closure;
  END;

PROCEDURE <A HREF="ASTCopy.m3#Nodes">Nodes</A>(
    n: AST.NODE;
    ): AST.NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Copies the tree rooted at <CODE>n</CODE> and returns the root of the copy. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTCopy.m3#ModeNodes">ModeNodes</A>(
    n: AST.NODE;
    c: Closure;
    vm : ASTWalk.VisitModeControl;
    ): AST.NODE RAISES ANY;
</PRE><BLOCKQUOTE><EM> Similar to <CODE>Nodes</CODE> but supports a per-node callback. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTCopy.m3#IgnoreChildren">IgnoreChildren</A>(c: Closure) RAISES {};
</PRE><BLOCKQUOTE><EM> Suppress the copy of the children of the current node. </EM></BLOCKQUOTE><PRE>

END ASTCopy.
</PRE> The <CODE>ASTCopy</CODE> interface allows an AST to be copied, with provision
for the caller to be called back at each node, using a similar
mechanism to the <CODE>ASTWalk</CODE> interface. The callback can be used to copy
or share additional attributes that are not copied by the underlying
<CODE>copy</CODE> method, for example attributes that cause the AST to form a
graph rather than a tree. 
<P>
The <CODE>Nodes</CODE> procedure provides for a simple copy of the tree rooted at
its argument, <CODE>n</CODE>, without any callbacks.
<P>
The <CODE>ModeNodes</CODE> takes a closure argument that should be created with a
call of <CODE>NEW(Closure, callback := YourCallback).init()</CODE>. The closure can be
subtyped to provide for shared state to be accessed during the
callbacks. The <CODE>vm</CODE> argument can be used to control when the callback
are made in the way described in the <CODE>ASTWalk</CODE> interface. On an
{\em entry} callback to a node, the value of the <CODE>ncopy</CODE> will be <CODE>NIL</CODE>.
On an {\em exit} callback, <CODE>ncopy</CODE> will refer to the newly created copy.
<P>
The <CODE>IgnoreChildren</CODE> procedure can be called to suppress the copying
of a node's children. Once control leaves the node from which the call
was made, the suppression is disabled. It is only effective when
called in {\em entry} mode. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
