<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/ASTCopy.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/ASTCopy.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ASTCopy</module> EXPORTS <A HREF="ASTCopy.i3"><implements>ASTCopy</A></implements>, <A HREF="AST_CopyRep.i3"><implements>AST_CopyRep</A></implements>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="AST.i3">AST</A>;
IMPORT <A HREF="ASTWalk.i3">ASTWalk</A>;

REVEAL
  <A NAME="Handle">Handle</A> = Handle_public BRANDED OBJECT
    ignoreChildren := FALSE;
    callOnEntry: BOOLEAN := FALSE;
    callOnExit: BOOLEAN := FALSE;
    closure: Closure := NIL;
  OVERRIDES
      Copy := DoCopy;
  END;

  <A NAME="Closure">Closure</A> = OBJECT
    METHODS
      callback(n, ncopy: AST.NODE; vm: ASTWalk.VisitMode) RAISES ANY;
      init(): Closure;
    END
    BRANDED OBJECT
      handle: Handle := NIL;
    OVERRIDES
      init := Init;
  END;

PROCEDURE <A NAME="Nodes"><procedure>Nodes</procedure></A>(
    n: AST.NODE;
    ): AST.NODE RAISES {}=
  BEGIN
    RETURN DoNodes(NEW(Handle), n);
  END Nodes;

PROCEDURE <A NAME="ModeNodes"><procedure>ModeNodes</procedure></A>(
    n: AST.NODE;
    c: Closure;
    vm : ASTWalk.VisitModeControl;
    ): AST.NODE=
  VAR
    handle := NEW(Handle);
  BEGIN
    c.handle := handle;
    handle.closure := c;
    handle.callOnEntry := ASTWalk.VisitMode.Entry IN vm;
    handle.callOnExit := ASTWalk.VisitMode.Exit IN vm;
    RETURN DoNodes(handle, n);
  END ModeNodes;

PROCEDURE <A NAME="DoNodes"><procedure>DoNodes</procedure></A>(handle: Handle; n: AST.NODE): AST.NODE=
  BEGIN
    IF n = NIL THEN RETURN NIL END;
    RETURN DoCopy(handle, n);
  END DoNodes;

PROCEDURE <A NAME="DoCopy"><procedure>DoCopy</procedure></A>(handle: Handle; n: AST.NODE): AST.NODE=
  &lt;*FATAL ANY*&gt;
  VAR
    cn: AST.NODE := NIL;
  BEGIN
    IF handle.callOnEntry THEN
      handle.closure.callback(n, cn, ASTWalk.VisitMode.Entry);
    END;
    IF NOT handle.ignoreChildren THEN
      cn := n.copy(handle)
    END;
    IF handle.callOnExit THEN
      handle.closure.callback(n, cn, ASTWalk.VisitMode.Exit);
    END;
    RETURN cn;
  END DoCopy;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="IgnoreChildren"><procedure>IgnoreChildren</procedure></A>(c: Closure) RAISES {} =
  BEGIN
    c.handle.ignoreChildren := TRUE;
  END IgnoreChildren;

PROCEDURE <A NAME="Null"><procedure>Null</procedure></A>(&lt;*UNUSED*&gt; n: NODE; &lt;*UNUSED*&gt;handle: Handle): AST.NODE RAISES {}=
  BEGIN
    RETURN NIL;
  END Null;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(c: Closure): Closure RAISES {}=
  BEGIN
    RETURN c;
  END Init;

BEGIN

END ASTCopy.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
