<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/ASTWalk.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/ASTWalk.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>INTERFACE <interface><A HREF="ASTWalk.m3">ASTWalk</A></interface>;
</PRE> <CODE>ASTWalk</CODE> provides a way of systematically visiting every node in an AST. 

<P><PRE>IMPORT <A HREF="AST.i3">AST</A>;

EXCEPTION Aborted;

TYPE
  VisitMode = {Entry, Exit};
  VisitModeControl = SET OF VisitMode;

  <A HREF="ASTWalk.m3#Closure">Closure</A> &lt;: Closure_public;
  Closure_public = OBJECT
  METHODS
    callback(n: AST.NODE; vm := VisitMode.Entry) RAISES ANY;
    init(): Closure;
  END;

  NodeCallbackProc = PROCEDURE(n: AST.NODE) RAISES ANY;

CONST
  OnEntry = VisitModeControl{VisitMode.Entry};
  OnExit = VisitModeControl{VisitMode.Exit};
  OnEntryAndExit = VisitModeControl{VisitMode.Entry,
                                    VisitMode.Exit};

PROCEDURE <A HREF="ASTWalk.m3#VisitNodes">VisitNodes</A>(n: AST.NODE; vc: Closure) RAISES ANY;
</PRE><BLOCKQUOTE><EM> Walk tree <CODE>n</CODE>, applying <CODE>vc.callback(n, VisitMode.Entry)</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTWalk.m3#ModeVisitNodes">ModeVisitNodes</A>(n: AST.NODE; vc: Closure;
    vm: VisitModeControl) RAISES ANY;
</PRE><BLOCKQUOTE><EM> Similar to <CODE>VisitNodes</CODE>, but apply the callback on entry, exit or both. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTWalk.m3#IgnoreChildren">IgnoreChildren</A>(vc: Closure);
</PRE><BLOCKQUOTE><EM> Suppress the visit of the children of the current node. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTWalk.m3#Abort">Abort</A>() RAISES {Aborted};
</PRE><BLOCKQUOTE><EM> Abort current walk by raising the <CODE>Aborted</CODE> exception. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ASTWalk.m3#NodeProcClosure">NodeProcClosure</A>(p: NodeCallbackProc): Closure;

END ASTWalk.
</PRE> The <CODE>ASTWalk</CODE> interface provides a way to visit every node in an
AST, applying a user-supplied method at each node.  This process is
often referred to a {\em tree walk} or an {\em AST walk}.
<P>
The children of a node of some type <CODE>T</CODE> are visited in the order
defined by the implementation of the <CODE>walk</CODE> method for <CODE>T</CODE>. Typically
this is defined to be the {\em natural} order, that is, corresponding
to reading the program text.
<P>
The caller can choose whether the callback method is applied on entry
to the node, on exit from the node, or both.  A walk may be aborted at
any time.  All the state associated with a walk is captured in the
<CODE>Closure</CODE> argument. So walks may be nested or performed in parallel,
using different closure arguments. The caller should subtype the
<CODE>Closure</CODE> type in order to support argument passing or the return of
results from the callback method. The closure should be created
by a call of the form <CODE>NEW(Closure, callback := YourCallback).init()</CODE>.
<P>
The callback may raise any exception, including <CODE>Aborted</CODE>. The latter
is caught by <CODE>VisitNodes</CODE> and <CODE>ModeVisitNodes</CODE>, and aborts the
walk, returning control to the caller. Any other exception
also aborts the walk and is propagated to the caller.
<P>
The <CODE>VisitNodes</CODE> procedure supports the most common type of walk,
which is to vis to apply the callback method on {\em entry} to the
node, that is before the children are visited (pre-order).
<P>
<CODE>ModeVisitNodes</CODE> takes a <CODE>VisitModeControl</CODE> argument that allows
the callback method to be applied on entry, exit or both. The
<CODE>OnExit</CODE> value can be used to perform a post-order walk, that is,
applying the method after all the children have been visited.
<P>
It is sometimes convenient to suppress the visit of the children of a
given node, and this can be achieved by calling <CODE>IgnoreChildren</CODE> from
the callback method. Once control leaves the node from which the call
was made, the suppression is disabled. A typical use is to mix
pre-order and post-order walks by, say, starting a pre-order walk,
calling <CODE>IgnoreChildren</CODE> at some node and from the callback begin a
post-order walk of the children.  
<P>
The <CODE>NodeProcClosure</CODE> provides a simple way to create a closure
value for a callback method that neither requires any state nor
cares about the <CODE>VisitMode</CODE> argument. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
