<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/ASTWalk.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/ASTWalk.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ASTWalk</module> EXPORTS <A HREF="ASTWalk.i3"><implements>ASTWalk</A></implements>, <A HREF="AST_WalkRep.i3"><implements>AST_WalkRep</A></implements>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="AST.i3">AST</A>;

REVEAL
  <A NAME="Handle">Handle</A> = Handle_public BRANDED OBJECT
    ignoreChildren: BOOLEAN := FALSE;
    callOnEntry, callOnExit: BOOLEAN := TRUE;
    closure: Closure;
  OVERRIDES
      Visit := DoVisit;
  END;

REVEAL
  <A NAME="Closure">Closure</A> = Closure_public BRANDED OBJECT
      handle: Handle := NIL;
  OVERRIDES
      init := Init;
  END;

PROCEDURE <A NAME="VisitNodes"><procedure>VisitNodes</procedure></A>(n: AST.NODE; closure: Closure) RAISES ANY=
  VAR
    handle := NEW(Handle, callOnExit := FALSE);
  BEGIN
    closure.handle := handle;
    handle.closure := closure;
    TRY
      DoVisit(handle, n);
    EXCEPT
      Aborted =&gt;
    END;
  END VisitNodes;

PROCEDURE <A NAME="ModeVisitNodes"><procedure>ModeVisitNodes</procedure></A>(n: AST.NODE; closure: Closure;
    vm: VisitModeControl) RAISES ANY=
  VAR
    handle := NEW(Handle);
  BEGIN
    handle.callOnEntry := VisitMode.Entry IN vm;
    handle.callOnExit := VisitMode.Exit IN vm;
    closure.handle := handle;
    handle.closure := closure;
    TRY
      DoVisit(handle, n);
    EXCEPT
      Aborted =&gt;
    END;
  END ModeVisitNodes;

PROCEDURE <A NAME="DoVisit"><procedure>DoVisit</procedure></A>(handle: Handle; n: AST.NODE) RAISES ANY =
  BEGIN
    IF handle.callOnEntry THEN handle.closure.callback(n) END;
    IF NOT handle.ignoreChildren THEN n.walk(handle) END;
    IF handle.callOnExit THEN handle.closure.callback(n, VisitMode.Exit) END;
    handle.ignoreChildren := FALSE;
  END DoVisit;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(c: Closure): Closure RAISES {}=
  BEGIN
    RETURN c;
  END Init;

TYPE
  NPClosure =
    Closure OBJECT
      np: NodeCallbackProc;
    OVERRIDES
      callback := CallNodeProc;
    END;

PROCEDURE <A NAME="CallNodeProc"><procedure>CallNodeProc</procedure></A>(c: NPClosure; n: AST.NODE;
                       &lt;*UNUSED*&gt; vm: VisitMode) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    c.np(n);
  END CallNodeProc;

PROCEDURE <A NAME="NodeProcClosure"><procedure>NodeProcClosure</procedure></A>(p: NodeCallbackProc): Closure RAISES {}=
  BEGIN
    RETURN NEW(NPClosure, np := p);
  END NodeProcClosure;

PROCEDURE <A NAME="IgnoreChildren"><procedure>IgnoreChildren</procedure></A>(cl: Closure) RAISES {} =
  BEGIN
    cl.handle.ignoreChildren := TRUE;
  END IgnoreChildren;

PROCEDURE <A NAME="Abort"><procedure>Abort</procedure></A>() RAISES {Aborted} =
  BEGIN
    RAISE Aborted;
  END Abort;

PROCEDURE <A NAME="Null"><procedure>Null</procedure></A>(&lt;*UNUSED*&gt; n: NODE; &lt;*UNUSED*&gt; handle: Handle) RAISES {}=
  BEGIN
  END Null;

BEGIN
END ASTWalk.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
