<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST_CopyRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST_CopyRep.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="ASTCopy.m3">AST_CopyRep</A></interface>;
</PRE> This is not intended as a client interface, but as support for the
implementation of a tree copy interface. <CODE>ASTCopy</CODE> is one such
interface.  All AST nodes must provide an implementation of the <CODE>copy</CODE>
method.  

<P><PRE>IMPORT <A HREF="AST.i3">AST</A>, <A HREF="AST_WalkRep.i3">AST_WalkRep</A>;

TYPE
  NODE = AST_WalkRep.NODE OBJECT
    METHODS
      copy(handle: Handle): AST.NODE RAISES ANY := Null;
    END;

REVEAL AST.NODE &lt;: NODE;

TYPE
  <A HREF="ASTCopy.m3#Handle">Handle</A> &lt;: Handle_public;
  Handle_public = OBJECT
    METHODS
      Copy(n: AST.NODE): AST.NODE RAISES ANY;
  END;

PROCEDURE <A HREF="ASTCopy.m3#Null">Null</A>(n: NODE; handle: Handle): AST.NODE RAISES {};
</PRE><BLOCKQUOTE><EM> returns <CODE>NIL</CODE>; used as the default method </EM></BLOCKQUOTE><PRE>

END AST_CopyRep.
</PRE> The <CODE>copy</CODE> method returns a copy of some part of the tree rooted at
the node making the call. At this level of abstraction <CODE>copy</CODE> is very
loosely defined. Precisely which attributes are copied, and whether
attributes are {\em shallow-copied} or {\em deep-copied} is left to
specific AST interfaces to define.
<P>
To aid in the creation of flexible copying interfaces, the <CODE>copy</CODE>
method takes a <CODE>Handle</CODE> argument, in a similar style to the <CODE>walk</CODE>
method defined in <CODE>AST_WalkRep</CODE>. Each implementation of the <CODE>copy</CODE>
method should create a new instance of itself and then apply
<CODE>handle.Copy</CODE> to each of its children in turn, children, assigning the
results to the corresponding child attributes of the new instance. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
