<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST_Init.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST_Init.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>AST_Init</CODE> supports the dynamic initialisation of an AST node. 

<P><PRE>INTERFACE <interface><A HREF="AST_Init.m3">AST_Init</A></interface>;

IMPORT <A HREF="AST.i3">AST</A>;

TYPE
  NODE = OBJECT
    METHODS
      init(): AST.NODE := Null;
  END;

REVEAL
  AST.NODE &lt;: NODE;

PROCEDURE <A HREF="AST_Init.m3#Null">Null</A>(n: NODE): AST.NODE;
</PRE><BLOCKQUOTE><EM> Has no side effects and returns <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>

END AST_Init.
</PRE> Occasionally a particular type of AST node requires dynamic
initialisation, and this can be achieved overriding the <CODE>init</CODE> method
defined here. The default value is simply a no-op.  Therefore the
conventional way to create an instance of an AST node, <CODE>SomeNode</CODE>, is
<CODE>NEW(SomeNode).init()</CODE>. Note that, since this <CODE>init</CODE> method returns
the type <CODE>AST.NODE</CODE> rather than <CODE>SomeNode</CODE>, the layer in which the
latter is defined might choose to redefine the <CODE>init</CODE> method to return
<CODE>SomeNode</CODE>, thus allowing declarations of the form:
<P>
<PRE>
      VAR n := NEW(SomeNode).init();


<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
