<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST_Iter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST_Iter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>AST_Iter</CODE> provides an another way to systematically visit
the nodes of an AST. 

<P><PRE>INTERFACE <interface><A HREF="AST_Iter.m3">AST_Iter</A></interface>;

IMPORT <A HREF="AST.i3">AST</A>;
IMPORT <A HREF="AST_Name.i3">AST_Name</A> AS Previous_View;

TYPE
  NODE = Previous_View.NODE OBJECT
    METHODS
      newIter(): T := Null;
  END;

REVEAL AST.NODE &lt;: NODE;

TYPE
  T &lt;: T_public;
  T_public = OBJECT
  METHODS
    next(VAR (*out*) n: AST.NODE): BOOLEAN RAISES {};

    update(nn: AST.NODE);
    (* If &quot;SELF.next(r)&quot; would return &quot;TRUE&quot;, replace the child
        with &quot;nn&quot;, else a checked
       run-time error. No actual call of &quot;next&quot; takes place. *)
  END;

PROCEDURE <A HREF="AST_Iter.m3#Null">Null</A>(n: NODE): T RAISES {};
</PRE><BLOCKQUOTE><EM> Returns an iterator that always returns <CODE>FALSE</CODE> on a call of <CODE>next</CODE>. </EM></BLOCKQUOTE><PRE>

END AST_Iter.
</PRE> The <CODE>newIter</CODE> method returns an iterator that will return the
children of the node in some order.  A default procedure that returns
none of the children is provided for <CODE>newIter</CODE>. The designer of a
given AST is responsible for providing a specific procedure for each
subtype of an <CODE>AST.NODE</CODE>. The order in which the children are returned
will be the same as that provided by the <CODE>walk</CODE> method described in
the preceding section.
<P>
The <CODE>next</CODE> method return <CODE>FALSE</CODE> if there are no more children of this
node else it sets <CODE>n</CODE> to the next child, steps the iterator, and
returns <CODE>TRUE</CODE>.
<P>
If a call of <CODE>self.next(r)</CODE> would return <CODE>TRUE</CODE>, a call of
<CODE>self.update(nn)</CODE> will replace the child ((which currently has value
<CODE>r</CODE>) with the value <CODE>nn</CODE>, otherwise a checked runtime error will
occur. 

<P> \subsubsection{Example} 

<P> Using the iterator is straightforward and most procedures that
   visit nodes in a tree will take the following form:
<P>
<PRE>
      PROCEDURE Visit(n: AST.NODE)=
        BEGIN
          (* Processing based on &quot;n&quot;. 

<PRE>|     (* Now visit the children of this node. *)
|     VAR iter := n.newIter(n); child: AST.NODE;
|     BEGIN
|       WHILE iter.next(child) DO
|         IF child # NIL THEN Visit(child) END;
|       END;
|     END;
|  END Visit;

   Using the &quot;update&quot; method is more subtle. First note that updating
a direct or indirect child of a node &quot;n&quot; does not require &quot;update&quot;,
but typically can be accomplished by direct assignment, e.g.
&quot;n.child.attribute := value&quot;.  The &quot;update&quot; method is needed when you
want to update a node of your parent and there is no way to know
statically which attribute to modify. For example, you might want to
replace all nodes of type &quot;X&quot; with nodes of type &quot;Y&quot;, assuming that &quot;Y
&lt;: X&quot;, and &quot;X&quot; nodes occur in many different contexts. In this case
the notion you need is update the &quot;ith&quot; child of node &quot;n&quot;.  This is
essentially what &quot;update&quot; does, using the fact that the iterator
provides an abstraction for the location of an attribute.  One
consequence of this generality is the lack of compile-time type
checking on the &quot;update&quot; operation.  If an inappropriate value is
supplied for the attribute at the index encoded by the iterator, the
program will cause a checked run-time error (&quot;NARROW&quot; fault).

The following variant of &quot;Visit&quot; passes a reference, using an
iterator, to the location of node &quot;n&quot; in it's parent node. This allows
the processing code to replace the value of &quot;n&quot; in the parent with a
new value.

| PROCEDURE Visit(n: AST.NODE; n_loc: AST_Iter.T)=
|   BEGIN
|     (* processing that leads to an update *)
|     n_loc.update(new_value)
|
|     VAR iter, iter_me := n.newIter(n);
|         child: AST.NODE;
|     BEGIN
|       WHILE iter.next(child) DO
|         IF child # NIL THEN Visit(child, iter_me) END;
|         EVAL iter_me.next(child);
|       END;
|     END;
|  END Visit;
*)
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
