<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST_Name.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST_Name.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>AST_Name</CODE> defines a method that returns a print-name for an AST node. 
<PRE>INTERFACE <interface><A HREF="AST_Name.m3">AST_Name</A></interface>;

IMPORT <A HREF="AST.i3">AST</A>;
IMPORT <A HREF="AST_Init.i3">AST_Init</A> AS Previous_View;

TYPE
  NODE = Previous_View.NODE OBJECT
    METHODS
      name(): TEXT RAISES {} := Null;
  END;

REVEAL
  AST.NODE &lt;: NODE;

PROCEDURE <A HREF="AST_Name.m3#Null">Null</A>(n: NODE): TEXT RAISES {};
</PRE><BLOCKQUOTE><EM> Returns a text for a node without a specific <CODE>name</CODE> method,
   of the form:
<PRE>
       &quot;no name for node with typecode &quot; &amp; 
            Fmt.Int(TYPECODE(n)) 
</EM></BLOCKQUOTE><PRE>

END AST_Name.
</PRE> It is occasionally useful to have access to a name for an AST node,
in the form of a <CODE>TEXT</CODE>. This view provides such a method, with a
suitable default. 

<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
