<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/AST_WalkRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/AST_WalkRep.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>INTERFACE <interface><A HREF="ASTWalk.m3">AST_WalkRep</A></interface>;

IMPORT <A HREF="AST.i3">AST</A>;
IMPORT <A HREF="AST_Iter.i3">AST_Iter</A> AS Previous_View;
</PRE> This is not intended as a client interface, but as support for the
implementation of various tree walk models. The <CODE>ASTWalk</CODE> interface
provides one such model. All AST nodes, other than leaf nodes, must
provide an implementation of the <CODE>walk</CODE> method.  

<P><PRE>TYPE NODE = Previous_View.NODE OBJECT
  METHODS
    walk(handle: Handle) RAISES ANY := Null;
  END;

REVEAL AST.NODE &lt;: NODE;

TYPE
  <A HREF="ASTWalk.m3#Handle">Handle</A> &lt;: Handle_public;
  Handle_public = OBJECT
    METHODS
      Visit(n: AST.NODE) RAISES ANY;
  END;

PROCEDURE <A HREF="ASTWalk.m3#Null">Null</A>(n: NODE; handle: Handle) RAISES {};
</PRE><BLOCKQUOTE><EM> returns immediately; used as default method </EM></BLOCKQUOTE><PRE>

END AST_WalkRep.
</PRE> The <CODE>walk</CODE> method visits the children of <CODE>self</CODE>, in some order
determined by the concrete method. The connection to the <CODE>callback</CODE>
interface provided by <CODE>ASTWalk</CODE> is through <CODE>handle</CODE>, which provides
the <CODE>Visit</CODE> method. Each implementation of the <CODE>walk</CODE> method should
apply <CODE>Visit</CODE> to its children. The <CODE>Visit</CODE> method encapsulates the
callback and the application of <CODE>walk</CODE> to the child nodes. 
<P>
Since the connection to <CODE>ASTWalk</CODE> is decoupled by the <CODE>handle</CODE> type,
it is possible to devise alternate implementations of the <CODE>Visit</CODE>
method without altering this interface or the implementations of
the <CODE>walk</CODE> methods. 

</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
