<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/gast/LM3/AST_Iter_LM3.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/gast/LM3/AST_Iter_LM3.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>AST_LM3</interface>;

IMPORT <A HREF="../AST.i3">AST</A>, <A HREF="../AST_Iter.i3">AST_Iter</A>;
</PRE> \subsection{Larch/Modula-3 Formal Specification} 

<P> The iterator is modelled as an object that contains a sequence of
nodes, <CODE>children_s</CODE>, derived from the <CODE>children</CODE> set of the node to be
iterated.  Which nodes are chosen and in what order they appear in the
sequence is not specified at this level. The choice is modelled by the
<CODE>choose</CODE> operator defined in the trait <CODE>SetToSeq</CODE>.  A particular AST
specification will provide a definition of this function either
explicitly or implicitly.  In order to model the <CODE>update</CODE> operation
the iterator records those members of the sequence that have been
returned so far.  

<P><PRE>&lt;*
  TRAITS
    SetToSeq(NODE_SET FOR SetC, NODE_SEQUENCE FOR SeqC)
    (* introduces choose: NODE_SET -&gt; NODE_SEQUENCE *)

  TYPE NODE_SEQUENCE = SEQUENCE OF AST.NODE;
  TYPE NODE_SET = ASET OF AST.NODE;

  FIELDS OF T
    node: AST.NODE;
    seen: NODE_SEQUENCE;
    children_s: NODE_SEQUENCE;

  FIELDS OF AST.NODE
    modified: BOOLEAN;

  METHOD AST.NODE.newIter
    ENSURES (RESULT # NIL) \and (RESULT.node = SELF) \and
            (RESULT.children_s = choose(SELF.children)) \and
            (RESULT.seen = empty) \and (SELF.modified = FALSE)

  METHOD T.next(n)
    REQUIRES SELF.node.modified = FALSE
    MODIFIES n
    ENSURES
      IF isEmpty(SELF.children_s) THEN (RESULT = FALSE) \and UNCHANGED(n)
      ELSE (SELF.children_s' = tail(SELF.children_s)) \and
           (n' = head(SELF.children_s)) \and
           (SELF.seen' = SELF.seen \postcat n')

  METHOD T.update(nn)
    MODIFIES SELF.node.children
    ENSURES
      SELF.node.children' = join((iter.seen \postcat nn), tail(iter.children))
    EXCEPT
    | isEmpty(iter.children_s) =&gt; RAISEVAL = CHECKEDRTE

  PROCEDURE Null(n)
    ENSURES RESULT.children_s = empty

*&gt;

END AST_LM3.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
