<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/Args.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/Args.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>INTERFACE <interface><A HREF="Args.m3">Args</A></interface>;
</PRE> The following describes the argument decoding provided by this interface.
<P>
  Arguments are decoded according to a template. A template is an ordered
sequence of keys, specified by the user. Argument decoding binds argument
values to keys. After decoding the user can discover the values bound to keys
via enquiry functions.
<P>
  A template is created by handing a template text to the procedure
'NewTemplate'. A template text contains a number of key descriptions, separated
by spaces. Here are some example key descriptions:
<P>
1)  <CODE>duo=d/2</CODE>
2)  <CODE>trio=t/03/p</CODE>
3)  <CODE>needed=necessary=n/4/r/p</CODE>
4)  <CODE>zero=z/0</CODE>
5)  <CODE>normal</CODE>
6)  <CODE>include=i/l/x</CODE>
<P>
  The first section of a description, everything preceding the '/' character,
is a list of alternative names for the key. These names are separated by the
'=' character. So example 1 has two alternative names: <CODE>duo</CODE> and <CODE>d</CODE>. Names
are alphanumeric and must start with a letter.
  The alternative names are optionally followed by three items separated by the
'/'. These are:
<P>
A) The quota. Argument decoding will bind values to keys. These values can be
thought of as arrays of texts. The quota specifies the length of the array
which will be bound to the key.
  If the quota is a number starting with 0 the quota is an upper bound on the
length of the array;  otherwise the quota gives the exact length. There are
three special cases:
a) an omitted quota (as in example 5) is equivalent to the quota <CODE>/1</CODE> i.e. a
quota of exactly one argument.
b) the quota string <CODE>/f</CODE> or <CODE>/flag</CODE> is equivalent to <CODE>/0</CODE>
c) the quota string <CODE>/l</CODE> or <CODE>/list</CODE> is equivalent to <CODE>/0n</CODE> where n is the
largest possible cardinal. This results in a key to which can be bound a value
array of any length.
  Note that a quota of zero is a reasonable thing to have. Because values are
arrays there is a difference between a key being left unbound and a key being
bound to an array of length 0.
<P>
B) The <CODE>required</CODE> flag. If a key description contains <CODE>/r</CODE> or <CODE>/required</CODE> it
indicates that a successful argument decode must bind a value to that key. For
example suppose a template contained the keys described in examples 1 and 3
i.e. <CODE>duo</CODE> and <CODE>needed</CODE>. To successfully decode arguments according to that
template a value array of length 4 MUST be bound to the key called <CODE>needed</CODE>.
This contrasts with <CODE>duo</CODE>; after a successful decoding an array of length 2
may be bound to <CODE>duo</CODE> OR <CODE>duo</CODE> could be left unbound.
<P>
C) The <CODE>positional</CODE> flag. If a key description contains <CODE>/p</CODE> or <CODE>/positional</CODE>
it indicates that a value can be bound to the key positionally or by keyword.
Keys without the <CODE>positional</CODE> flag can only be bound by keyword. The difference
between keyword and positional binding is explained later in this interface.
<P>
D) The <CODE>prefix</CODE> flag. If a key description contains <CODE>/x</CODE> it indicates that
all instances of keywords starting with this prefix will be treated as
values to be associated with the keyword.
<P>
  Arguments are represented by arrays of texts. The decoding process recognizes
three classes of argument texts:
a) NIL. NIL argument texts act as spacers but are otherwise ignored.
b) Keywords. An argument text which starts with the character '-' and is
followed by one letter and then a number (possibly zero) of alphanumerics is
considered to be a keyword.
c) Simple values. All non NIL argument texts which are not keywords are simple
values.
<P>
  Argument decoding takes simple argument values, puts them into arrays and
binds the arrays to keys. NIL and keyword argument texts provide information
but are not bound to keys. Binding is done in two ways:
<P>
A) Keyword binding. A keyword is just a name prefixed by '-'. If the name
matches a key name then any simple values immediately following the keyword
are bound to the named key. For example take the argument list
  {<CODE>-duo</CODE>, <CODE>a</CODE>, <CODE>b</CODE>, <CODE>-zero</CODE>, <CODE>-t</CODE>, <CODE>c</CODE>, <CODE>d</CODE>, <CODE>e</CODE> -Idir1 -Idir2}
and a template built from the template string
  <CODE>duo=d/2 trio=t/03/p zero=z/0 normal include=i/l/x</CODE>
The result of doing keyword binding is
   Key         Binding
  duo         {<CODE>a</CODE>, <CODE>b</CODE>}
  trio        {<CODE>c</CODE>, <CODE>d</CODE>, <CODE>e</CODE>}
  zero        {}
  normal      no binding
  include     {<CODE>dir1</CODE>, <CODE>dir2</CODE>}
<P>
It is an error if an argument array contains more than one keyword which
matches a single key. Keyword matching is case insensitive.
  Note that the special treatement of keywords makes it impossible to specify
simple values which look like keywords. To avoid this problem any non NIL
argument value which starts with '--' has its initial '-' lopped off. So
<CODE>-t</CODE> is a keyword. <CODE>--t</CODE> is the simple value <CODE>-t</CODE>. Both <CODE>-3</CODE> and <CODE>--3</CODE> are
equivalent simple values (<CODE>-3</CODE> does not look like a keyword because the first
character after the '-' is a digit).
<P>
B) Positional binding. Positional binding takes place after keyword binding.
As described earlier only keys with the <CODE>positional</CODE> flag are bound
positionally; these keys are ordered according to their position in the
original template text. The positional keys are taken in that order and any
values left in the argument array are bound to them until:
a) there are no more values
b) the next positional key is already bound
For example take a template text containing the example key descriptions i.e.
  <CODE>duo=d/2 trio=t/03/p needed=necessary=n/4/r/p normal zero=z/0</CODE>
and the argument list
  {<CODE>a</CODE>, <CODE>b</CODE>, <CODE>c</CODE>, <CODE>d</CODE>, <CODE>e</CODE>, <CODE>f</CODE>, <CODE>g</CODE>}
Positional binding would result in the following:
   Key         Binding
  duo         no binding
  trio        {<CODE>a</CODE>, <CODE>b</CODE>, <CODE>c</CODE>}
  needed      {<CODE>d</CODE>, <CODE>e</CODE>, <CODE>f</CODE>, <CODE>g</CODE>}
  zero        no binding
  normal      no binding
Note that binding is done greedily; <CODE>trio</CODE> gets 3 simple values even though it
would be possible to give it less because it does not have an exact quota.
<P>
  This has been an overview of argument decoding. See the comments later in
this interface for more details. 

<P> Operations on argument arrays 

<P><PRE>TYPE
  T = ARRAY OF TEXT;
</PRE><BLOCKQUOTE><EM> Arguments are represented by arrays of texts </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="Args.m3#Copy">Copy</A>(READONLY args: T): REF T RAISES {};
</PRE><BLOCKQUOTE><EM> Creates a new array on the heap, copies 'args' into it and returns a
reference to the new array </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="Args.m3#Concatenate">Concatenate</A>(READONLY args1, args2: T): REF T RAISES {};
</PRE><BLOCKQUOTE><EM> Creates a new array on the heap which is a concatenation of 'args1' and
'args2'. Returns a reference to the new array </EM></BLOCKQUOTE><PRE>
</PRE> Template creation 

<P><PRE>TYPE
  <A HREF="Args.m3#Template">Template</A> &lt;: REFANY;

EXCEPTION
  BadTemplate;

PROCEDURE <A HREF="Args.m3#NewTemplate">NewTemplate</A>(t: TEXT): Template RAISES {BadTemplate};
</PRE><BLOCKQUOTE><EM> 'NewTemplate' constructs and returns a template corresponding to the
template description text 't'.
<P>
  A template description is a series of key descriptions separated by spaces.
Leading and trailing spaces in a template description are ignored. A key
description has the syntax:
<P>
  key description ::= name{=name}{/item}
  item ::= quota | required | positional | prefix
  quota ::= number | <CODE>f</CODE> | <CODE>flag</CODE> | <CODE>l</CODE> | <CODE>list</CODE>
  required ::= <CODE>r</CODE> | <CODE>required</CODE>
  positional ::= <CODE>p</CODE> | <CODE>positional</CODE>
  prefix ::= <CODE>x</CODE> | <CODE>prefix</CODE>
<P>
  A name is a series of alphanumeric characters; it must be non null and must
start with an alphabetic character.
<P>
  A quota number is a decimal number. If the number starts with '0' the quota
is inexact - a value array of up to 'number' in length can be bound to the key.
If the number does not start with '0' the quota is exact; a value array of
exactly 'number' in length is the only acceptable binding for the key.
  The special quotas <CODE>f</CODE> and <CODE>flag</CODE> are equivalent to <CODE>0</CODE>. The special quotas
<CODE>l</CODE> and <CODE>list</CODE> are equivalent to <CODE>0n</CODE> where n is the largest possible cardinal.
  It is legal, though pointless, to have many quota items in a key description.
All but the last one are ignored.
<P>
  The required flag (i.e <CODE>r</CODE> or <CODE>required</CODE>) indicates that argument decoding
must bind an appropriate value to the key to be successful.
  It is legal, though pointless, to specify the required flag more than once.
It is legal, but stupid, to specify the required flag for a key with quota <CODE>0</CODE>.
<P>
  The positional flag (i.e. <CODE>p</CODE> or <CODE>positional</CODE>) indicates that the key can be
bound positionally. It is legal, but stupid, to specify the positional flag for
a key with quota <CODE>0</CODE>.
<P>
  The prefix flag (i.e. <CODE>x</CODE>) indicates that all keywords beginning with this
prefix should be treated as values and bound to the keyword.
<P>
  If the template description text given to 'NewTemplate' does not comply with
the above syntax the exception 'BadTemplate' is raised. </EM></BLOCKQUOTE><PRE>
</PRE> Argument decoding 

<P><PRE>TYPE
  <A HREF="Args.m3#Handle">Handle</A> &lt;: REFANY;

PROCEDURE <A HREF="Args.m3#Decode">Decode</A>(
    template: Template;
    VAR args: T;
    all := TRUE)
    : Handle
    RAISES {};
</PRE><BLOCKQUOTE><EM> 'Decode' decodes the arguments in 'args' according to 'template'. It returns
a handle. Enquiry functions are provided for handles so that the user can
discover if the decode was successful and, if it was, what bindings were made.
<P>
  'Decode' updates 'args'.  Whenever a keyword is found which corresponds to a
key in 'template' it is replaced by NIL. Whenever an argument simple value is
put into an array to be bound to a key it is replaced by NIL.
  If the argument 'all' is FALSE 'Decode' does keyword binding but does not do
positional binding; any unbound arguments are left in 'args'.
  If the argument 'all' is TRUE 'Decode' does keyword binding, then positional
binding and finally checks that all elements of 'args' are NIL. After a
'Decode' with 'all' TRUE every element of 'args' will be NIL.
<P>
  Argument decoding can proceed in several phases. The first phases use keyword
binding and each phase removes the keywords it matches plus the argument values
it binds. The final, positional, phase matches any remaining arguments.
<P>
  The general picture - remove all arguments bound to keywords and then process
the rest positionally - is simple. However the results may not always be as
expected. Consider the following example. Take the template
   <CODE>duo=d/2 trio=t/03/p zero=z/0 normal</CODE>
and the following argument array
   {<CODE>a</CODE>, <CODE>b</CODE>, <CODE>-normal</CODE>, <CODE>c</CODE>, <CODE>d</CODE>, <CODE>-zero</CODE>}
The keyword <CODE>-normal</CODE> is followed by 2 argument values but only one of them
can be bound. What happens to the spare <CODE>d</CODE>? One reasonable position is that
it is left to be bound positionally. This is simple to implement but makes
argument arrays hard to understand for the user - it is not possible to pick
out the positional and keyword arguments without reference to the template
description.
<P>
  This module takes the view that any argument value that appears between two
keywords cannot be bound positionally. The above example would fail to decode
because it is an attempt to bind 2 values to the key <CODE>normal</CODE> which has a quota
of 1.
<P>
  The result of this view is that positional arguments can only appear:
a) at the start of the argument array, preceding any keywords
b) at the end of the argument array, after the last keyword or argument bound
to a keyword.
This is not a completely consistent position - there can still be confusion as
to which is the last argument value bound to a keyword and which is the first
of the final positional arguments. The case for allowing positional arguments
to appear after keyword arguments is practical; most Unix programs adhere to
that style so lots of people are used to it.
<P>
  Note that when positional binding is done there may be two blocks of
positional arguments - one at the beginning and one at the end of the argument
array. The gap between these blocks acts as a separator e.g. Take the template
   <CODE>duo=d/2 trio=t/03/p needed=necessary=n/4/r/p zero=z/0 normal</CODE>
and the argument array
   {<CODE>a</CODE>, <CODE>b</CODE>, <CODE>-zero</CODE>, <CODE>c</CODE>, <CODE>d</CODE>, <CODE>e</CODE>, <CODE>f</CODE>}
After argument decoding the value bound to <CODE>trio</CODE> will be {<CODE>a</CODE>, <CODE>b</CODE>} - it
cannot grab the next <CODE>c</CODE>, even though its quota would allow it, because of the
gap left by <CODE>-zero</CODE>. The value {<CODE>c</CODE>, <CODE>d</CODE>, <CODE>e</CODE>, <CODE>f</CODE>} is bound to <CODE>needed</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Argument handle enquiry functions 

<P><PRE>PROCEDURE <A HREF="Args.m3#Good">Good</A>(h: Handle): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Did the argument decoding succeed? </EM></BLOCKQUOTE><PRE>

EXCEPTION
  BadEnquiry;

PROCEDURE <A HREF="Args.m3#Value">Value</A>(
    h: Handle;
    keyword: TEXT)
    : REF ARRAY OF TEXT
    RAISES {BadEnquiry};
</PRE><BLOCKQUOTE><EM> If 'keyword' is the name of a key in the template used when creating 'h'
'Value' returns the value bound to that key or NIL if the key was not bound.
'Value' will always return a value for a required key. 'keyword' can be any
of a keys alternative names and may be prefixed with '-'.
  If 'keyword' is not a valid key name 'Value' will raise 'BadEnquiry'. It is
a checked runtime error to call 'Value' if 'h' is not 'Good' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Args.m3#Flag">Flag</A>(h: Handle; keyword: TEXT): BOOLEAN RAISES {BadEnquiry};
</PRE><BLOCKQUOTE><EM> A specialised version of 'Value'. 'keyword' must be the name of a key with
quota zero. If it is 'Flag' returns whether or not the key was bound. If it is
not 'BadEnquiry' is raised. It is a checked runtime error to call 'Flag' if 'h'
is not 'Good' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Args.m3#Single">Single</A>(h: Handle; keyword: TEXT): TEXT RAISES {BadEnquiry};
</PRE><BLOCKQUOTE><EM> A specialised version of 'Value'. 'keyword' must be the name of a key with
an exact quota of one. If this is so 'Single' returns either NIL, if the key
was not bound, or the first element of its value array if it was. Note that a
required key is guaranteed to be bound.
  If 'keyword' is not the name of a key with an exact quota of one 'BadEnquiry'
is raised. It is a checked runtime error to call 'Single' if 'h' is not 'Good'
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Args.m3#Errors">Errors</A>(h: Handle; indent: CARDINAL := 0): TEXT RAISES {};
</PRE><BLOCKQUOTE><EM> If 'h' is not a 'Good' handle 'Errors' returns a text describing the errors
which occurred during argument decoding. The text is long and is split into
several lines. The 'indent' parameter gives the number of spaces to be inserted
at the start of each line.
  It is a checked runtime error to call 'Errors' if 'h' is 'Good' </EM></BLOCKQUOTE><PRE>
</PRE> Updating an argument handle 

<P><PRE>EXCEPTION
  BadBinding;

PROCEDURE <A HREF="Args.m3#Bind">Bind</A>(
    h: Handle;
    keyword: TEXT;
    v: REF ARRAY OF TEXT;
    override := FALSE)
    RAISES {BadBinding};
</PRE><BLOCKQUOTE><EM> Binds the value 'v' to the key named by 'keyword' in the handle 'h'. If
override is FALSE and the value currently bound to the key is non NIL 'Bind'
does nothing (so 'Bind' can be used to provide default values for keys).
  If 'override' is TRUE or the key is not currently bound 'v' is bound to the
key, providing it is suitable.
  'BadBinding' is raised if 'keyword' is not a valid key name or if 'v' is not
suitable for the named key because:
a) 'v' is NIL and key is required
b) the size of 'v' does not match the quota for the key
  It is a checked runtime error to call 'Bind' if 'h' is not 'Good' </EM></BLOCKQUOTE><PRE>
</PRE> Standard flags 

<P><PRE>CONST
  StandardTemplateDescription = &quot;help/f id=identify/f&quot;;

PROCEDURE <A HREF="Args.m3#Standard">Standard</A>(VAR args: T; VAR help, identify: BOOLEAN) RAISES {};
</PRE><BLOCKQUOTE><EM> A convenience routine. It calls 'Decode' on 'args' with a template built
from 'StandardTemplateDescription'. 'all' is FALSE so the only effect is to
see if <CODE>-help</CODE> or <CODE>-identify</CODE> or <CODE>-id</CODE> appear in 'args'. If <CODE>-help</CODE> appears
'help' is set to TRUE; if <CODE>-identify</CODE> or <CODE>-id</CODE> appear 'identify' is set to
TRUE. Otherwise 'help' and 'identify' are set to FALSE.
  Most programs are expected to call 'Standard' and check to see if they need
to print out help or identification (i.e. name and version) information </EM></BLOCKQUOTE><PRE>
</PRE> Command line arguments 

<P><PRE>PROCEDURE <A HREF="Args.m3#CommandLine">CommandLine</A>(): REF T RAISES {};
</PRE><BLOCKQUOTE><EM> Returns the arguments on the command line when the current program was
invoked. The program name is not included; element zero of the array is the
first argument (the program name can be obtained from the 'Params'
interface). Each call of this procedure returns a newly allocated array.  The
contents of the array - i.e. the texts - are only allocated once. </EM></BLOCKQUOTE><PRE>

END Args.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
