<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/Args.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/Args.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Args.i3">Args</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="CITextRefTbl.i3">CITextRefTbl</A>, <A HREF="../../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>, <A HREF="../../../params/src/Params.i3">Params</A>;
IMPORT <A HREF="TextExtras.i3">TextExtras</A>;

CONST
  KeywordPrefix = '-';
  KeywordPrefixText = &quot;-&quot;;

  Spacer = ' ';
  AlternativeSep = '=';
  TypeSep = '/';

TYPE
  Key = OBJECT
    quota: CARDINAL := 1;
    exact := TRUE;
    required := FALSE;
    positional := FALSE;
    prefix := FALSE;
    index: CARDINAL;
    names: TextList.T := NIL;
    cghack: REF INTEGER;
  END;

  Error = {None,
     RequiredArgMissing, TooFewArgs, TooManyArgs, KeyAppearsMoreThanOnce};

REVEAL
  <A NAME="Template">Template</A> = BRANDED OBJECT
    table: CITextRefTbl.T;
    count: CARDINAL := 0;
    keys: REF ARRAY OF Key := NIL;
  END;

  <A NAME="Handle">Handle</A> = BRANDED OBJECT
    errors := 0;
    template: Template;
    values: REF ARRAY OF REF ARRAY OF TEXT;
    errorList: REF ARRAY OF Error := NIL;
    leftOver: TextList.T := NIL;
  END;
</PRE> Utilities 

<P><PRE>&lt;*INLINE*&gt; PROCEDURE <A NAME="AddRear"><procedure>AddRear</procedure></A>(VAR (*inout*) l: TextList.T; t: Text.T)=
  BEGIN
    (* Append text to TextList.T *)
    WITH tl = TextList.List1(t) DO
      IF l = NIL THEN l := tl
      ELSE
        l := TextList.AppendD(l, tl);
      END;
    END
  END AddRear;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A>(READONLY args: T): REF T RAISES {}=
  VAR
    new := NEW(REF ARRAY OF TEXT, NUMBER(args));
  BEGIN
    new^ := args;
    RETURN new;
  END Copy;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Concatenate"><procedure>Concatenate</procedure></A>(READONLY args1, args2: T): REF T RAISES {}=
  VAR
    length1 := NUMBER(args1);
    length2 := NUMBER(args2);
    new := NEW(REF ARRAY OF TEXT, length1 + length2);
  BEGIN
    SUBARRAY(new^, 0, length1) := args1;
    SUBARRAY(new^, length1, length2) := args2;
    RETURN new;
  END Concatenate;
</PRE> Parsing key strings and building a template 

<P><PRE>PROCEDURE <A NAME="EnterKeyName"><procedure>EnterKeyName</procedure></A>(
    table: CITextRefTbl.T;
    t: Text.T;
    k: Key)
    RAISES {BadTemplate}=
  BEGIN
    (* Add keyword to text hash table; no duplicates allowed *)
    IF table.put(t, k) THEN
      RAISE BadTemplate;
    END; (* if *)
  END EnterKeyName;

&lt;*INLINE*&gt; PROCEDURE <A NAME="EnterKeyNames"><procedure>EnterKeyNames</procedure></A>(
    template: Template;
    key: Key)
    RAISES {BadTemplate}=
  BEGIN
    (* Make key accessible via hash table; its names are entered both with and
     without the special keyword prefix character *)
    VAR
      te: TextList.T := key.names;
    BEGIN
      WHILE te # NIL DO
        EnterKeyName(template.table, te.head, key);
        EnterKeyName(template.table, KeywordPrefixText &amp; te.head, key);
        te := te.tail;
      END;
    END;
  END EnterKeyNames;

&lt;*INLINE*&gt; PROCEDURE <A NAME="CheckKeyTypeValid"><procedure>CheckKeyTypeValid</procedure></A>(
    t, longForm: Text.T)
    RAISES {BadTemplate}=
  BEGIN
    IF Text.Length(t) &gt; 1 AND NOT TextExtras.CIEqual(t, longForm) THEN
      RAISE BadTemplate;
    END; (* if *)
  END CheckKeyTypeValid;

PROCEDURE <A NAME="KeyType"><procedure>KeyType</procedure></A>(
    key: Key;
    t: Text.T)
    RAISES {BadTemplate}=
  VAR
    ch := ASCII.Upper[Text.GetChar(t, 0)];
  BEGIN
    IF ch = 'R' THEN
      CheckKeyTypeValid(t, &quot;required&quot;);
      key.required := TRUE;
    ELSIF ch = 'L' THEN
      CheckKeyTypeValid(t, &quot;list&quot;);
      key.quota := LAST(CARDINAL);
      key.exact := FALSE;
    ELSIF ch = 'F' THEN
      CheckKeyTypeValid(t, &quot;flag&quot;);
      key.quota := 0;
    ELSIF ch = 'X' THEN
      CheckKeyTypeValid(t, &quot;prefix&quot;);
      key.prefix := TRUE;
    ELSIF ch = 'P' THEN
      CheckKeyTypeValid(t, &quot;positional&quot;);
      key.positional := TRUE;
    ELSIF ch IN ASCII.Digits THEN
      VAR used: INTEGER;
          buffer := NEW(REF ARRAY OF CHAR, Text.Length(t));
      BEGIN
        Text.SetChars(buffer^, t);
        key.quota := Convert.ToUnsigned(buffer^, used);
        IF used # NUMBER(buffer^) THEN RAISE BadTemplate END;
        key.exact := (ch # '0');
      END
    ELSE
      RAISE BadTemplate;
    END;
  END KeyType;

PROCEDURE <A NAME="GetItem"><procedure>GetItem</procedure></A>(
    t: Text.T;
    terminators: SET OF CHAR;
    limit: CARDINAL;
    VAR pos: CARDINAL;
    VAR item: Text.T)
    : CHAR
    RAISES {BadTemplate}=
  VAR
    start := pos;
  BEGIN
    (* Extract next alphanumeric item and return terminating character or
     '\000' if we have reached 'limit'. The value of 'item' returned is
     always at least one character long and alphanumeric *)
    EVAL TextExtras.FindCharSet(t, ASCII.Asciis - ASCII.AlphaNumerics, pos);
    IF pos = start THEN RAISE BadTemplate END;
    item := Text.Sub(t, start, pos - start);
    IF pos &gt;= limit THEN
      RETURN '\000';
    ELSE
      WITH ch = Text.GetChar(t, pos) DO
        INC(pos);
        IF pos &gt;= limit OR NOT ch IN terminators THEN RAISE BadTemplate END;
        RETURN ch;
      END;
    END;
  END GetItem;

PROCEDURE <A NAME="ParseKey"><procedure>ParseKey</procedure></A>(
    template: Template;
    t: Text.T;
    start, end: CARDINAL)
    RAISES {BadTemplate}=
  CONST
    BothSeps = SET OF CHAR {AlternativeSep, TypeSep};
    JustTypeSep = SET OF CHAR {TypeSep};
  VAR
    key := NEW(Key, index := template.count);
    pos := start;
    item: Text.T;
    ch: CHAR;
  BEGIN
    (* Build list of the alternative names of the key *)
    REPEAT
      ch := GetItem(t, BothSeps, end, pos, item);
      IF NOT Text.GetChar(item, 0) IN ASCII.Letters THEN
        RAISE BadTemplate;
      END;
      AddRear(key.names, item);
    UNTIL ch # AlternativeSep;

    (* Discover the type of the key *)
    WHILE ch = TypeSep DO
      ch := GetItem(t, JustTypeSep, end, pos, item);
      KeyType(key, item);
    END;

    (* Add the key names to the template *)
    EnterKeyNames(template, key);
  END ParseKey;

PROCEDURE <A NAME="NewTemplate"><procedure>NewTemplate</procedure></A>(t: Text.T): Template RAISES {BadTemplate}=
  VAR
    template := NEW(Template, table := NEW(CITextRefTbl.Default).init());
  BEGIN
    (* Parse 't' and build up hash table containing all keys *)
    VAR
      start, pos: CARDINAL := 0;
    BEGIN
      WHILE TextExtras.FindCharSet(t, ASCII.Asciis - ASCII.Set {Spacer}, pos) DO
        start := pos;
        WITH last = NOT TextExtras.FindChar(t, Spacer, pos) DO
          ParseKey(template, t, start, pos);
          INC(template.count);
          IF last THEN EXIT ELSE INC(pos) END;
        END;
      END;
    END;

    (* Build array so the keys can be accessed by index *)
    IF template.count &gt; 0 THEN
      VAR
        i := template.table.iterate();
        key: Text.T;
        value: REFANY;
      BEGIN
        template.keys := NEW(REF ARRAY OF Key, template.count);
        WHILE i.next(key, value) DO
          WITH key = NARROW(value, Key) DO
            template.keys[key.index] := key;
          END;
        END;
      END;
    END;

    RETURN template;
  END NewTemplate;
</PRE> Decoding arguments and building the argument handle 

<P><PRE>PROCEDURE <A NAME="LooksLikeKeyword"><procedure>LooksLikeKeyword</procedure></A>(t: Text.T): BOOLEAN RAISES {}=
  BEGIN
    RETURN Text.Length(t) &gt;= 2 AND Text.GetChar(t, 0) = KeywordPrefix AND
        Text.GetChar(t, 1) IN ASCII.Letters;
  END LooksLikeKeyword;

PROCEDURE <A NAME="IsKeyword"><procedure>IsKeyword</procedure></A>(
    h: Handle;
    t: Text.T;
    VAR key: Key;
    VAR tMinusPrefix: TEXT)
    : BOOLEAN
    RAISES {}=
  VAR
    ref: REFANY;
  BEGIN
    IF h.template.table.get(t, ref) THEN
      key := NARROW(ref, Key);
      RETURN TRUE;
    ELSE
      (* might be a prefix arg *)
      VAR iter := h.template.table.iterate();
          name, uname: TEXT; val: REFANY; index: CARDINAL;
          ut := ToUpper(t);
      BEGIN
        WHILE iter.next(name, val) DO
          index := 0; key := val; uname := ToUpper(name);
          IF TextExtras.FindSub(ut, uname, index) AND index = 0 AND
             key.prefix THEN
            tMinusPrefix := TextExtras.Extract(t, Text.Length(name),
                                               Text.Length(t));
            RETURN TRUE;
          END
        END;
        RETURN FALSE;
      END
    END;
  END IsKeyword;

PROCEDURE <A NAME="ToUpper"><procedure>ToUpper</procedure></A>(t: TEXT): TEXT=
  VAR
    l := Text.Length(t);
    x := NEW(REF ARRAY OF CHAR, l);
  BEGIN
    FOR i := 0 TO l-1 DO
      x[i] := ASCII.Upper[Text.GetChar(t, i)];
    END;
    RETURN Text.FromChars(x^);
  END ToUpper;

PROCEDURE <A NAME="CheckedArgValue"><procedure>CheckedArgValue</procedure></A>(t: Text.T): Text.T RAISES {}=
  VAR
    length := Text.Length(t);
  BEGIN
    IF length &gt;= 2 AND Text.GetChar(t, 0) = KeywordPrefix AND
        Text.GetChar(t, 1) = KeywordPrefix THEN
      RETURN Text.Sub(t, 1, length - 1);
    ELSE
      RETURN t;
    END; (* if *)
  END CheckedArgValue;

PROCEDURE <A NAME="NewErrorList"><procedure>NewErrorList</procedure></A>(number: CARDINAL): REF ARRAY OF Error RAISES {}=
  VAR
    new := NEW(REF ARRAY OF Error, number);
  BEGIN
    FOR i := 0 TO number - 1 DO new[i] := Error.None END;
    RETURN new;
  END NewErrorList;

&lt;*INLINE*&gt; PROCEDURE <A NAME="NoteError"><procedure>NoteError</procedure></A>(h: Handle; key: Key; newError: Error) RAISES {}=
  BEGIN
    IF h.errorList = NIL THEN
      h.errorList := NewErrorList(h.template.count);
    END;
    WITH error =  h.errorList[key.index] DO
      IF error = Error.None THEN
        error := newError;
        INC(h.errors);
      END;
    END;
  END NoteError;

&lt;*INLINE*&gt; PROCEDURE <A NAME="MoveListOfArgs"><procedure>MoveListOfArgs</procedure></A>(
    VAR from: ARRAY OF TEXT)
    : REF ARRAY OF TEXT
    RAISES {}=
  VAR
    number := NUMBER(from);
    new := NEW(REF ARRAY OF TEXT, number);
  BEGIN
    FOR i := 0 TO number - 1 DO
      WITH f = from[i] DO
        new[i] := CheckedArgValue(f);
        f := NIL;
      END;
    END;
    RETURN new;
  END MoveListOfArgs;

VAR
  null_g := NEW(REF ARRAY OF TEXT, 0);

PROCEDURE <A NAME="BindValue"><procedure>BindValue</procedure></A>(h: Handle; key: Key; VAR args: T) RAISES {}=
  VAR
    quota := key.quota;
    error := Error.None;
  BEGIN
    WITH value = h.values[key.index] DO

      IF value # NIL AND NOT key.prefix THEN
        error := Error.KeyAppearsMoreThanOnce;
      ELSIF NUMBER(args) &gt; quota THEN
        error := Error.TooManyArgs;
      ELSIF key.exact AND NUMBER(args) &lt; quota THEN
        error := Error.TooFewArgs;
      END;

      IF error = Error.None THEN
        IF key.prefix THEN
          VAR new: REF ARRAY OF TEXT; length: CARDINAL;
          BEGIN
            IF value = NIL THEN length := 1;
            ELSE
              length := NUMBER(value^) + 1;
            END;
            new := NEW(REF ARRAY OF TEXT, length);
            FOR i := 0 TO length-2 DO
              new[i] := value[i];
            END;
            new[length-1] := args[0];
            value := new;
          END
        ELSE
          value := MoveListOfArgs(args);
        END
      ELSE
        IF value = NIL THEN value := null_g END;
        NoteError(h, key, error);
        FOR i := 0 TO LAST(args) DO args[i] := NIL END;
      END;

    END;
  END BindValue;

PROCEDURE <A NAME="FindNextKeyword"><procedure>FindNextKeyword</procedure></A>(
    READONLY args: T;
    pos: CARDINAL;
    VAR argCount: CARDINAL)
    : CARDINAL
    RAISES {}=
  VAR
    countArgs := TRUE;
  BEGIN
    argCount := 0;
    LOOP
      IF pos &gt;= NUMBER(args) THEN RETURN pos END;
      WITH arg = args[pos] DO
        IF arg = NIL THEN
          countArgs := FALSE;
        ELSIF LooksLikeKeyword(arg) THEN
          RETURN pos;
        ELSE
          IF countArgs THEN INC(argCount) END;
        END;
      END;
      INC(pos);
    END;
  END FindNextKeyword;

PROCEDURE <A NAME="KeywordArgs"><procedure>KeywordArgs</procedure></A>(h: Handle; VAR args: T) RAISES {}=
  VAR
    argCount: CARDINAL;
    i := FindNextKeyword(args, 0, argCount);
  BEGIN
    WHILE i &lt;= LAST(args) DO
      WITH arg = args[i] DO
        INC(i);
        VAR
          key: Key;
          next := FindNextKeyword(args, i, argCount);
          VAR tMinusPrefix: TEXT := NIL;
        BEGIN
          IF IsKeyword(h, arg, key, tMinusPrefix) THEN
            arg := NIL;
            IF key.prefix THEN
              VAR oneArg := NEW(REF ARRAY OF TEXT, 1);
              BEGIN
                IF tMinusPrefix = NIL THEN tMinusPrefix := &quot;&quot; END;
                oneArg[0] := tMinusPrefix;
                BindValue(h, key, oneArg^);
              END;
              (* dont consume following args *)
              IF argCount # 0 THEN next := i; END;
            ELSE
              IF i + argCount &gt; LAST(args) AND key.quota &lt; argCount THEN
                argCount := key.quota;
              END;
              WITH argsForKey = SUBARRAY(args, i, argCount) DO
                BindValue(h, key, argsForKey);
              END;
            END
          END;
          i := next;
        END;
      END;
    END;
  END KeywordArgs;

PROCEDURE <A NAME="FindTrailingArgs"><procedure>FindTrailingArgs</procedure></A>(
    READONLY args: T;
    VAR pos: CARDINAL)
    : BOOLEAN
    RAISES {}=
  VAR
    search := NUMBER(args);
  BEGIN
    LOOP
      IF search = 0 THEN
        EXIT;
      ELSE
        DEC(search);
      END;
      WITH arg = args[search] DO
        IF arg = NIL THEN
          INC(search); (* So 'search' points after the NIL *)
          EXIT;
        ELSIF LooksLikeKeyword(arg) THEN
          RETURN FALSE;
        ELSE
          (* loop *)
        END;
      END;
    END;
    (* Exit to here means we hit the start of the argument array or a NIL
     argument before hitting any keywords. If there are any arguments after
     this point we have found trailing arguments *)
    IF search &lt; NUMBER(args) THEN
      pos := search;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END FindTrailingArgs;

PROCEDURE <A NAME="PositionalArgs"><procedure>PositionalArgs</procedure></A>(h: Handle; VAR args: T) RAISES {}=
  VAR
    aPos: CARDINAL := 0;
    limit: CARDINAL;
  BEGIN
    (* First check that we have some arguments to bind; only arguments at the
     head and tail of the argument array can be bound positionally *)
    EVAL FindNextKeyword(args, 0, limit);
    IF limit = 0 THEN
      IF NOT FindTrailingArgs(args, aPos) THEN RETURN END;
      limit := NUMBER(args);
    END;

    (* Iterate the keys, looking for those which can be bound positionally *)
    WITH keys = h.template.keys^ DO
      FOR kPos := FIRST(keys) TO LAST(keys) DO
        WITH key = keys[kPos] DO

          (* Check if we can bind positionally to this keyword *)
          IF key.positional AND key.quota # 0 THEN

            (* If is already bound then we terminate processing of
             positional args *)
            IF h.values[key.index] # NIL THEN RETURN END;

            (* Check we have some values to bind *)
            IF aPos = limit THEN
              IF limit &lt; NUMBER(args) AND FindTrailingArgs(args, aPos) THEN
                (* We found some more at the tail of the argument array *)
                limit := NUMBER(args);
              ELSE
                RETURN; (* We've run out *)
              END;
            END;

            (* Bind as many values as we can *)
            WITH argCount = MIN(limit - aPos, key.quota) DO
              BindValue(h, key, SUBARRAY(args, aPos, argCount));
              INC(aPos, argCount);
            END;

          END;

        END;
      END;
    END;
  END PositionalArgs;

&lt;*INLINE*&gt; PROCEDURE <A NAME="CheckRequiredArgsPresent"><procedure>CheckRequiredArgsPresent</procedure></A>(h: Handle) RAISES {}=
  BEGIN
    WITH keys = h.template.keys^ DO
      FOR i := FIRST(keys) TO LAST(keys) DO
        WITH key = keys[i] DO
          IF key.required AND h.values[i] = NIL THEN
            NoteError(h, key, Error.RequiredArgMissing);
          END;
        END;
      END;
    END;
  END CheckRequiredArgsPresent;

&lt;*INLINE*&gt; PROCEDURE <A NAME="CheckAllArgsDecoded"><procedure>CheckAllArgsDecoded</procedure></A>(h: Handle; VAR args: T) RAISES {}=
  VAR
    afterKeyword := FALSE;
  BEGIN
    FOR i := FIRST(args) TO LAST(args) DO
      WITH arg = args[i] DO
        IF arg # NIL THEN
          WITH looksLikeKeyword = LooksLikeKeyword(arg) DO
            IF looksLikeKeyword OR NOT afterKeyword THEN
              AddRear(h.leftOver, arg);
              INC(h.errors);
            END;
            IF looksLikeKeyword THEN afterKeyword := TRUE END;
          END;
          arg := NIL;
        ELSE
          afterKeyword := FALSE;
        END;
      END;
    END;
  END CheckAllArgsDecoded;

PROCEDURE <A NAME="Decode"><procedure>Decode</procedure></A>(
    template: Template;
    VAR args: T;
    all := TRUE)
    : Handle
    RAISES {}=
  VAR
    h := NEW(Handle, template := template,
        values := NEW(REF ARRAY OF REF ARRAY OF TEXT, template.count));
  BEGIN
    FOR i := 0 TO h.template.count - 1 DO h.values[i] := NIL END;

    IF h.template.count &gt; 0 THEN
      KeywordArgs(h, args);
      IF all THEN PositionalArgs(h, args) END;
      CheckRequiredArgsPresent(h);
    END;

    IF all THEN CheckAllArgsDecoded(h, args) END;

    RETURN h;
  END Decode;

PROCEDURE <A NAME="Good"><procedure>Good</procedure></A>(h: Handle): BOOLEAN RAISES {}=
  BEGIN
    RETURN h.errors = 0;
  END Good;

EXCEPTION
  Fatal;

&lt;*INLINE*&gt; PROCEDURE <A NAME="InternalValue"><procedure>InternalValue</procedure></A>(
    h: Handle;
    name: Text.T;
    VAR key: Key)
    : REF ARRAY OF TEXT
    RAISES {BadEnquiry}=
  VAR void: TEXT;
  BEGIN
    IF h.errors = 0 THEN
      IF IsKeyword(h, name, key, void) THEN
        RETURN h.values[key.index];
      ELSE
        RAISE BadEnquiry;
      END;
    ELSE
      &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal; END;
    END;
  END InternalValue;

PROCEDURE <A NAME="Value"><procedure>Value</procedure></A>(
    h: Handle;
    keyword: Text.T)
    : REF ARRAY OF TEXT
    RAISES {BadEnquiry}=
  VAR
    key: Key;
  BEGIN
    RETURN InternalValue(h, keyword, key);
  END Value;

PROCEDURE <A NAME="Flag"><procedure>Flag</procedure></A>(h: Handle; keyword: Text.T): BOOLEAN RAISES {BadEnquiry}=
  VAR
    key: Key;
    value := InternalValue(h, keyword, key);
  BEGIN
    IF key.quota # 0 THEN RAISE BadEnquiry END;
    RETURN value # NIL;
  END Flag;

PROCEDURE <A NAME="Single"><procedure>Single</procedure></A>(h: Handle; keyword: Text.T): Text.T RAISES {BadEnquiry}=
  VAR
    key: Key;
    value := InternalValue(h, keyword, key);
  BEGIN
    IF key.quota # 1 OR NOT key.exact THEN RAISE BadEnquiry END;
    IF value = NIL THEN RETURN NIL ELSE RETURN value[0] END;
  END Single;

&lt;*INLINE*&gt; PROCEDURE <A NAME="KeyName"><procedure>KeyName</procedure></A>(h: Handle; i: CARDINAL): Text.T RAISES {}=
  BEGIN
    RETURN h.template.keys[i].names.head;
  END KeyName;

PROCEDURE <A NAME="Errors"><procedure>Errors</procedure></A>(h: Handle; indent: CARDINAL := 0): Text.T RAISES {}=
  BEGIN
    IF h.errors = 0 THEN
      &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal; END;
    ELSE

      VAR
        texts := NEW(REF ARRAY OF TEXT, h.errors * 2);
            (* allocates space for all the error messages + padding *)
        pos: CARDINAL := 0;
        padding := Fmt.Pad(&quot;&quot;, indent);
        fmt: Text.T;

      &lt;*INLINE*&gt; PROCEDURE Add(t: Text.T) RAISES {}=
          BEGIN texts[pos] := t; INC(pos) END Add;
      &lt;*INLINE*&gt; PROCEDURE PaddedAdd(t: Text.T) RAISES {}=
          BEGIN Add(padding); Add(t) END PaddedAdd;

      BEGIN

        IF h.errorList # NIL THEN
          FOR i := 0 TO LAST(h.errorList^) DO
            VAR
              error := h.errorList[i];
            BEGIN
              IF error # Error.None THEN
                CASE error OF
                | Error.RequiredArgMissing =&gt;
                    fmt := &quot;Argument required for key \'%s\'\n&quot;;
                | Error.TooFewArgs =&gt;
                    fmt := &quot;Too few arguments for key \'%s\'\n&quot;;
                | Error.TooManyArgs =&gt;
                    fmt := &quot;Too many arguments for key \'%s\'\n&quot;;
                | Error.KeyAppearsMoreThanOnce =&gt;
                    fmt := &quot;More than one occurrence of key \'%s\'\n&quot;;
                | Error.None =&gt;
                    &lt;*ASSERT FALSE*&gt;
                END; (* case *)
                PaddedAdd(Fmt.F(fmt, KeyName(h, i)));
              END;
            END;
          END;
        END;

        VAR
          te: TextList.T := h.leftOver;
        BEGIN
          WHILE te # NIL DO
            IF LooksLikeKeyword(te.head) THEN
              fmt := &quot;Unknown keyword \'%s\'\n&quot;;
            ELSE
              fmt := &quot;Unexpected argument \'%s\'\n&quot;;
            END;
            PaddedAdd(Fmt.F(fmt, te.head));
            te := te.tail;
          END;
        END;

        RETURN TextExtras.JoinN(texts^);
      END;
    END; (* if *)
  END Errors;

PROCEDURE <A NAME="Bind"><procedure>Bind</procedure></A>(
    h: Handle;
    keyword: Text.T;
    v: REF ARRAY OF TEXT;
    override := FALSE)
    RAISES {BadBinding}=
  VAR
    ref: REFANY;
    key: Key;
  BEGIN
    IF h.errors # 0 THEN
      &lt;*FATAL Fatal*&gt; BEGIN RAISE Fatal; END;
    END;
    IF h.template.table.get(keyword, ref) THEN
      key := NARROW(ref, Key);
      WITH value = h.values[key.index] DO
        IF value # NIL AND NOT override THEN
          (* don't override existing value *)
          RETURN;
        ELSE
          VAR
            ok: BOOLEAN;
          BEGIN
            IF v = NIL THEN
              ok := NOT key.required;
            ELSIF key.exact THEN
              ok := NUMBER(v^) = key.quota;
            ELSE
              ok := NUMBER(v^) &lt;= key.quota;
            END;
            IF ok THEN value := v; RETURN END;
          END;
        END;
      END;
    END;
    RAISE BadBinding;
  END Bind;

VAR
  standard_g: Template;
  args_g: REF T;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>()=
  VAR
    total := Params.Count-1;
    new := NEW(REF T, total);
  &lt;* FATAL BadTemplate *&gt;
  BEGIN
    standard_g := NewTemplate(StandardTemplateDescription);
    FOR i := 0 TO total - 1 DO
      new[i] := Params.Get(i+1);
    END;
    args_g := new;
  END Init;

PROCEDURE <A NAME="CommandLine"><procedure>CommandLine</procedure></A>(): REF T RAISES {} =
  BEGIN
    RETURN Copy(args_g^);
  END CommandLine;

PROCEDURE <A NAME="Standard"><procedure>Standard</procedure></A>(VAR args: T; VAR help, identify: BOOLEAN) RAISES {}=
  VAR
    h := Decode(standard_g, args, FALSE);
  &lt;* FATAL BadEnquiry *&gt;
  BEGIN
    help := Flag(h, &quot;help&quot;);
    identify := Flag(h, &quot;identify&quot;);
  END Standard;

BEGIN Init();
END Args.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
