<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/Command.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/Command.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************
 
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Command.m3">Command</A></interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>;
</PRE> (Very) simple interactive command line interpreter. The user writes commands
which are bound to text names. The user then calls <CODE>Interact</CODE> which fires up
the CLI. The CLI prompts to <CODE>Stdio.stdout</CODE> and waits for input. If an input
line starts with a name the user has bound the users procedure is called back.
e.g:
   Command.Bind(<CODE>foo</CODE>, Foo);
   Interact();
Interact will now put out a prompt; suppose somebody then types in <CODE>foo pig</CODE>:
--&gt; foo pig
Interact will then call <CODE>Foo</CODE>. <CODE>Foo</CODE> can get at the other arguments on the line
(i.e. <CODE>pig</CODE> in this case) by using calls provided in this interface. When <CODE>Foo</CODE>
returns <CODE>Interact</CODE> will put out another prompt and wait for more input.
  There are a few built in commands e.g. quit and a simple help facility
Short forms of commands are supported, as is a user-specified prompt.


<P>
<P><PRE>PROCEDURE <A HREF="Command.m3#Bind">Bind</A>(
    name: TEXT;
    proc: PROCEDURE() RAISES{};
    help: TEXT := NIL)
    RAISES {};
</PRE><BLOCKQUOTE><EM> Bind <CODE>proc</CODE> to the given name. <CODE>help</CODE> is a help message that will be printed
out if the built in help command is executed; it should be a short text and
should NOT be terminated by a newline. If <CODE>help</CODE> is NIL no help information
will be printed for the command. Capitalisation in <CODE>name</CODE> is used to generate
the short form.
</EM></BLOCKQUOTE><PRE>

TYPE
  Closure = OBJECT METHODS apply() RAISES {} END;

PROCEDURE <A HREF="Command.m3#BindClosure">BindClosure</A>(name: TEXT; c: Closure; help: TEXT := NIL) RAISES {};
</PRE><BLOCKQUOTE><EM> More general version of <CODE>Bind</CODE>; instead of a simple callback the <CODE>apply</CODE>
method of the given object is called. As any subtype of <CODE>Closure</CODE> can be passed
in this allows <CODE>apply</CODE> to have some local state </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#SetPrompt">SetPrompt</A>(p: TEXT) RAISES {};
</PRE><BLOCKQUOTE><EM> Set the prompt to p &amp; <CODE>&gt; </CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#Interact">Interact</A>(s: Rd.T := NIL) RAISES {Rd.Failure, Wr.Failure};
</PRE><BLOCKQUOTE><EM> Outputs a prompt to <CODE>Stdio.stdout</CODE> and then waits for input on
<CODE>Stdio.stdin</CODE>.  Reads up to the next newline. If the first word of
input is matches the name of a bound procedure or closure the
corresponding procedure or closure is called. When the callback
returns another prompt is given. If the input is null or contains only
whitespace another prompt is given. Otherwise a brief message is
written to <CODE>Stdio.stdout</CODE>, explaining how to get help, and another
prompt is given. If <CODE>s # NIL</CODE> this stream is read before <CODE>Stdio.stdin</CODE>
</EM></BLOCKQUOTE><PRE>
</PRE> The following are procedures which can be used within callback
procedures to get at arguments given on the <CODE>command line</CODE> i.e. the
line of input given in response to the prompt 

<P><PRE>PROCEDURE <A HREF="Command.m3#Argument">Argument</A>(VAR arg: TEXT): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Get the next argument as a text; returns FALSE if there is no
argument.  Arguments are normally delimited by whitespace but they can
be quoted e.g.  <CODE>blah blah</CODE> is a single argument. There is no way of
<CODE>ungetting</CODE> an argument </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#GetArg">GetArg</A>(VAR a: TEXT): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Just like <CODE>Argument</CODE> but complains to <CODE>Stdio.stdout</CODE> if it fails </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#CardinalArgument">CardinalArgument</A>(VAR card: CARDINAL): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Uses <CODE>Argument</CODE> and then converts the result to a cardinal; returns FALSE
if either <CODE>Argument</CODE> or the conversion fails </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#CardGetArg">CardGetArg</A>(VAR card: CARDINAL): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Just like <CODE>CardinalArgument</CODE> but complains to <CODE>stdout</CODE> if it fails </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#IntegerArgument">IntegerArgument</A>(VAR integer: INTEGER): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Uses <CODE>Argument</CODE> and then converts the result to an integer; returns FALSE
if either <CODE>Argument</CODE> or the conversion fails </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#IntGetArg">IntGetArg</A>(VAR int: INTEGER): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Just like <CODE>IntegerArgument</CODE> but complains to <CODE>stdout</CODE> if it fails </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Command.m3#RestOfLine">RestOfLine</A>(): TEXT RAISES {};
</PRE><BLOCKQUOTE><EM> Gets the rest of the input line, excluding the newline </EM></BLOCKQUOTE><PRE>
</PRE> Convenience functions; just call the corresponding <CODE>Wr</CODE> routines with
<CODE>Stdio.stdout</CODE> as the output stream 

<P><PRE>PROCEDURE <A HREF="Command.m3#Put">Put</A>(t: TEXT) RAISES {};
PROCEDURE <A HREF="Command.m3#PutF">PutF</A>(fmt: TEXT; t1, t2, t3, t4, t5: TEXT := NIL) RAISES {};
PROCEDURE <A HREF="Command.m3#PutFN">PutFN</A>(fmt: TEXT; READONLY array: ARRAY OF TEXT) RAISES {};

END Command.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
