<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/Command.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/Command.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************
 
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Command.i3">Command</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="TextExtras.i3">TextExtras</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="CITextRefTbl.i3">CITextRefTbl</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="RdExtras.i3">RdExtras</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="#x1">Err</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>;

&lt;* FATAL Thread.Alerted, Wr.Failure *&gt;

TYPE
  Command = OBJECT
    next: Command;
    closure: Closure;
    name, help: Text.T;
  END;

CONST
  PromptTail = &quot;&gt; &quot;;

VAR
  commandNames_g := NEW(CITextRefTbl.Default).init();
  commands_g: Command := NIL;
  prompt_g := &quot;--&quot; &amp; PromptTail;

TYPE OpenMode = {Read, Write};

PROCEDURE <A NAME="SortedAdd"><procedure>SortedAdd</procedure></A>(new: Command; VAR list: Command) RAISES {}=
  BEGIN
    IF (list = NIL) OR (Text.Compare(new.name, list.name) &lt; 0) THEN
      new.next := list;
      list := new;
    ELSE
      SortedAdd(new, list.next);
    END;
  END SortedAdd;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="BindClosure"><procedure>BindClosure</procedure></A>(name: Text.T; c: Closure; help: Text.T := NIL) RAISES {}=
  VAR
    command: Command;
    l, index, lindex: CARDINAL;
    shortFormArray: REF ARRAY OF CHAR;
    shortForm: TEXT;
    ch: CHAR;
  BEGIN
    l := Text.Length(name);
    shortFormArray := NEW(REF ARRAY OF CHAR, l);
    index := 0; lindex := 0;
    WHILE index &lt; l DO
      ch := Text.GetChar(name, index);
      IF ch IN ASCII.Uppers THEN
        shortFormArray[lindex] := ASCII.Lower[ch];
        INC(lindex);
      END;
      INC(index);
    END; (* while *)
    shortForm := Text.FromChars(SUBARRAY(shortFormArray^, 0, lindex));

    command := NEW(Command);
    command.closure := c;
    command.name := name;
    IF help = NIL THEN help := &quot;&quot; END;
    command.help := help;
    IF NOT commandNames_g.put(name, command) THEN
      SortedAdd(command, commands_g);
      IF Text.Length(shortForm) &gt; 0 AND NOT Text.Equal(name, shortForm) THEN
        IF NOT commandNames_g.put(shortForm, command) THEN
        ELSE
          Err.Print(Fmt.F(&quot;Duplicated (short form of) command: \'%s\'\n&quot;,
	      shortForm),
              Err.Severity.Warning);
        END; (* if *)
      END; (* if *)
    ELSE
      Err.Print(Fmt.F(&quot;Duplicated command: \'%s\'\n&quot;, name),
          Err.Severity.Warning);
    END;
  END BindClosure;

PROCEDURE <A NAME="SetPrompt"><procedure>SetPrompt</procedure></A>(p: TEXT) RAISES {}=
  BEGIN
    prompt_g := p &amp; PromptTail;
  END SetPrompt;

TYPE
  SimpleClosure = Closure OBJECT
    proc: PROCEDURE() RAISES {}
  OVERRIDES
    apply := CallProc;
  END;

PROCEDURE <A NAME="CallProc"><procedure>CallProc</procedure></A>(sc: SimpleClosure) RAISES {}=
  BEGIN
    sc.proc();
  END CallProc;
</PRE> PUBLIC 
<PRE>PROCEDURE <A NAME="Bind"><procedure>Bind</procedure></A>(
    name: Text.T;
    proc: PROCEDURE() RAISES{};
    help: Text.T := NIL)
    RAISES {}=
  VAR
    sc: SimpleClosure;
  BEGIN
    sc := NEW(SimpleClosure);
    sc.proc := proc;
    BindClosure(name, sc, help);
  END Bind;

VAR
  quit_g: BOOLEAN;

PROCEDURE <A NAME="Help"><procedure>Help</procedure></A>() RAISES {}=
  VAR
    command := commands_g;
  BEGIN
    IF command # NIL THEN
      WHILE command # NIL DO
        PutF(&quot;%-24s %s\n&quot;, command.name, command.help);
        command := command.next;
      END;
    ELSE
      Put(&quot;No commands available!\n&quot;);
    END;
  END Help;

PROCEDURE <A NAME="Quit"><procedure>Quit</procedure></A>() RAISES {}=
  BEGIN
    quit_g := TRUE;
  END Quit;

TYPE
  StreamStack = OBJECT
    name: TEXT;
    next: StreamStack := NIL;
    rd: Rd.T := NIL; wr: Wr.T := NIL;
  END;

VAR
  inStack_g, logStack_g: StreamStack := NIL;
  dontLog_g := FALSE;

PROCEDURE <A NAME="Open"><procedure>Open</procedure></A>(
    name: Text.T;
    mode: OpenMode;
    VAR ss: StreamStack)
    RAISES {}=
  VAR
    new: StreamStack;

  BEGIN
    TRY
      new := NEW(StreamStack, next := ss, name := name);
      ss := new;
      IF mode =OpenMode.Read THEN
        ss.rd := FileRd.Open(name)
      ELSE
        ss.wr := FileWr.Open(name)
      END;
    EXCEPT
    | OSError.E =&gt;
        PutF(&quot;Open failed on '%s'\n&quot;, name);
    END;
  END Open;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(VAR ss: StreamStack) RAISES {}=
  BEGIN
    TRY
      IF ss.rd # NIL THEN Rd.Close(ss.rd); END;
      IF ss.wr # NIL THEN Wr.Close(ss.wr); END;
      ss := ss.next;
    EXCEPT
    | Rd.Failure, Wr.Failure =&gt;
        PutF(&quot;Close failed on '%s'\n&quot;, ss.name);
    END; (* try *)
  END Close;

PROCEDURE <A NAME="Indirect"><procedure>Indirect</procedure></A>() RAISES {}=
  VAR
    arg: Text.T;
  BEGIN
    dontLog_g := TRUE;
    IF GetArg(arg) THEN Open(arg, OpenMode.Read, inStack_g) END;
  END Indirect;

PROCEDURE <A NAME="Log"><procedure>Log</procedure></A>() RAISES {}=
  VAR
    arg: Text.T;
  BEGIN
    dontLog_g := TRUE;
    IF GetArg(arg) THEN Open(arg, OpenMode.Write, logStack_g) END;
  END Log;

PROCEDURE <A NAME="EndLog"><procedure>EndLog</procedure></A>() RAISES {}=
  BEGIN
    dontLog_g := TRUE;
    IF logStack_g = NIL THEN
      Put(&quot;Not logging\n&quot;);
    ELSE
      WITH name = logStack_g.name DO
        IF name # NIL THEN
          PutF(&quot;Closing log \'%s\'\n&quot;, name);
        ELSE
          Put(&quot;Closing log\n&quot;);
        END;
      END;
      Close(logStack_g);
    END;
  END EndLog;

PROCEDURE <A NAME="Last"><procedure>Last</procedure></A>() RAISES {}=
  BEGIN
    IF lastLine_g # NIL THEN
      WITH new = NEW(StreamStack, next := inStack_g,
                      rd := TextRd.New(lastLine_g), name := &quot;&quot;) DO
        inStack_g := new;
      END;
    END; (* if *)
  END Last;

PROCEDURE <A NAME="GetLine"><procedure>GetLine</procedure></A>(): Text.T RAISES {Rd.Failure, Thread.Alerted}=
  BEGIN
    LOOP
      VAR
        stdIn := inStack_g = NIL;
        in: Rd.T;
      BEGIN
        IF stdIn THEN in := Stdio.stdin ELSE in := inStack_g.rd END;
        TRY
          WITH text = RdExtras.GetText(
              in, terminate := ASCII.Set{'\n', ';'}, unget := FALSE) DO
             (* reflect input, if not from Stdio.in *)
            IF NOT stdIn THEN PutF(&quot;%s\n&quot;, text) END;
            RETURN text;
          END;
        EXCEPT
        | Rd.EndOfFile =&gt;
            IF stdIn THEN
              quit_g := TRUE;
              RETURN &quot;&quot;;
            ELSE
              Close(inStack_g);
            END;
        END;
      END;
    END;
  END GetLine;

VAR
  line_g, lastLine_g: Text.T := NIL;
  linePos_g: CARDINAL := 0;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Argument"><procedure>Argument</procedure></A>(VAR arg: Text.T): BOOLEAN RAISES {}=
  TYPE
    State = {Initial, InNormalArg, InQuotedArg};
  VAR
    length := Text.Length(line_g);
    state := State.Initial;
    start: CARDINAL;
  BEGIN
    LOOP
      IF linePos_g &gt;= length THEN
        IF state = State.Initial THEN RETURN FALSE ELSE EXIT END;
      ELSE
        WITH ch = Text.GetChar(line_g, linePos_g) DO
          IF ch IN ASCII.Spaces THEN
            IF state = State.InNormalArg THEN EXIT END;
            (* loop *)
          ELSIF ch = '\&quot;' THEN
            IF state = State.Initial THEN
              start := linePos_g + 1;
              state := State.InQuotedArg;
            ELSE
              EXIT;
            END;
          ELSE
            IF state = State.Initial THEN
              start := linePos_g;
              state := State.InNormalArg;
            END;
          END;
          INC(linePos_g);
        END;
      END;
    END;
    arg := TextExtras.Extract(line_g, start, linePos_g);
    IF state = State.InQuotedArg THEN INC(linePos_g) END;
    RETURN TRUE;
  END Argument;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="CardinalArgument"><procedure>CardinalArgument</procedure></A>(VAR card: CARDINAL): BOOLEAN RAISES {}=
  VAR
    arg: Text.T;
    used, argl: INTEGER;
    t: REF ARRAY OF CHAR;
  BEGIN
    IF Argument(arg) THEN
      argl := Text.Length(arg);
      t := NEW(REF ARRAY OF CHAR, argl);
      Text.SetChars(t^, arg);
      card := Convert.ToUnsigned(t^, used);
      RETURN used = argl;
    ELSE
      RETURN FALSE;
    END;
  END CardinalArgument;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="IntegerArgument"><procedure>IntegerArgument</procedure></A>(VAR integer: INTEGER): BOOLEAN RAISES {}=
  VAR
    arg: Text.T;
    used, argl: INTEGER;
    t: REF ARRAY OF CHAR;
  BEGIN
    IF Argument(arg) THEN
      argl := Text.Length(arg);
      t := NEW(REF ARRAY OF CHAR, argl);
      integer := Convert.ToInt(t^, used);
      RETURN used = argl;
    ELSE
      RETURN FALSE;
    END;
  END IntegerArgument;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="RestOfLine"><procedure>RestOfLine</procedure></A>(): Text.T RAISES {}=
  BEGIN
    RETURN TextExtras.Extract(line_g, linePos_g, Text.Length(line_g));
  END RestOfLine;

PROCEDURE <A NAME="LogLine"><procedure>LogLine</procedure></A>() RAISES {}=
  VAR
    log := logStack_g;
  BEGIN
    IF log # NIL AND NOT dontLog_g THEN
      WITH line = Fmt.F(&quot;%s\n&quot;, line_g) DO
        TRY
          WHILE log # NIL DO Wr.PutText(log.wr, line); log := log.next END;
        EXCEPT
        | Wr.Failure =&gt;
            PutF(&quot;Error writing to log file '%s'&quot;, log.name);
        END; (* try *)
      END;
    END;
  END LogLine;

PROCEDURE <A NAME="TidyUp"><procedure>TidyUp</procedure></A>() RAISES {}=
  BEGIN
    WHILE logStack_g # NIL DO Close(logStack_g) END;
    WHILE inStack_g # NIL DO Close(inStack_g) END;
    Wr.Flush(Stdio.stdout);
  END TidyUp;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Interact"><procedure>Interact</procedure></A>(s: Rd.T := NIL) RAISES {Rd.Failure, Wr.Failure}=
  VAR
    t: Text.T;
    ref: REFANY;
    command: Command;
  BEGIN
    quit_g := FALSE;
    IF s # NIL THEN inStack_g := NEW(StreamStack, rd := s); END;
    REPEAT
      Put(prompt_g);
      Wr.Flush(Stdio.stdout);
      lastLine_g := line_g;
      line_g := GetLine();
      linePos_g := 0;
      dontLog_g := FALSE;
      IF Argument(t) THEN
        IF commandNames_g.get(t, ref) THEN
          command := NARROW(ref, Command);
          command.closure.apply();
          LogLine();
        ELSE
          Put(&quot;Bad command: \'?\' to list commands\n&quot;);
        END;
      ELSE
        (* no command *)
      END;
    UNTIL quit_g;
    TidyUp();
  END Interact;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A>(VAR a: Text.T): BOOLEAN RAISES {}=
  BEGIN
    IF Argument(a) THEN RETURN TRUE; END;
    Put(&quot;Bad args\n&quot;);
    RETURN FALSE;
  END GetArg;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="CardGetArg"><procedure>CardGetArg</procedure></A>(VAR card: CARDINAL): BOOLEAN RAISES {}=
  BEGIN
    IF CardinalArgument(card) THEN RETURN TRUE; END;
    Put(&quot;Bad args\n&quot;);
    RETURN FALSE;
  END CardGetArg;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="IntGetArg"><procedure>IntGetArg</procedure></A>(VAR int: INTEGER): BOOLEAN RAISES {}=
  BEGIN
    IF IntegerArgument(int) THEN RETURN TRUE; END;
    Put(&quot;Bad args\n&quot;);
    RETURN FALSE;
  END IntGetArg;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Put"><procedure>Put</procedure></A>(t: Text.T) RAISES {}=
  BEGIN
    Wr.PutText(Stdio.stdout, t); Wr.Flush(Stdio.stdout);
  END Put;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="PutF"><procedure>PutF</procedure></A>(fmt: Text.T; t1, t2, t3, t4, t5: Text.T := NIL) RAISES {}=
  BEGIN
    Wr.PutText(Stdio.stdout, Fmt.F(fmt, t1, t2, t3, t4, t5));
    Wr.Flush(Stdio.stdout);
  END PutF;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="PutFN"><procedure>PutFN</procedure></A>(fmt: Text.T; READONLY array: ARRAY OF TEXT) RAISES {}=
  BEGIN
    Wr.PutText(Stdio.stdout, Fmt.FN(fmt, array));
    Wr.Flush(Stdio.stdout);
  END PutFN;

BEGIN
  Bind(&quot;?&quot;, Help, &quot;give help information&quot;);
  Bind(&quot;Quit&quot;, Quit, &quot;quit the program&quot;);
  Bind(&quot;Help&quot;, Help, &quot;give help information&quot;);
  Bind(&quot;@&quot;, Indirect, &quot;read commands from named file&quot;);
  Bind(&quot;Last&quot;, Last, &quot;redo last command&quot;);
  Bind(&quot;StartLog&quot;, Log, &quot;save all commands in named log file&quot;);
  Bind(&quot;EndLog&quot;, EndLog, &quot;stop logging&quot;);
END Command.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
