<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/Err.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/Err.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="#x1">Err</A></implements></module>;

IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../../params/src/Params.i3">Params</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../../os/src/Common/Process.i3">Process</A>;

PROCEDURE <A NAME="DefaultPrint"><procedure>DefaultPrint</procedure></A>(msg: TEXT)=
  BEGIN
    TRY
      WITH err = Stdio.stderr DO
        Wr.PutText(err, msg);
        Wr.Flush(err);
      END;
    EXCEPT
    | Wr.Failure, Thread.Alerted =&gt; (* give up *)
    END;
  END DefaultPrint;

EXCEPTION
  Disaster;

VAR progname_g: TEXT := NIL;

PROCEDURE <A NAME="Print"><procedure>Print</procedure></A>(
    msg: TEXT;
    severity: Severity := Severity.Fatal;
    newline: BOOLEAN := TRUE)
    RAISES {} =
  VAR
    first, second, third: TEXT;
  BEGIN
    IF severity = Severity.Continue THEN
      first := &quot;&quot;;
    ELSE
      first := progname_g &amp; &quot;: &quot;;
    END;
    CASE severity OF
    | Severity.Warning =&gt; second := &quot;(Warning) &quot;;
    | Severity.Error =&gt; second := &quot;(Error) &quot;;
    | Severity.Fatal =&gt; second := &quot;(Fatal error) &quot;;
    | Severity.Disaster =&gt; second := &quot;(Disaster) &quot;;
    ELSE second := &quot;&quot;;
    END;
    IF newline THEN third := &quot;\n&quot; ELSE third := &quot;&quot; END;
    DefaultPrint(first &amp; second &amp; msg &amp; third);
    IF severity = Severity.Fatal THEN
      Process.Exit(1);
    ELSIF severity = Severity.Disaster THEN
      &lt;*FATAL Disaster*&gt; BEGIN RAISE Disaster; END;
    END;
  END Print;

PROCEDURE <A NAME="SetProgramName"><procedure>SetProgramName</procedure></A>(n: TEXT): TEXT=
  VAR prev := progname_g;
  BEGIN
    progname_g := n;
    RETURN prev;
  END SetProgramName;

BEGIN
  progname_g := Params.Get(0);
END Err.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
