<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/FingerPrint.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/FingerPrint.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="FingerPrint.m3">FingerPrint</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P> Fingerprints are based on irreducible polynomials in GF(2**31)
   A full description of the algorithms used can be found in:
<P>
   <CODE>Probabilistic Algorithms In Finite Fields</CODE>
   Michael O. Rabin
   SIAM Journal on Computing, Volum3 9 (1980), Pages 273-280
<P>
   Fingerprints by Random Polynomials
   Michael O. Rabin
   Harvard University Technical Report:  TR 15-81
<P>
   The fingerprint values that are produced have 31 significant bits.
   Bit 0 (the least significant bit) is always 0.


<P><PRE>PROCEDURE <A HREF="FingerPrint.m3#Data">Data</A>(addr: ADDRESS;
               lengthInBytes: INTEGER;
               VAR (* out *) h1, h2: INTEGER) RAISES {};
</PRE> DataSingle should only be used when there a <CODE>few</CODE> (less than 10,000)
   items to be fingerprinted.  In this case, the chance of two data sets
   having the fingerprint is small.  If you have more elements to
   fingerprint or need to be more certain that there are no finger print
   clashes, use the regular Data procedure.

<PRE>PROCEDURE <A HREF="FingerPrint.m3#DataSingle">DataSingle</A>(addr: ADDRESS;
                     lengthInBytes: INTEGER;
                     VAR (* out *) h: INTEGER) RAISES {};

TYPE
  Byte = [0..255];
</PRE> Before the first call on Incremental, h1 and h2 must be 0.
   After each call, h1 and h2 contain the fingerprint value for
   the bytes seen so far.

<PRE>PROCEDURE <A HREF="FingerPrint.m3#Incremental">Incremental</A>(byte: Byte;
                      VAR (* in/out *) h1, h2: INTEGER) RAISES {};
</PRE> Before the first call on Incremental, h must be 0.
   After each call, h contains the fingerprint value for
   the bytes seen so far.
<P>
   IncrementalSingle should only be used when there a <CODE>few</CODE> (less than 10,000)
   items to be fingerprinted.  In this case, the chance of two data sets
   having the fingerprint is small.  If you have more elements to
   fingerprint or need to be more certain that there are no finger print
   clashes, use the regular Increment procedure.

<PRE>PROCEDURE <A HREF="FingerPrint.m3#IncrementalSingle">IncrementalSingle</A>(byte: Byte;
                            VAR (* in/out *) h: INTEGER) RAISES {};

PROCEDURE <A HREF="FingerPrint.m3#Text">Text</A>(t: TEXT;
               VAR (* out *) h1, h2: INTEGER) RAISES {};
</PRE> TextSingle should only be used when there a <CODE>few</CODE> (less than 10,000)
   items to be fingerprinted.  In this case, the chance of two data sets
   having the fingerprint is small.  If you have more elements to
   fingerprint or need to be more certain that there are no finger print
   clashes, use the regular Text procedure.

<PRE>PROCEDURE <A HREF="FingerPrint.m3#TextSingle">TextSingle</A>(t: TEXT;
                     VAR (* out *) h1: INTEGER) RAISES {};
</PRE> The following incremental fingerprinting procedure are included for
   completeness.  
   They all require that the fingerprint values be initialized to 0 before the
   first call.
   For example, the same fingerprint is derived for the following set of calls:
<P>
     Text(<CODE>abced</CODE>, h1, h2);
<P>
   OR
<P>
     h1 := 0; h2 := 0;
     Incremental(ORD('a'), h1, h2);
     Incremental(ORD('b'), h1, h2);
     Incremental(ORD('c'), h1, h2);
     Incremental(ORD('d'), h1, h2);
     Incremental(ORD('3'), h1, h2);
<P>
   OR
<P>
     Text(<CODE>abc</CODE>, h1, h2);
     TextIncremental(<CODE>de</CODE>, h1, h2);
<P>
   ETC...


<P><PRE>PROCEDURE <A HREF="FingerPrint.m3#DataIncremental">DataIncremental</A>(addr: ADDRESS;
                          lengthInBytes: INTEGER;
                          VAR (* out *) h1, h2: INTEGER) RAISES {};

PROCEDURE <A HREF="FingerPrint.m3#DataIncrementalSingle">DataIncrementalSingle</A>(addr: ADDRESS;
                                lengthInBytes: INTEGER;
                                VAR (* out *) h: INTEGER) RAISES {};

PROCEDURE <A HREF="FingerPrint.m3#TextIncremental">TextIncremental</A>(text: TEXT;
                          VAR (* out *) h1, h2: INTEGER) RAISES {};

PROCEDURE <A HREF="FingerPrint.m3#TextIncrementalSingle">TextIncrementalSingle</A>(text: TEXT;
                                VAR (* out *) h: INTEGER) RAISES {};

END FingerPrint.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
