<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/M3Args.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/M3Args.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3Args.m3">M3Args</A></interface>;
</PRE> This package provides argument decoding and help support for tools
that operate in either a Unix style command line environment, or in
a window based environment.  In particular, several tools can coexist
in a single program. 
<P>


<P>
<P><PRE>TYPE
  <A HREF="M3Args.m3#T">T</A> &lt;: REFANY;  (* tool handle *)

  Opt = {Optional, Required, Positional};

PROCEDURE <A HREF="M3Args.m3#New">New</A>(
    toolName, toolDescription, version: TEXT;
    master := FALSE;
    ): T RAISES {};
</PRE><BLOCKQUOTE><EM> Register a new tool, returning a handle for later use </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>toolName</CODE> is a short name for the tool, for example, <CODE>m3c</CODE>.  It
will used to prefix any messages generated by other calls.
<CODE>toolDescription</CODE> is a longer explanation that is output when help is
requested, e.g. <CODE>Modula-3 Compiler Front End</CODE>. <CODE>version</CODE> is the
version of the tool.  All of these arguments are required to be
non-empty <CODE>TEXTs</CODE>.  <CODE>master</CODE> indicates whether this is the master (or
controlling) tool.  The master tool information will always be
displayed first in the help output. It is a checked run-time error
if a tool named <CODE>toolName</CODE> has already been created. 

<P><PRE>PROCEDURE <A HREF="M3Args.m3#SetMaster">SetMaster</A>(t: T): T RAISES {};
</PRE><BLOCKQUOTE><EM> Set <CODE>t</CODE> to be the master tool, returning the previous master,
  if any, else NIL. </EM></BLOCKQUOTE><PRE>
</PRE> The following three procedures register keyword arguments with a
tool.  The values associated with a keyword take one of three types: a
flag (boolean), a single string or a a sequence of strings. <CODE>usage</CODE> is
displayed in response to a request for help. If <CODE>opt = Required</CODE>, it
is an error for the argument to be unset, and this will cause <CODE>Find</CODE>
to return <CODE>FALSE</CODE>.  Flag keywords are always optional; their omission
is equivalent to a value of <CODE>FALSE</CODE>. The <CODE>Positional</CODE> setting, which
also imples <CODE>Optional</CODE>, is only relevant to a command line
implementation, in which case, this and only this argument can be
supplies without the keyword.  Keywords are assigned {\it short forms}
by concatenating all the upper-case letters in <CODE>argName</CODE> from left to
right. So the short form of <CODE>PrintUnit</CODE> would be <CODE>pu</CODE>. Numerics are
not included in short-forms, so the the short-form of <CODE>LM3Check</CODE> would
be <CODE>lmc</CODE>. For any tool, all it's keyword names and their short forms
must be unique. In addition, an implementation, for example based on a
commmand line, may require that the keywords be unique across all the
registered tools. A keyword may be denoted as {\it shared} by setting
<CODE>shared = TRUE</CODE>, in which case the same value will be propagated to
all tools. If duplicates are not allowed and <CODE>shared = FALSE</CODE>, a
duplicate will cause a checked runtime error will occur. Prefix
keywords are somewhat like flags; any keyword that begins with
<CODE>argName</CODE> will match but, since there may be several such matches, the
<CODE>Get</CODE>/<CODE>Set</CODE> procedures return/takes text arrays like
<CODE>RegisterStringList</CODE>.  Prefix arguments support the <CODE>-Idir</CODE> idiom
beloved by some tools.
<P>
Clients of this interface can update the keyword argument values
directly by the calls <CODE>SetFlag</CODE>, <CODE>SetString</CODE>, <CODE>SetStringList</CODE> and
<CODE>SetPrefix</CODE>.  In addition from time to time values may be transferred
from the <CODE>outside</CODE>, for example a dialog box, by a daemon. The <CODE>Find</CODE>
call is guaranteed to force the transfer, so it is required that each
tool call this procedure before accessing values. All calls are atomic
with respect to the daemon. 

<P><PRE>PROCEDURE <A HREF="M3Args.m3#RegisterFlag">RegisterFlag</A>(
    t: T;
    argName: TEXT;
    usage: TEXT;
    shared := FALSE);
</PRE><BLOCKQUOTE><EM> Register a <CODE>Flag</CODE> keyword called <CODE>argName</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#RegisterString">RegisterString</A>(
    t:T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE);
</PRE><BLOCKQUOTE><EM> Register a <CODE>String</CODE> keyword called <CODE>argName</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#RegisterStringList">RegisterStringList</A>(
    t:T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE);
</PRE><BLOCKQUOTE><EM> Register a <CODE>StringList</CODE> keyword called <CODE>argName</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#RegisterPrefix">RegisterPrefix</A>(
    t:T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE);
</PRE><BLOCKQUOTE><EM> Register a <CODE>Prefix</CODE> keyword called <CODE>argName</CODE> </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Help information} 

<P> The way in which help information is requested and displayed is
implementation dependent. For example, in a command line
implementation, the keyword <CODE>Help</CODE> might be reserved for this purpose.
The <CODE>CheckHelp</CODE> procedure is provided to discover if help has been
requested. If so, and <CODE>display=TRUE</CODE>, then <CODE>CheckHelp</CODE> calls
<CODE>Help(t)</CODE>, for all registered tools, It returns TRUE if help was
requested.  If <CODE>display=FALSE</CODE> the calls on <CODE>Help(t)</CODE> are suppressed,
which enables a master tool to subvert the normal behaviour. 

<P><PRE>PROCEDURE <A HREF="M3Args.m3#Help">Help</A>(t: T; preamble := TRUE) RAISES {};
</PRE><BLOCKQUOTE><EM> Give help on tool <CODE>t</CODE>, showing the <CODE>usage</CODE> text passed to
registration procs.  If <CODE>preamble = TRUE</CODE>, general information on
keyword types and short forms is output first. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#CheckHelp">CheckHelp</A>(display := TRUE): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Check for help requested and if <CODE>display=TRUE</CODE>, call <CODE>Help(t)</CODE>
for all <CODE>t</CODE> in the set of registered tools. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#HelpPreamble">HelpPreamble</A>(t: T) RAISES {};
</PRE><BLOCKQUOTE><EM> Display the general information on keyword types and short forms. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Getting and Setting Argument Values} 

<P> Unbound arguments return <CODE>NIL</CODE> for <CODE>String</CODE> and <CODE>StringList</CODE>
keywords.  The empty string list is denoted by a result <CODE>r</CODE> where
NUMBER(r) = 0.  It is a checked runtime error to provide an argument
name that has not been registered. 

<P><PRE>PROCEDURE <A HREF="M3Args.m3#Find">Find</A>(t: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Gather the arguments for tool <CODE>t</CODE>. This ensures that arguments from
the <CODE>outside</CODE> are transferred into the tool's maps. The result will be
<CODE>TRUE</CODE> unless the arguments are incorrect, for example, a missing
<CODE>Required</CODE> argument. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#GetFlag">GetFlag</A>(t: T; argName: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return the value of <CODE>Flag</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#GetString">GetString</A>(t: T; argName: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> Return the value of <CODE>String</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#GetStringList">GetStringList</A>(t: T; argName: TEXT): REF ARRAY OF TEXT;
</PRE><BLOCKQUOTE><EM> Return the value of <CODE>StringList</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#GetPrefix">GetPrefix</A>(t: T; s: TEXT): REF ARRAY OF TEXT;
</PRE><BLOCKQUOTE><EM> Return the value of <CODE>Prefix</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#SetFlag">SetFlag</A>(t: T; argName: TEXT; f: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Set the value of <CODE>Flag</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE> to <CODE>f</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#SetString">SetString</A>(t: T; argName: TEXT; val: TEXT);
</PRE><BLOCKQUOTE><EM> Set the value of <CODE>String</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE> to <CODE>val</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#SetStringList">SetStringList</A>(t: T; argName: TEXT; sl: REF ARRAY OF TEXT);
</PRE><BLOCKQUOTE><EM> Set the value of <CODE>StringList</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE> to <CODE>val</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#SetPrefix">SetPrefix</A>(t: T; s: TEXT; sl: REF ARRAY OF TEXT);
</PRE><BLOCKQUOTE><EM> Set the value of <CODE>Prefix</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE> to <CODE>val</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Args.m3#SetStringAsList">SetStringAsList</A>(t: T; argName: TEXT; val: TEXT);
</PRE><BLOCKQUOTE><EM> Takes a comma or space separated string <CODE>val</CODE>, breaks it into
sub-strings at the boundaries defined by the comma or space characters
and sets the value of <CODE>StringList</CODE> keyword <CODE>argName</CODE> in tool <CODE>t</CODE> to
rge resulting list of sub-strings. </EM></BLOCKQUOTE><PRE>
</PRE> \subsection{Example} 

<P> In the initialisation code for the tool, place a call to <CODE>New</CODE>, and
record the tool handle.  For example:
<P>
<PRE>
      MODULE MyTool;
      ..
      BEGIN
        tool_g := M3Args.New(&quot;mytool&quot;, &quot;My Wonderful Tool&quot;, &quot;1.1&quot;);
        (* now register argument keywords, e.g. 

<PRE>|   M3Args.RegisterFlag(tool_g, &quot;PrintUnits&quot;,
|        &quot;print name of units as they are compiled&quot;);
| END MyTool.

In the action routines of the tool, call &quot;Find&quot; to gather arguments
and then &quot;GetFlag, GetString, GetStringList&quot; as appropriate.

In a main program which includes &quot;MyTool&quot;, always start with a call
to &quot;CheckHelp&quot; to ensure that a simple call by the user for help works,
and then go about your business as usual. *)

END M3Args.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
