<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/M3Args.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/M3Args.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>MODULE <module>M3Args</module> EXPORTS <A HREF="M3Args.i3"><implements>M3Args</A></implements>, <A HREF="M3ArgsCL.i3"><implements>M3ArgsCL</A></implements>;
</PRE> This implementation uses Args and also assumes that it is working
   from a command line decoding. It amalgamates all the keywords into
   a single template, and does a single decode. M3ArgsCL.Reset can
   be called to redo the decoding.


<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="TextExtras.i3">TextExtras</A>, <A HREF="Args.i3">Args</A>, <A HREF="#x1">Err</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../../libm3/derived/RefListSort.i3">RefListSort</A>;

TYPE
  ArgState = OBJECT
    name: TEXT;
    nameAndKind: TEXT;
    usage: TEXT;
    shared: BOOLEAN;
  END;

  FlagArgState = ArgState BRANDED OBJECT END;
  StringArgState = ArgState BRANDED OBJECT END;
  StringListArgState = ArgState BRANDED OBJECT END;
  PrefixArgState = ArgState BRANDED OBJECT END;

REVEAL
  <A NAME="T">T</A> = BRANDED REF RECORD
    toolName, toolDescription, version: TEXT;
    master: BOOLEAN;
    argList: RefList.T;
  END;

VAR
  toolList_g: RefList.T;   (* list of all registered tools *)
  master_g: T := NIL;      (* current master *)
  args_g: RECORD
    init: BOOLEAN;    (* have we done Args.NewTemplate/Args.Decode? *)
    cl: REF Args.T;   (* Command line *)
    template: Args.Template;
    handle: Args.Handle;
    keyString: TEXT;
    help, identify: BOOLEAN;
  END;

CONST
  IndentLength = 24;
  Indent = &quot;                         &quot;;

EXCEPTION
  DuplicateArg; (* no non-shared duplicates allowed *)
  ClashingShortform;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(toolName, toolDescription, version: TEXT;
    master := FALSE): T RAISES {} =
  VAR
    t: T;
  BEGIN
    t := NEW(T);
    t.toolName := toolName;
    t.toolDescription := toolDescription;
    t.version := version;
    t.master := master;
    t.argList := NIL;
    IF master THEN
      toolList_g := RefList.Cons(t, toolList_g); master_g := t;
    ELSE toolList_g := RefList.AppendD(toolList_g, RefList.List1(t));
    END;
    RETURN t;
  END New;

PROCEDURE <A NAME="SetMaster"><procedure>SetMaster</procedure></A>(t: T): T RAISES {}=
  PROCEDURE Compare(e1: REFANY; &lt;*UNUSED*&gt; e2: REFANY): [-1..1]=
    BEGIN
      IF e1 = t THEN RETURN -1 ELSE RETURN 1 END;
    END Compare;

  VAR r := master_g;
  BEGIN
    toolList_g := RefListSort.SortD(toolList_g, Compare);
    master_g := t;
    RETURN r;
  END SetMaster;

PROCEDURE <A NAME="Usage"><procedure>Usage</procedure></A>(t: T) RAISES {} =
  VAR
    al: RefList.T;
    a: ArgState;
    l: INTEGER;
  BEGIN
    Err.Print(t.toolDescription, Err.Severity.Comment);
    al := t.argList;
    WHILE al # NIL DO
      a := al.head;
      Err.Print(&quot;-&quot;, Err.Severity.Continue, FALSE);
      Err.Print(a.nameAndKind, Err.Severity.Continue, FALSE);
      l := Text.Length(a.nameAndKind);
      REPEAT Err.Print(&quot; &quot;, Err.Severity.Continue, FALSE); INC(l)
      UNTIL l &gt;= IndentLength;
      Err.Print(a.usage, Err.Severity.Continue, FALSE);
      Err.Print(&quot;&quot;, Err.Severity.Continue);
      al := al.tail;
    END; (* while *)
    Err.Print(&quot;&quot;, Err.Severity.Continue)
  END Usage;

PROCEDURE <A NAME="RegisterFlag"><procedure>RegisterFlag</procedure></A>(
    t: T;
    argName: TEXT;
    usage: TEXT;
    shared := FALSE) RAISES {} =
  BEGIN
    RegisterArg(NEW(FlagArgState), t, argName, usage, Opt.Optional, shared);
  END RegisterFlag;

PROCEDURE <A NAME="RegisterString"><procedure>RegisterString</procedure></A>(
    t: T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE)
    RAISES {} =
  BEGIN
    RegisterArg(NEW(StringArgState), t, argName, usage, opt, shared);
  END RegisterString;

PROCEDURE <A NAME="RegisterStringList"><procedure>RegisterStringList</procedure></A>(
    t: T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE)
    RAISES {} =
  BEGIN
    RegisterArg(NEW(StringListArgState), t, argName, usage, opt, shared);
  END RegisterStringList;

PROCEDURE <A NAME="RegisterPrefix"><procedure>RegisterPrefix</procedure></A>(
    t:T;
    argName: TEXT;
    usage: TEXT;
    opt: Opt := Opt.Optional;
    shared := FALSE) RAISES {}=
  BEGIN
    RegisterArg(NEW(PrefixArgState), t, argName, usage, opt, shared);
  END RegisterPrefix;

PROCEDURE <A NAME="RegisterArg"><procedure>RegisterArg</procedure></A>(a: ArgState; t: T; argName: TEXT;
    usage: TEXT;
    opt: Opt;
    shared := FALSE) RAISES {} =
  VAR
    shortForm, nameAndKind: TEXT;
  BEGIN
    a.name := argName;
    a.usage := ExpandNL(usage);
    nameAndKind := ArgsArgName(argName, a, opt, shortForm);
    a.nameAndKind:= nameAndKind;
    a.shared := shared;
    IF IsDuplicated(argName, shortForm, ISTYPE(a, PrefixArgState), shared) THEN
      IF NOT shared THEN
        &lt;*FATAL DuplicateArg*&gt; BEGIN RAISE DuplicateArg END;
      END;
    ELSE
      args_g.keyString := args_g.keyString &amp; a.nameAndKind;
      args_g.keyString := args_g.keyString &amp; &quot; &quot;;
    END;
    t.argList:= RefList.AppendD(t.argList, RefList.List1(a));
  END RegisterArg;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ExpandNL"><procedure>ExpandNL</procedure></A>(t: TEXT): TEXT RAISES {}=
  VAR
    index: CARDINAL := 0;
  BEGIN
    LOOP
      IF TextExtras.FindChar(t, '\n', index) THEN
      	t := TextExtras.Extract(t, 0, index+1) &amp; Indent &amp;
	     TextExtras.Extract(t, index+1, Text.Length(t));
        INC(index);
      ELSE
      	EXIT
      END; (* if *)
    END; (* loop *)
    RETURN t;
  END ExpandNL;

PROCEDURE <A NAME="Help"><procedure>Help</procedure></A>(t: T; preamble := TRUE) RAISES {} =
  BEGIN
    Setup(t);
    IF preamble THEN HelpPreamble(t); END;
    Usage(t);
  END Help;

PROCEDURE <A NAME="HelpPreamble"><procedure>HelpPreamble</procedure></A>(t: T; ) RAISES {} =
  BEGIN
    Setup(t);
    Err.Print(
  &quot;Keywords - \'/f\' boolean flag. \'/l\' space separated list of values.\n&quot; &amp;
  &quot;           \'/1\' single value. \'/r\' means mandatory.\n&quot; &amp;
  &quot;           \'/p\' means positional argument (keyword can be omitted).\n&quot; &amp;
  &quot;Capitalisation (and \'=short\') indicates alternative shortened form.\n&quot;,
      Err.Severity.Continue);
  END HelpPreamble;

PROCEDURE <A NAME="CheckHelp"><procedure>CheckHelp</procedure></A>(display := TRUE): BOOLEAN RAISES {} =
  VAR
    tl: RefList.T; t: T;
  BEGIN
    Setup(NIL);
    IF args_g.help OR args_g.identify THEN
      IF display THEN
        tl := toolList_g;
        IF tl # NIL AND args_g.help THEN HelpPreamble(t) END;
        WHILE tl # NIL DO
          t := tl.head;
          SetName(t);
          IF args_g.identify THEN
            Err.Print(&quot;Version &quot; &amp; t.version, Err.Severity.Comment);
          END;
          IF args_g.help THEN Usage(t); END;
          tl := tl.tail;
        END; (* while *)
      END;
      RETURN TRUE
    ELSE
      RETURN FALSE
    END;
  END CheckHelp;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>(t: T) RAISES {} =
  BEGIN
    SetName(t);
    ArgsInit();
  END Setup;

PROCEDURE <A NAME="ArgsInit"><procedure>ArgsInit</procedure></A>() RAISES {} =
  BEGIN
    IF NOT args_g.init THEN
      args_g.cl := Args.CommandLine();
      &lt;*FATAL Args.BadTemplate*&gt;
      BEGIN
        args_g.template := Args.NewTemplate(args_g.keyString);
      END;
      ArgsDecode();
    END;
  END ArgsInit;

PROCEDURE <A NAME="ArgsDecode"><procedure>ArgsDecode</procedure></A>() RAISES {}=
  BEGIN
    Args.Standard(args_g.cl^, args_g.help, args_g.identify);
    args_g.handle := Args.Decode(args_g.template, args_g.cl^, TRUE);
    args_g.init := TRUE;
  END ArgsDecode;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A>(cl: REF Args.T) RAISES {}=
  BEGIN
    args_g.cl := cl;
    ArgsDecode();
  END Reset;

PROCEDURE <A NAME="SetName"><procedure>SetName</procedure></A>(t: T) RAISES {} =
  VAR name: TEXT;
  BEGIN
    IF t = NIL THEN name := &quot;m3args&quot; ELSE name := t.toolName; END;
    EVAL Err.SetProgramName(name);
  END SetName;

PROCEDURE <A NAME="Find"><procedure>Find</procedure></A>(t: T): BOOLEAN RAISES {} =
  BEGIN
    Setup(t);
    IF Args.Good(args_g.handle) THEN
      RETURN TRUE;
    ELSE
      Err.Print(&quot;Bad args - use \'-help\' if in need of help&quot;,
          Err.Severity.Warning);
      RETURN FALSE;
    END;
  END Find;

PROCEDURE <A NAME="ArgsArgName"><procedure>ArgsArgName</procedure></A>(s: TEXT;
    a: ArgState; opt: Opt;
    VAR (*out*) shortForm: TEXT): TEXT RAISES {} =
  VAR
    ns: TEXT;
    l, index, lindex: CARDINAL;
    shortFormArray: REF ARRAY OF CHAR;
    ch: CHAR;
  BEGIN
    l := Text.Length(s);
    shortFormArray := NEW(REF ARRAY OF CHAR, l);
    index := 0; lindex := 0;
    WHILE index &lt; l DO
      ch := Text.GetChar(s, index);
      IF ch IN ASCII.Uppers THEN
        shortFormArray[lindex] := ASCII.Lower[ch];
        INC(lindex);
      END;
      INC(index);
    END; (* while *)
    shortForm := Text.FromChars(SUBARRAY(shortFormArray^, 0, lindex));
    (* check and ignore if short form = long form *)
    IF TextExtras.CIEqual(s, shortForm) THEN
      lindex := 0;
    END; (* if *)
    IF lindex &gt; 0 THEN
      ns := s &amp; &quot;=&quot; &amp; shortForm;
    ELSE
      ns := s;
    END; (* if *)
    TYPECASE a OF &lt;*NOWARN*&gt;
    | FlagArgState =&gt;
        ns := Text.Cat(ns, &quot;/f&quot;);
    | StringListArgState =&gt;
        ns := Text.Cat(ns, &quot;/l&quot;);
    | StringArgState =&gt;
        ns := ns &amp; &quot;/1&quot;;
        IF opt = Opt.Required THEN
          ns := Text.Cat(ns, &quot;/r&quot;);
        END;
    | PrefixArgState =&gt;
        ns := ns &amp; &quot;/l/x&quot;
    END;
    IF opt = Opt.Positional THEN ns := Text.Cat(ns, &quot;/p&quot;) END;
    RETURN ns;
  END ArgsArgName;

PROCEDURE <A NAME="GetFlag"><procedure>GetFlag</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT): BOOLEAN RAISES {} =
  BEGIN
    TRY
      RETURN Args.Flag(args_g.handle, s)
    EXCEPT
    | Args.BadEnquiry =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END GetFlag;

PROCEDURE <A NAME="GetString"><procedure>GetString</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT): TEXT
    RAISES {} =
  BEGIN
    TRY
      RETURN Args.Single(args_g.handle, s);
    EXCEPT
    | Args.BadEnquiry =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END GetString;

PROCEDURE <A NAME="GetStringList"><procedure>GetStringList</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT): REF ARRAY OF TEXT
    RAISES {} =
  BEGIN
    TRY
      RETURN Args.Value(args_g.handle, s);
    EXCEPT
    | Args.BadEnquiry =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END GetStringList;

PROCEDURE <A NAME="GetPrefix"><procedure>GetPrefix</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT): REF ARRAY OF TEXT
    RAISES {} =
  BEGIN
    TRY
      RETURN Args.Value(args_g.handle, s);
    EXCEPT
    | Args.BadEnquiry =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END GetPrefix;

PROCEDURE <A NAME="SetFlag"><procedure>SetFlag</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT; f: BOOLEAN) RAISES {} =
  VAR v: REF ARRAY OF TEXT;
  BEGIN
    IF f THEN v := NEW(REF ARRAY OF TEXT, 0) ELSE v := NIL END;
    TRY
      Args.Bind(args_g.handle, s, v, TRUE);
    EXCEPT
    | Args.BadBinding =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END SetFlag;

PROCEDURE <A NAME="SetString"><procedure>SetString</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT; val: TEXT)
    RAISES {} =
  VAR v: REF ARRAY OF TEXT;
  BEGIN
    v := NEW(REF ARRAY OF TEXT, 1); v[0] := val;
    TRY
      Args.Bind(args_g.handle, s, v, TRUE);
    EXCEPT
    | Args.BadBinding =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END SetString;

PROCEDURE <A NAME="SetStringList"><procedure>SetStringList</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT; sl: REF ARRAY OF TEXT)
    RAISES {} =
  BEGIN
    TRY
      Args.Bind(args_g.handle, s, sl, TRUE);
    EXCEPT
    | Args.BadBinding =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END SetStringList;

PROCEDURE <A NAME="SetPrefix"><procedure>SetPrefix</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT; sl: REF ARRAY OF TEXT)
    RAISES {} =
  BEGIN
    TRY
      Args.Bind(args_g.handle, s, sl, TRUE);
    EXCEPT
    | Args.BadBinding =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END SetPrefix;

PROCEDURE <A NAME="SetStringAsList"><procedure>SetStringAsList</procedure></A>(&lt;*UNUSED*&gt; t: T; s: TEXT; sl: TEXT) RAISES {} =
  VAR
    start, end, l: CARDINAL;
    count := 0;
    v: REF ARRAY OF TEXT;
  BEGIN
    start := 0; end := 0;
    l := Text.Length(sl);
    LOOP
      IF TextExtras.FindCharSet(sl, ASCII.Set{' ', ','}, end) THEN END;
      IF end &gt;= l THEN EXIT END;
      start := end+1; end := start;
      INC(count);
    END;
    v := NEW(REF ARRAY OF TEXT, count);
    start := 0; end := 0; count := 0;
    LOOP
      IF TextExtras.FindCharSet(sl, ASCII.Set{' ', ','}, end) THEN END;
      v[count] := TextExtras.Extract(sl, start, end);
      INC(count);
      IF end &gt;= l THEN EXIT END;
      start := end+1; end := start;
    END;
    TRY
      Args.Bind(args_g.handle, s, v, TRUE);
    EXCEPT
    | Args.BadBinding =&gt; &lt;*ASSERT FALSE*&gt;
    END;
  END SetStringAsList;

PROCEDURE <A NAME="IsDuplicated"><procedure>IsDuplicated</procedure></A>(argName, shortForm: TEXT;
                       isPrefix: BOOLEAN; shared: BOOLEAN): BOOLEAN=
  PROCEDURE IsPrefixOf(t, pre: TEXT): BOOLEAN=
    VAR
      index: CARDINAL := 0;
    BEGIN
      RETURN TextExtras.FindSub(t, pre, index) AND index = 0
    END IsPrefixOf;

  VAR
    tl, al: RefList.T; t: T;
    a: ArgState;
    hasShort: BOOLEAN;
    result: BOOLEAN := FALSE;
  BEGIN
    hasShort := NOT Text.Equal(shortForm, &quot;&quot;);
    tl := toolList_g;
    WHILE tl # NIL DO
      t := tl.head;
      al := t.argList;
      WHILE al # NIL DO
        a := al.head;
        (* both the full name and the short form must be unique *)
        IF isPrefix THEN
          IF IsPrefixOf(a.name, argName) OR
            (hasShort AND IsPrefixOf(ShortFormOf(a.nameAndKind), argName)) THEN
            &lt;*FATAL ClashingShortform*&gt; BEGIN RAISE ClashingShortform; END;
          END; (* if *)
        ELSIF TextExtras.CIEqual(argName, a.name) THEN
          IF NOT(shared AND a.shared) THEN result := TRUE; END;
        ELSIF (hasShort AND (TextExtras.CIEqual(shortForm,
                            ShortFormOf(a.nameAndKind)))) THEN
            &lt;*FATAL ClashingShortform*&gt; BEGIN RAISE ClashingShortform; END;
        END; (* if *)
        al := al.tail;
      END; (* while *)
      tl := tl.tail;
    END;
    RETURN result;
  END IsDuplicated;

PROCEDURE <A NAME="ShortFormOf"><procedure>ShortFormOf</procedure></A>(nameAndKind: TEXT): TEXT RAISES {} =
  VAR
    index, sindex: CARDINAL;
    nameAndShort: TEXT;
  BEGIN
    index := 0;
    IF TextExtras.FindChar(nameAndKind, '=', index) THEN
      sindex := index+1;
      IF TextExtras.FindChar(nameAndKind, '/', index) THEN
        nameAndShort := TextExtras.Extract(nameAndKind, sindex, index);
        RETURN nameAndShort;
      END;
    END;
    RETURN &quot;&quot;;
  END ShortFormOf;

BEGIN
  args_g.init := FALSE; args_g.keyString := &quot;&quot;;
END M3Args.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
