<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/M3Time.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/M3Time.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3Time.i3">M3Time</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>;

REVEAL
  <A NAME="T">T</A> = BRANDED REF RECORD t: LONGREAL END;

PROCEDURE <A NAME="Now"><procedure>Now</procedure></A>(): T RAISES {} =
  BEGIN
    RETURN NEW(T, t := Time.Now());
  END Now;

PROCEDURE <A NAME="Interval"><procedure>Interval</procedure></A>(t: T): T RAISES {} =
  VAR nt: T := Now();
  BEGIN
    nt.t := nt.t -  t.t;
    RETURN nt;
  END Interval;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(t1, t2: T): T RAISES {} =
  BEGIN
    RETURN NEW(T, t := t1.t + t2.t);
  END Add;

PROCEDURE <A NAME="AsString"><procedure>AsString</procedure></A>(t: T): TEXT RAISES {} =
  BEGIN
    RETURN Fmt.LongReal(t.t, Fmt.Style.Fix, prec := 2);
  END AsString;

PROCEDURE <A NAME="Zero"><procedure>Zero</procedure></A>(): T RAISES {} =
  BEGIN
    RETURN NEW(T, t := 0.0d0);
  END Zero;

BEGIN
END M3Time.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
