<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/RdExtras.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/RdExtras.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="RdExtras.i3">RdExtras</A></implements></module>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="Skip"><procedure>Skip</procedure></A>(
    s: Rd.T;
    READONLY skip := ASCII.Spaces;
    unget := TRUE)
    : CHAR
    RAISES {Rd.Failure, Rd.EndOfFile, Thread.Alerted}=
  VAR ch: CHAR;
  BEGIN
    REPEAT
      ch := Rd.GetChar(s);
    UNTIL NOT(ch IN skip);
    IF unget THEN Rd.UnGetChar(s) END;
    RETURN ch;
  END Skip;

PROCEDURE <A NAME="GetUntil"><procedure>GetUntil</procedure></A>(
    s: Rd.T;
    VAR chars: ARRAY OF CHAR;
    READONLY terminate := ASCII.Spaces;
    unget := TRUE)
    : CARDINAL
    RAISES {Rd.Failure, Thread.Alerted}=
  VAR ch: CHAR; i := 0;
  BEGIN
    LOOP
      TRY
        ch := Rd.GetChar(s);
        IF ch IN terminate THEN
          IF unget THEN Rd.UnGetChar(s) END;
          EXIT
        END;
        IF i = NUMBER(chars) THEN
          INC(i);
          EXIT
        ELSE chars[i] := ch; INC(i);
        END;
      EXCEPT Rd.EndOfFile =&gt; EXIT;
      END;
    END;
    RETURN i;
  END GetUntil;

PROCEDURE <A NAME="GetChars"><procedure>GetChars</procedure></A>(
    s: Rd.T;
    VAR chars: ARRAY OF CHAR;
    READONLY skip := ASCII.Spaces;
    READONLY terminate := ASCII.Spaces;
    unget := TRUE)
    : CARDINAL
    RAISES {Rd.Failure, Rd.EndOfFile, Thread.Alerted}=
  BEGIN
    EVAL Skip(s, skip);
    RETURN GetUntil(s, chars, terminate, unget);
  END GetChars;

PROCEDURE <A NAME="GetText"><procedure>GetText</procedure></A>(
    s: Rd.T;
    READONLY skip := ASCII.Set{};
    READONLY terminate := ASCII.Spaces;
    unget := TRUE)
    : TEXT
    RAISES {Rd.Failure, Rd.EndOfFile, Thread.Alerted}=
  VAR chars: ARRAY [0..255] OF CHAR;
      result: TEXT := &quot;&quot;;
      len: CARDINAL;
  BEGIN
    EVAL Skip(s, skip);
    REPEAT
      len := GetUntil(s, chars, terminate, unget);
      result := result &amp; Text.FromChars(SUBARRAY(chars, 0, len));
    UNTIL len &lt;= NUMBER(chars);
    RETURN result;
  END GetText;

BEGIN
END RdExtras.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
